/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.interpreter.ReachabilityCountingInterpreter;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.jvm.JvmDfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DataFlowIRProvider;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.dfaassist.DebuggerDfaListener;
import com.intellij.debugger.engine.dfaassist.DfaAssistProvider;
import com.intellij.debugger.engine.dfaassist.JdiValueInfo;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.StackFrameProxyEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.xdebugger.impl.dfaassist.DfaResult;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerDfaRunner {
    @NotNull
    private final PsiElement myBody;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ControlFlow myFlow;
    @NotNull
    private final PsiElement myAnchor;
    @NotNull
    private final DfaInstructionState myStartingState;
    private final long myModificationStamp;
    private final DfaValueFactory myFactory;
    private final DfaAssistProvider myProvider;

    DebuggerDfaRunner(@NotNull Larva larva, @NotNull Map<Value, JdiValueInfo> infoMap) {
        if (larva == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(0);
        }
        if (infoMap == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(1);
        }
        this.myFactory = larva.myFactory;
        this.myBody = larva.myBody;
        this.myProject = larva.myProject;
        this.myProvider = larva.myProvider;
        this.myAnchor = larva.myAnchor;
        this.myFlow = larva.myFlow;
        DfaMemoryState state = this.createMemoryState(this.myFactory, larva.myJdiToDfa, infoMap);
        this.myStartingState = new DfaInstructionState(this.myFlow.getInstruction(larva.myOffset), state);
        this.myModificationStamp = larva.myStamp;
    }

    @NotNull
    public DfaResult computeHints() {
        DfaInstructionState startingState;
        if (PsiModificationTracker.getInstance((Project)this.myProject).getModificationCount() != this.myModificationStamp) {
            DfaResult dfaResult = DfaResult.EMPTY;
            if (dfaResult == null) {
                DebuggerDfaRunner.$$$reportNull$$$0(2);
            }
            return dfaResult;
        }
        DebuggerDfaListener interceptor = this.myProvider.createListener();
        DfaMemoryState memoryState = this.myStartingState.getMemoryState().createCopy();
        final int startingIndex = this.myStartingState.getInstruction().getIndex();
        ReachabilityCountingInterpreter interpreter = new ReachabilityCountingInterpreter(this, this.myFlow, interceptor, true, false, startingIndex){

            protected DfaInstructionState @NotNull [] acceptInstruction(@NotNull DfaInstructionState instructionState) {
                if (instructionState == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object[] states = super.acceptInstruction(instructionState);
                DfaInstructionState[] dfaInstructionStateArray = (DfaInstructionState[])((StreamEx)StreamEx.of((Object[])states).filter(state -> state.getInstruction().getIndex() > startingIndex)).toArray((Object[])DfaInstructionState.EMPTY_ARRAY);
                if (dfaInstructionStateArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dfaInstructionStateArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instructionState";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/engine/dfaassist/DebuggerDfaRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/engine/dfaassist/DebuggerDfaRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "acceptInstruction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "acceptInstruction";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        if (interpreter.interpret(List.of(startingState = new DfaInstructionState(this.myStartingState.getInstruction(), memoryState))) != RunnerResult.OK) {
            DfaResult dfaResult = DfaResult.EMPTY;
            if (dfaResult == null) {
                DebuggerDfaRunner.$$$reportNull$$$0(3);
            }
            return dfaResult;
        }
        Set unreachable = interpreter.getUnreachable();
        Collection segments = DataFlowIRProvider.computeUnreachableSegments((PsiElement)this.myAnchor, (Set)unreachable);
        return new DfaResult(this.myBody.getContainingFile(), interceptor.computeHints(), segments);
    }

    @NotNull
    private DfaMemoryState createMemoryState(@NotNull DfaValueFactory factory, @NotNull Map<Value, List<DfaVariableValue>> valueMap, @NotNull Map<Value, JdiValueInfo> infoMap) {
        if (factory == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(4);
        }
        if (valueMap == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(5);
        }
        if (infoMap == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(6);
        }
        JvmDfaMemoryStateImpl state = new JvmDfaMemoryStateImpl(factory);
        ArrayList distinctValues = new ArrayList();
        valueMap.forEach((arg_0, arg_1) -> this.lambda$createMemoryState$0(distinctValues, (DfaMemoryState)state, infoMap, arg_0, arg_1));
        ((EntryStream)EntryStream.ofPairs(distinctValues).filterKeyValue((left, right) -> left.getDfType().meet(right.getDfType()) != DfType.BOTTOM).limit(20L)).forKeyValue((arg_0, arg_1) -> DebuggerDfaRunner.lambda$createMemoryState$2((DfaMemoryState)state, arg_0, arg_1));
        JvmDfaMemoryStateImpl jvmDfaMemoryStateImpl = state;
        if (jvmDfaMemoryStateImpl == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(7);
        }
        return jvmDfaMemoryStateImpl;
    }

    private void addConditions(@NotNull DfaVariableValue var, @Nullable JdiValueInfo valueInfo, @NotNull DfaMemoryState state) {
        if (var == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(8);
        }
        if (state == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(9);
        }
        if (valueInfo instanceof JdiValueInfo.PrimitiveConstant) {
            JdiValueInfo.PrimitiveConstant primitiveConstant = (JdiValueInfo.PrimitiveConstant)valueInfo;
            DfConstantType<?> type = primitiveConstant.getDfType();
            if (type.meet(var.getDfType()) != DfType.BOTTOM) {
                ((DfaMemoryStateImpl)state).recordVariableType(var, type);
            }
        } else if (valueInfo instanceof JdiValueInfo.StringConstant) {
            JdiValueInfo.StringConstant stringConstant = (JdiValueInfo.StringConstant)valueInfo;
            TypeConstraint stringType = this.myProvider.constraintFromJvmClassName(this.myBody, "java/lang/String");
            state.applyCondition(var.eq((DfType)DfTypes.referenceConstant((Object)stringConstant.getValue(), (TypeConstraint)stringType)));
        } else if (valueInfo instanceof JdiValueInfo.ObjectRef) {
            JdiValueInfo.ObjectRef objectRef = (JdiValueInfo.ObjectRef)valueInfo;
            TypeConstraint exactType = this.getType(this.myBody, objectRef.getSignature());
            if (exactType == TypeConstraints.TOP) {
                state.meetDfType((DfaValue)var, (DfType)DfTypes.NOT_NULL_OBJECT);
                return;
            }
            state.meetDfType((DfaValue)var, exactType.asDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT));
            if (valueInfo instanceof JdiValueInfo.EnumConstant) {
                PsiField enumConst;
                PsiClass enumClass;
                JdiValueInfo.EnumConstant enumConstant = (JdiValueInfo.EnumConstant)valueInfo;
                String name = enumConstant.getName();
                if (exactType.isEnum() && (enumClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)exactType.getPsiType(this.myProject))) != null && (enumConst = enumClass.findFieldByName(name, false)) instanceof PsiEnumConstant) {
                    state.applyCondition(var.eq((DfType)DfTypes.referenceConstant((Object)enumConst, (TypeConstraint)exactType)));
                }
            }
            if (valueInfo instanceof JdiValueInfo.ObjectWithSpecialField) {
                JdiValueInfo.ObjectWithSpecialField withSpecialField = (JdiValueInfo.ObjectWithSpecialField)valueInfo;
                SpecialField field = withSpecialField.getField();
                JdiValueInfo fieldValue = withSpecialField.getValue();
                DfaVariableValue dfaField = (DfaVariableValue)ObjectUtils.tryCast((Object)field.createValue(this.myFactory, (DfaValue)var), DfaVariableValue.class);
                if (dfaField != null) {
                    this.addConditions(dfaField, fieldValue, state);
                }
            }
        }
    }

    @NotNull
    private TypeConstraint getType(@NotNull PsiElement context, @NotNull String signature) {
        int arrayDepth;
        if (context == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(10);
        }
        if (signature == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(11);
        }
        for (arrayDepth = 0; signature.length() > arrayDepth && signature.charAt(arrayDepth) == '['; ++arrayDepth) {
        }
        TypeConstraint constraint = null;
        String nonArraySig = signature.substring(arrayDepth);
        if (nonArraySig.length() == 1) {
            PsiPrimitiveType primitiveType;
            if (arrayDepth > 0) {
                --arrayDepth;
            }
            if ((primitiveType = PsiPrimitiveType.fromJvmTypeDescriptor((char)nonArraySig.charAt(0))) != null) {
                constraint = TypeConstraints.exact((PsiType)primitiveType.createArrayType());
            }
        } else if (nonArraySig.startsWith("L") && nonArraySig.endsWith(";")) {
            String jvmType = nonArraySig.substring(1, nonArraySig.length() - 1);
            constraint = this.myProvider.constraintFromJvmClassName(context, jvmType);
        }
        if (constraint == null) {
            TypeConstraint typeConstraint = TypeConstraints.TOP;
            if (typeConstraint == null) {
                DebuggerDfaRunner.$$$reportNull$$$0(12);
            }
            return typeConstraint;
        }
        for (int i = 0; i < arrayDepth; ++i) {
            constraint = constraint.arrayOf();
        }
        TypeConstraint typeConstraint = constraint;
        if (typeConstraint == null) {
            DebuggerDfaRunner.$$$reportNull$$$0(13);
        }
        return typeConstraint;
    }

    private static /* synthetic */ void lambda$createMemoryState$2(DfaMemoryState state, DfaVariableValue left, DfaVariableValue right) {
        state.applyCondition(left.cond(RelationType.NE, (DfaValue)right));
    }

    private /* synthetic */ void lambda$createMemoryState$0(List distinctValues, DfaMemoryState state, Map infoMap, Value jdiValue, List vars) {
        DfaVariableValue canonical = (DfaVariableValue)vars.get(0);
        if (!TypeConstraint.fromDfType((DfType)canonical.getDfType()).isComparedByEquals()) {
            distinctValues.add(canonical);
        }
        for (DfaVariableValue var : vars) {
            state.applyCondition(var.eq((DfaValue)canonical));
            this.addConditions(var, (JdiValueInfo)infoMap.get(jdiValue), state);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 7, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "larva";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoMap";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/dfaassist/DebuggerDfaRunner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/dfaassist/DebuggerDfaRunner";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHints";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemoryState";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMemoryState";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addConditions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 7, 12, 13 -> new IllegalStateException(string);
        };
    }

    static class Larva {
        @NotNull
        private final Project myProject;
        @NotNull
        private final PsiElement myAnchor;
        @NotNull
        private final PsiElement myBody;
        @NotNull
        private final ControlFlow myFlow;
        @NotNull
        private final DfaValueFactory myFactory;
        private final long myStamp;
        @NotNull
        private final DfaAssistProvider myProvider;
        @NotNull
        private final Map<Value, List<DfaVariableValue>> myJdiToDfa;
        @NotNull
        private final StackFrameProxyEx myProxy;
        private final int myOffset;

        /*
         * WARNING - void declaration
         */
        Larva(@NotNull Project project, @NotNull PsiElement anchor, @NotNull PsiElement body, @NotNull ControlFlow flow, @NotNull DfaValueFactory factory, long stamp, @NotNull DfaAssistProvider provider, @NotNull Map<Value, List<DfaVariableValue>> jdiToDfa, @NotNull StackFrameProxyEx proxy, int n) {
            void offset;
            if (project == null) {
                Larva.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                Larva.$$$reportNull$$$0(1);
            }
            if (body == null) {
                Larva.$$$reportNull$$$0(2);
            }
            if (flow == null) {
                Larva.$$$reportNull$$$0(3);
            }
            if (factory == null) {
                Larva.$$$reportNull$$$0(4);
            }
            if (provider == null) {
                Larva.$$$reportNull$$$0(5);
            }
            if (jdiToDfa == null) {
                Larva.$$$reportNull$$$0(6);
            }
            if (proxy == null) {
                Larva.$$$reportNull$$$0(7);
            }
            this.myProject = project;
            this.myAnchor = anchor;
            this.myBody = body;
            this.myFlow = flow;
            this.myFactory = factory;
            this.myStamp = stamp;
            this.myProvider = provider;
            this.myJdiToDfa = jdiToDfa;
            this.myProxy = proxy;
            this.myOffset = offset;
        }

        @NotNull
        Pupa pupate() throws EvaluateException {
            ApplicationManager.getApplication().assertReadAccessNotAllowed();
            return new Pupa(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "body";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "flow";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "factory";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jdiToDfa";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[0] = "proxy";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/dfaassist/DebuggerDfaRunner$Larva";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Pupa {
        @NotNull
        private final Larva myLarva;
        @NotNull
        private final Map<Value, JdiValueInfo> myInfoMap;

        Pupa(@NotNull Larva larva) throws EvaluateException {
            if (larva == null) {
                Pupa.$$$reportNull$$$0(0);
            }
            this.myLarva = larva;
            this.myInfoMap = Pupa.requestJdi(larva.myProxy, larva.myJdiToDfa);
        }

        @RequiresReadLock
        @Nullable
        DebuggerDfaRunner transform() {
            ThreadingAssertions.softAssertReadAccess();
            if (PsiModificationTracker.getInstance((Project)this.myLarva.myProject).getModificationCount() != this.myLarva.myStamp) {
                return null;
            }
            return new DebuggerDfaRunner(this.myLarva, this.myInfoMap);
        }

        @NotNull
        private static Map<Value, JdiValueInfo> requestJdi(@NotNull StackFrameProxyEx proxy, @NotNull Map<Value, List<DfaVariableValue>> map2) throws EvaluateException {
            if (proxy == null) {
                Pupa.$$$reportNull$$$0(1);
            }
            if (map2 == null) {
                Pupa.$$$reportNull$$$0(2);
            }
            final ClassLoaderReference classLoader = proxy.getClassLoader();
            Predicate<ClassLoaderReference> classLoaderFilter = new Predicate<ClassLoaderReference>(){
                @Nullable
                private List<ClassLoaderReference> myParentLoaders = null;

                @Override
                public boolean test(ClassLoaderReference loader) {
                    if (loader == null || loader.equals(classLoader)) {
                        return true;
                    }
                    return this.getParentLoaders().contains(loader);
                }

                @NotNull
                private List<ClassLoaderReference> getParentLoaders() {
                    if (this.myParentLoaders == null) {
                        List loaders = Collections.emptyList();
                        if (classLoader != null) {
                            Field parent;
                            ClassType classLoaderClass;
                            for (classLoaderClass = (ClassType)classLoader.referenceType(); classLoaderClass != null && !"java.lang.ClassLoader".equals(classLoaderClass.name()); classLoaderClass = classLoaderClass.superclass()) {
                            }
                            if (classLoaderClass != null && (parent = DebuggerUtils.findField((ReferenceType)classLoaderClass, (String)"parent")) != null) {
                                loaders = StreamEx.iterate((Object)classLoader, Objects::nonNull, loader -> (ClassLoaderReference)ObjectUtils.tryCast((Object)loader.getValue(parent), ClassLoaderReference.class)).toList();
                            }
                        }
                        this.myParentLoaders = loaders;
                    }
                    List<ClassLoaderReference> list = this.myParentLoaders;
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/dfaassist/DebuggerDfaRunner$Pupa$1", "getParentLoaders"));
                }
            };
            Map map3 = StreamEx.ofKeys(map2).mapToEntry(value -> JdiValueInfo.from(value, classLoaderFilter)).nonNullValues().toMap();
            if (map3 == null) {
                Pupa.$$$reportNull$$$0(3);
            }
            return map3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "larva";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "proxy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/engine/dfaassist/DebuggerDfaRunner$Pupa";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/engine/dfaassist/DebuggerDfaRunner$Pupa";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "requestJdi";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "requestJdi";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

