/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.dfaassist;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.dfaassist.DebuggerDfaRunnerUtilsKt;
import com.intellij.debugger.engine.dfaassist.DfaAssistProvider;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.impl.dfaassist.DfaAssistBase;
import com.intellij.xdebugger.impl.dfaassist.DfaResult;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfaAssist
extends DfaAssistBase
implements DebuggerContextListener,
XDebuggerManagerListener {
    private static final int CLEANUP_DELAY_MILLIS = 300;
    private volatile Job myComputation;
    private volatile Job scheduledCleanup;
    private volatile boolean myInactive;
    private final DebuggerStateManager myManager;

    private DfaAssist(@NotNull Project project, @NotNull DebuggerStateManager manager) {
        if (project == null) {
            DfaAssist.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DfaAssist.$$$reportNull$$$0(1);
        }
        super(project);
        this.myInactive = false;
        project.getMessageBus().connect((Disposable)this).subscribe(XDebuggerManager.TOPIC, (Object)this);
        this.myManager = manager;
        this.updateFromSettings();
    }

    void setComputation(Job computation) {
        this.myComputation = computation;
    }

    void displayInlaysInternal(DfaResult result) {
        this.displayInlays(result);
    }

    private void updateFromSettings() {
        DfaAssistBase.AssistMode newMode = DfaAssist.fromSettings();
        if (this.myMode != newMode) {
            this.myMode = newMode;
            this.update();
        }
    }

    private void update() {
        if (this.myMode == DfaAssistBase.AssistMode.NONE || this.myInactive) {
            this.cleanUp();
        } else {
            DebuggerSession session = this.myManager.getContext().getDebuggerSession();
            if (session != null) {
                DebuggerInvocationUtil.invokeLater(this.myProject, () -> session.refresh(false));
            }
        }
    }

    public void currentSessionChanged(@Nullable XDebugSession previousSession, @Nullable XDebugSession currentSession) {
        DebuggerSession session = this.myManager.getContext().getDebuggerSession();
        if (session != null) {
            XDebugSession xDebugSession = session.getXDebugSession();
            if (xDebugSession == previousSession && !this.myInactive) {
                this.myInactive = true;
                this.update();
            } else if (xDebugSession == currentSession && this.myInactive) {
                this.myInactive = false;
                this.update();
            }
        }
    }

    @Override
    public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
        if (newContext == null) {
            DfaAssist.$$$reportNull$$$0(2);
        }
        if (event == DebuggerSession.Event.DISPOSE) {
            Disposer.dispose((Disposable)this);
            return;
        }
        if (this.myMode == DfaAssistBase.AssistMode.NONE) {
            return;
        }
        if (event == DebuggerSession.Event.DETACHED) {
            this.cleanUp();
            return;
        }
        if (event == DebuggerSession.Event.RESUME) {
            this.cancelAllSceduledJobs();
            this.scheduledCleanup = EdtScheduler.getInstance().schedule(300, this::cleanUp);
        }
        if (event != DebuggerSession.Event.PAUSE && event != DebuggerSession.Event.REFRESH) {
            return;
        }
        SourcePosition sourcePosition = newContext.getSourcePosition();
        if (sourcePosition == null) {
            this.cleanUp();
            return;
        }
        DfaAssistProvider provider = (DfaAssistProvider)DfaAssistProvider.EP_NAME.forLanguage(sourcePosition.getFile().getLanguage());
        DebugProcessImpl debugProcess = newContext.getDebugProcess();
        PsiElement element = sourcePosition.getElementAt();
        if (debugProcess == null || provider == null || element == null) {
            this.cleanUp();
            return;
        }
        DebuggerDfaRunnerUtilsKt.scheduleDfaUpdate(this, newContext, element);
    }

    public void dispose() {
        this.myManager.removeListener(this);
        this.cleanUp();
    }

    void cancelComputation() {
        DfaAssist.safeCancelJob(this.myComputation);
    }

    private void cancelAllSceduledJobs() {
        this.cancelComputation();
        DfaAssist.safeCancelJob(this.scheduledCleanup);
    }

    private static void safeCancelJob(Job computation) {
        if (computation != null) {
            computation.cancel(null);
        }
    }

    protected void cleanUp() {
        this.cancelAllSceduledJobs();
        super.cleanUp();
    }

    public static void installDfaAssist(@NotNull DebuggerSession javaSession, @NotNull XDebugSession session, @NotNull Disposable parent) {
        DebuggerStateManager manager;
        DebuggerContextImpl context;
        Project project;
        if (javaSession == null) {
            DfaAssist.$$$reportNull$$$0(3);
        }
        if (session == null) {
            DfaAssist.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            DfaAssist.$$$reportNull$$$0(5);
        }
        if ((project = (context = (manager = javaSession.getContextManager()).getContext()).getProject()) != null) {
            final DfaAssist assist = new DfaAssist(project, manager);
            Disposer.register((Disposable)parent, (Disposable)assist);
            manager.addListener(assist);
            session.addSessionListener(new XDebugSessionListener(){

                public void settingsChanged() {
                    assist.updateFromSettings();
                }
            }, (Disposable)assist);
        }
    }

    private static DfaAssistBase.AssistMode fromSettings() {
        ViewsGeneralSettings settings = ViewsGeneralSettings.getInstance();
        if (settings.USE_DFA_ASSIST && settings.USE_DFA_ASSIST_GRAY_OUT) {
            return DfaAssistBase.AssistMode.BOTH;
        }
        if (settings.USE_DFA_ASSIST) {
            return DfaAssistBase.AssistMode.INLAYS;
        }
        if (settings.USE_DFA_ASSIST_GRAY_OUT) {
            return DfaAssistBase.AssistMode.GRAY_OUT;
        }
        return DfaAssistBase.AssistMode.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSession";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/dfaassist/DfaAssist";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "changeEvent";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "installDfaAssist";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

