/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.AdditionalContextProvider;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluationContextWrapper;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.Value;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class CodeFragmentFactoryContextWrapper
extends CodeFragmentFactory {
    public static final Key<Value> LABEL_VARIABLE_VALUE_KEY = Key.create((String)"_label_variable_value_key_");
    public static final String DEBUG_LABEL_SUFFIX = "_DebugLabel";
    private final CodeFragmentFactory myDelegate;

    public CodeFragmentFactoryContextWrapper(CodeFragmentFactory delegate) {
        this.myDelegate = delegate;
    }

    public PsiCodeFragment createPsiCodeFragment(TextWithImports item, PsiElement context, Project project) {
        return CodeFragmentFactoryContextWrapper.prepareResolveScope(this.myDelegate.createPsiCodeFragment(item, this.wrapContext(project, context), project));
    }

    public PsiCodeFragment createPresentationPsiCodeFragment(TextWithImports item, PsiElement context, Project project) {
        return CodeFragmentFactoryContextWrapper.prepareResolveScope(this.myDelegate.createPresentationPsiCodeFragment(item, this.wrapContext(project, context), project));
    }

    public boolean isContextAccepted(PsiElement contextElement) {
        return this.myDelegate.isContextAccepted(contextElement);
    }

    @NotNull
    public LanguageFileType getFileType() {
        LanguageFileType languageFileType = this.myDelegate.getFileType();
        if (languageFileType == null) {
            CodeFragmentFactoryContextWrapper.$$$reportNull$$$0(0);
        }
        return languageFileType;
    }

    public EvaluatorBuilder getEvaluatorBuilder() {
        return this.myDelegate.getEvaluatorBuilder();
    }

    private static PsiCodeFragment prepareResolveScope(PsiCodeFragment codeFragment) {
        final GlobalSearchScope originalResolveScope = codeFragment.getResolveScope();
        codeFragment.forceResolveScope((GlobalSearchScope)new DelegatingGlobalSearchScope(GlobalSearchScope.allScope((Project)codeFragment.getProject())){
            final Comparator<VirtualFile> myScopeComparator;
            {
                super(arg0);
                this.myScopeComparator = Comparator.comparing(file -> originalResolveScope.contains(file)).thenComparing((x$0, x$1) -> super.compare(x$0, x$1));
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return this.myScopeComparator.compare(file1, file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/engine/evaluation/CodeFragmentFactoryContextWrapper$1";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return codeFragment;
    }

    private PsiElement wrapContext(Project project, PsiElement originalContext) {
        if (project.isDefault()) {
            return originalContext;
        }
        EvaluationContextWrapper wrapper = this.myDelegate.createEvaluationContextWrapper();
        if (wrapper == null) {
            return originalContext;
        }
        return wrapper.wrapContext(project, originalContext, AdditionalContextProvider.getAllAdditionalContextElements((Project)project, (PsiElement)originalContext));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/CodeFragmentFactoryContextWrapper", "getFileType"));
    }
}

