/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class DebuggerImplicitEvaluationContextUtil {
    private static final Key<LightOrRealThreadInfo> IMPLICIT_EVALUATION_READY_THREAD_KEY = new Key("ImplicitEvaluationThread");

    public static LightOrRealThreadInfo getImplicitEvaluationThread(DebugProcess process) {
        return (LightOrRealThreadInfo)process.getUserData(IMPLICIT_EVALUATION_READY_THREAD_KEY);
    }

    public static void provideImplicitEvaluationThread(DebugProcess process, LightOrRealThreadInfo thread) {
        process.putUserData(IMPLICIT_EVALUATION_READY_THREAD_KEY, (Object)thread);
    }
}

