/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaDebuggerCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluationContextWrapper;
import com.intellij.debugger.engine.evaluation.JavaEvaluationContextWrapper;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultCodeFragmentFactory
extends JavaDebuggerCodeFragmentFactory {
    public static final Key<String> KEY = Key.create((String)"DefaultCodeFragmentFactory.KEY");

    public static DefaultCodeFragmentFactory getInstance() {
        return SingletonHolder.ourInstance;
    }

    @Override
    protected JavaCodeFragment createPresentationPsiCodeFragmentImpl(@NotNull TextWithImports item, PsiElement context, @NotNull Project project) {
        if (item == null) {
            DefaultCodeFragmentFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DefaultCodeFragmentFactory.$$$reportNull$$$0(1);
        }
        return this.createPsiCodeFragment(item, context, project);
    }

    @Override
    public JavaCodeFragment createPsiCodeFragmentImpl(TextWithImports item, PsiElement context, @NotNull Project project) {
        if (project == null) {
            DefaultCodeFragmentFactory.$$$reportNull$$$0(2);
        }
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project);
        String text = item.getText();
        JavaCodeFragment fragment = null;
        if (CodeFragmentKind.EXPRESSION == item.getKind()) {
            try {
                String expressionText = StringUtil.trimTrailing((String)text, (char)';');
                if (!expressionText.isEmpty()) {
                    JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(expressionText, context);
                }
                fragment = factory.createExpressionCodeFragment(expressionText, context, null, true);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        if (fragment == null) {
            fragment = factory.createCodeBlockCodeFragment(text, context, true);
        }
        if (!item.getImports().isEmpty()) {
            fragment.addImportsFromString(item.getImports());
        }
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        fragment.putUserData(KEY, (Object)"DebuggerComboBoxEditor.IS_DEBUGGER_EDITOR");
        fragment.putCopyableUserData(JavaCompletionUtil.DYNAMIC_TYPE_EVALUATOR, (expression, parameters) -> {
            if (!RuntimeTypeEvaluator.isSubtypeable(expression)) {
                return null;
            }
            if (parameters.getInvocationCount() <= 1 && JavaCompletionUtil.mayHaveSideEffects((PsiElement)expression)) {
                CompletionService.getCompletionService().setAdvertisementText(JavaDebuggerBundle.message((String)"invoke.completion.once.more", (Object[])new Object[0]));
                return null;
            }
            DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(project).getContext();
            DebuggerManagerThreadImpl managerThread = debuggerContext.getManagerThread();
            if (managerThread != null) {
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                final AtomicReference nameRef = new AtomicReference();
                RuntimeTypeEvaluator worker = new RuntimeTypeEvaluator(this, null, (PsiElement)expression, debuggerContext, ProgressManager.getInstance().getProgressIndicator()){

                    @Override
                    protected void typeCalculationFinished(@Nullable PsiType type) {
                        nameRef.set(type);
                        semaphore.up();
                    }
                };
                managerThread.invoke(worker);
                for (int i = 0; i < 50; ++i) {
                    ProgressManager.checkCanceled();
                    if (semaphore.waitFor(20L)) break;
                }
                return (PsiType)nameRef.get();
            }
            return null;
        });
        return fragment;
    }

    public boolean isContextAccepted(PsiElement contextElement) {
        return true;
    }

    @NotNull
    public LanguageFileType getFileType() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        if (javaFileType == null) {
            DefaultCodeFragmentFactory.$$$reportNull$$$0(3);
        }
        return javaFileType;
    }

    public EvaluatorBuilder getEvaluatorBuilder() {
        return EvaluatorBuilderImpl.getInstance();
    }

    public EvaluationContextWrapper createEvaluationContextWrapper() {
        return new JavaEvaluationContextWrapper();
    }

    public static boolean isDebuggerFile(PsiFile file) {
        return KEY.isIn((UserDataHolder)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/evaluation/DefaultCodeFragmentFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/evaluation/DefaultCodeFragmentFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPresentationPsiCodeFragmentImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPsiCodeFragmentImpl";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class SingletonHolder {
        public static final DefaultCodeFragmentFactory ourInstance = new DefaultCodeFragmentFactory();

        private SingletonHolder() {
        }
    }
}

