/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextWithImportsImpl
implements TextWithImports {
    private final CodeFragmentKind myKind;
    private String myText;
    private final FileType myFileType;
    private final String myImports;
    private static final char SEPARATOR = '\r';

    public TextWithImportsImpl(@NotNull PsiElement expression) {
        if (expression == null) {
            TextWithImportsImpl.$$$reportNull$$$0(0);
        }
        this.myKind = CodeFragmentKind.EXPRESSION;
        String text = expression.getText();
        PsiFile containingFile = expression.getContainingFile();
        if (containingFile instanceof PsiExpressionCodeFragment) {
            this.myText = text;
            this.myImports = ((JavaCodeFragment)containingFile).importsToString();
            this.myFileType = JavaFileType.INSTANCE;
        } else {
            Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text);
            this.myText = (String)trinity.first;
            this.myImports = (String)trinity.second;
            this.myFileType = (FileType)trinity.third;
        }
    }

    public TextWithImportsImpl(CodeFragmentKind kind, @NotNull String text, @NotNull String imports, @Nullable FileType fileType) {
        if (text == null) {
            TextWithImportsImpl.$$$reportNull$$$0(1);
        }
        if (imports == null) {
            TextWithImportsImpl.$$$reportNull$$$0(2);
        }
        this.myKind = kind;
        this.myText = text;
        this.myImports = imports;
        this.myFileType = fileType;
    }

    public TextWithImportsImpl(CodeFragmentKind kind, @NotNull String text) {
        if (text == null) {
            TextWithImportsImpl.$$$reportNull$$$0(3);
        }
        this.myKind = kind;
        Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text);
        this.myText = (String)trinity.first;
        this.myImports = (String)trinity.second;
        this.myFileType = (FileType)trinity.third;
    }

    private static Trinity<String, String, FileType> parseExternalForm(String s) {
        String[] split = s.split(String.valueOf('\r'));
        return Trinity.create((Object)split[0], (Object)(split.length > 1 ? split[1] : ""), split.length > 2 ? FileTypeManager.getInstance().getStdFileType(split[2]) : null);
    }

    public CodeFragmentKind getKind() {
        return this.myKind;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getImports() {
        String string = this.myImports;
        if (string == null) {
            TextWithImportsImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof TextWithImportsImpl)) return false;
        TextWithImportsImpl item = (TextWithImportsImpl)object;
        if (!Objects.equals(item.myText, this.myText)) return false;
        if (!Objects.equals(item.myImports, this.myImports)) return false;
        return true;
    }

    public String toString() {
        return this.getText();
    }

    public String toExternalForm() {
        Object result = this.myText;
        if (StringUtil.isNotEmpty((String)this.myImports) || this.myFileType != null) {
            result = (String)result + "\r" + this.myImports;
        }
        if (this.myFileType != null) {
            result = (String)result + "\r" + this.myFileType.getName();
        }
        return result;
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean isEmpty() {
        return StringUtil.isEmptyOrSpaces((String)this.getText());
    }

    public void setText(String newText) {
        this.myText = newText;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    @Nullable
    public static XExpression toXExpression(@Nullable TextWithImports text) {
        if (text != null && !text.getText().isEmpty()) {
            FileType fileType = text.getFileType();
            return new XExpressionImpl(text.getText(), fileType == null ? null : LanguageUtil.getFileTypeLanguage((FileType)fileType), StringUtil.nullize((String)text.getImports()), TextWithImportsImpl.getMode(text.getKind()));
        }
        return null;
    }

    @NotNull
    private static EvaluationMode getMode(@NotNull CodeFragmentKind kind) {
        if (kind == null) {
            TextWithImportsImpl.$$$reportNull$$$0(5);
        }
        EvaluationMode evaluationMode = switch (kind) {
            default -> throw new MatchException(null, null);
            case CodeFragmentKind.EXPRESSION -> EvaluationMode.EXPRESSION;
            case CodeFragmentKind.CODE_BLOCK -> EvaluationMode.CODE_FRAGMENT;
        };
        if (evaluationMode == null) {
            TextWithImportsImpl.$$$reportNull$$$0(6);
        }
        return evaluationMode;
    }

    @NotNull
    private static CodeFragmentKind getKind(@NotNull EvaluationMode mode) {
        if (mode == null) {
            TextWithImportsImpl.$$$reportNull$$$0(7);
        }
        CodeFragmentKind codeFragmentKind = switch (mode) {
            default -> throw new MatchException(null, null);
            case EvaluationMode.EXPRESSION -> CodeFragmentKind.EXPRESSION;
            case EvaluationMode.CODE_FRAGMENT -> CodeFragmentKind.CODE_BLOCK;
        };
        if (codeFragmentKind == null) {
            TextWithImportsImpl.$$$reportNull$$$0(8);
        }
        return codeFragmentKind;
    }

    public static TextWithImports fromXExpression(@Nullable XExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression.getCustomInfo() == null && expression.getLanguage() == null) {
            return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression.getMode()), expression.getExpression());
        }
        return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression.getMode()), expression.getExpression(), StringUtil.notNullize((String)expression.getCustomInfo()), LanguageUtil.getLanguageFileType((Language)expression.getLanguage()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/evaluation/TextWithImportsImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/evaluation/TextWithImportsImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImports";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8 -> new IllegalStateException(string);
        };
    }
}

