/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.ModifiableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ModifiableValue;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class AssignmentEvaluator
implements ModifiableEvaluator {
    private final Evaluator myLeftEvaluator;
    private final Evaluator myRightEvaluator;

    public AssignmentEvaluator(@NotNull Evaluator leftEvaluator, @NotNull Evaluator rightEvaluator) {
        if (leftEvaluator == null) {
            AssignmentEvaluator.$$$reportNull$$$0(0);
        }
        if (rightEvaluator == null) {
            AssignmentEvaluator.$$$reportNull$$$0(1);
        }
        this.myLeftEvaluator = leftEvaluator;
        this.myRightEvaluator = DisableGC.create(rightEvaluator);
    }

    @Override
    @NotNull
    public ModifiableValue evaluateModifiable(@NotNull EvaluationContextImpl context) throws EvaluateException {
        if (context == null) {
            AssignmentEvaluator.$$$reportNull$$$0(2);
        }
        Modifier modifier = this.myLeftEvaluator.evaluateModifiable(context).getModifier();
        Object right = this.myRightEvaluator.evaluate(context);
        if (right != null && !(right instanceof Value)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.not.rvalue", (Object[])new Object[0]));
        }
        AssignmentEvaluator.assign(modifier, right, context);
        return new ModifiableValue(right, modifier);
    }

    static void assign(Modifier modifier, Object right, EvaluationContextImpl context) throws EvaluateException {
        if (modifier == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.not.lvalue", (Object[])new Object[0]));
        }
        try {
            modifier.setValue((Value)right);
        }
        catch (ClassNotLoadedException e) {
            if (!context.isAutoLoadClasses()) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            try {
                ReferenceType referenceType = context.getDebugProcess().loadClass(context, e, context.getClassLoader());
                if (referenceType == null) {
                    throw e;
                }
                AssignmentEvaluator.assign(modifier, right, context);
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException e1) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e1);
            }
        }
        catch (InvalidTypeException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    @Override
    public Modifier getModifier() {
        return this.myLeftEvaluator.getModifier();
    }

    public String toString() {
        return String.valueOf(this.myLeftEvaluator) + " = " + String.valueOf(this.myRightEvaluator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftEvaluator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightEvaluator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/evaluation/expression/AssignmentEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateModifiable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

