/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;

public class BoxingEvaluator
implements Evaluator {
    private final Evaluator myOperand;

    public BoxingEvaluator(Evaluator operand) {
        this.myOperand = DisableGC.create(operand);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        return BoxingEvaluator.box(this.myOperand.evaluate(context), context);
    }

    public static Object box(Object value, EvaluationContextImpl context) throws EvaluateException {
        PrimitiveValue primitiveValue;
        PsiPrimitiveType primitiveType;
        if (value instanceof PrimitiveValue && (primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)(primitiveValue = (PrimitiveValue)value).type().name())) != null) {
            return BoxingEvaluator.convertToWrapper(context, primitiveValue, primitiveType.getBoxedTypeName());
        }
        return value;
    }

    private static Value convertToWrapper(EvaluationContextImpl context, PrimitiveValue value, String wrapperTypeName) throws EvaluateException {
        String methodSignature;
        DebugProcessImpl process = context.getDebugProcess();
        ClassType wrapperClass = (ClassType)process.findClass(context, wrapperTypeName, null);
        Method method = DebuggerUtils.findMethod((ReferenceType)wrapperClass, (String)"valueOf", (String)(methodSignature = "(" + JVMNameUtil.getPrimitiveSignature(value.type().name()) + ")L" + wrapperTypeName.replace('.', '/') + ";"));
        if (method == null) {
            method = DebuggerUtils.findMethod((ReferenceType)wrapperClass, (String)"<init>", (String)methodSignature);
        }
        if (method == null) {
            throw new EvaluateException("Cannot construct wrapper object for value of type " + String.valueOf(value.type()) + ": Unable to find either valueOf() or constructor method");
        }
        Method finalMethod = method;
        List<PrimitiveValue> args = Collections.singletonList(value);
        return context.computeAndKeep(() -> process.invokeMethod(context, wrapperClass, finalMethod, args, true));
    }
}

