/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.BlockStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFragmentEvaluator
extends BlockStatementEvaluator {
    private static final Logger LOG = Logger.getInstance(CodeFragmentEvaluator.class);
    private final CodeFragmentEvaluator myParentFragmentEvaluator;
    private final Map<String, Object> mySyntheticLocals = new HashMap<String, Object>();

    public CodeFragmentEvaluator(CodeFragmentEvaluator parentFragmentEvaluator) {
        super(null);
        this.myParentFragmentEvaluator = parentFragmentEvaluator;
    }

    public void setStatements(Evaluator[] evaluators) {
        this.myStatements = evaluators;
    }

    public Value getValue(@NotNull String localName, @NotNull EvaluationContextImpl context) throws EvaluateException {
        if (localName == null) {
            CodeFragmentEvaluator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CodeFragmentEvaluator.$$$reportNull$$$0(1);
        }
        return this.getValue(localName, context.getSuspendContext().getVirtualMachineProxy(), context);
    }

    @Deprecated
    public Value getValue(@NotNull String localName, @NotNull VirtualMachineProxyImpl vm) throws EvaluateException {
        if (localName == null) {
            CodeFragmentEvaluator.$$$reportNull$$$0(2);
        }
        if (vm == null) {
            CodeFragmentEvaluator.$$$reportNull$$$0(3);
        }
        return this.getValue(localName, vm, null);
    }

    private Value getValue(@NotNull String localName, @NotNull VirtualMachineProxyImpl vm, @Nullable EvaluationContextImpl context) throws EvaluateException {
        if (localName == null) {
            CodeFragmentEvaluator.$$$reportNull$$$0(4);
        }
        if (vm == null) {
            CodeFragmentEvaluator.$$$reportNull$$$0(5);
        }
        if (!this.mySyntheticLocals.containsKey(localName)) {
            if (this.myParentFragmentEvaluator != null) {
                return this.myParentFragmentEvaluator.getValue(localName, vm);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.variable.not.declared", (Object[])new Object[]{localName}));
        }
        Object value = this.mySyntheticLocals.get(localName);
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return vm.mirrorOf((Boolean)value);
        }
        if (value instanceof Byte) {
            return vm.mirrorOf((Byte)value);
        }
        if (value instanceof Character) {
            return vm.mirrorOf(((Character)value).charValue());
        }
        if (value instanceof Short) {
            return vm.mirrorOf((Short)value);
        }
        if (value instanceof Integer) {
            return vm.mirrorOf((Integer)value);
        }
        if (value instanceof Long) {
            return vm.mirrorOf((Long)value);
        }
        if (value instanceof Float) {
            return vm.mirrorOf(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return vm.mirrorOf((Double)value);
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return context != null ? DebuggerUtilsEx.mirrorOfString(stringValue, context) : vm.getVirtualMachine().mirrorOf(stringValue);
        }
        LOG.error("unknown default initializer type " + value.getClass().getName());
        return null;
    }

    boolean hasValue(String localName) {
        if (!this.mySyntheticLocals.containsKey(localName)) {
            if (this.myParentFragmentEvaluator != null) {
                return this.myParentFragmentEvaluator.hasValue(localName);
            }
            return false;
        }
        return true;
    }

    public void setInitialValue(String localName, Object value) {
        LOG.assertTrue(!(value instanceof Value), (Object)"use setValue for jdi values");
        if (this.hasValue(localName)) {
            throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.variable.already.declared", (Object[])new Object[]{localName})));
        }
        this.mySyntheticLocals.put(localName, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String localName, Value value) throws EvaluateException {
        if (!this.mySyntheticLocals.containsKey(localName)) {
            if (this.myParentFragmentEvaluator == null) throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.variable.not.declared", (Object[])new Object[]{localName}));
            this.myParentFragmentEvaluator.setValue(localName, value);
            return;
        } else {
            this.mySyntheticLocals.put(localName, value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "localName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "vm";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/engine/evaluation/expression/CodeFragmentEvaluator";
        objectArray[2] = "getValue";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

