/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.ModifiableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ModifiableValue;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldEvaluator
implements ModifiableEvaluator {
    private final Evaluator myObjectEvaluator;
    private final TargetClassFilter myTargetClassFilter;
    private final String myFieldName;
    @Deprecated
    private Object myEvaluatedQualifier;
    @Deprecated
    private Field myEvaluatedField;

    public FieldEvaluator(Evaluator objectEvaluator, TargetClassFilter filter, @NonNls String fieldName) {
        this.myObjectEvaluator = objectEvaluator;
        this.myFieldName = fieldName;
        this.myTargetClassFilter = filter;
    }

    @NotNull
    public static TargetClassFilter createClassFilter(@Nullable PsiType psiType) {
        if (psiType == null || psiType instanceof PsiArrayType) {
            TargetClassFilter targetClassFilter = TargetClassFilter.ALL;
            if (targetClassFilter == null) {
                FieldEvaluator.$$$reportNull$$$0(0);
            }
            return targetClassFilter;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiClass != null) {
            TargetClassFilter targetClassFilter = FieldEvaluator.createClassFilter(psiClass);
            if (targetClassFilter == null) {
                FieldEvaluator.$$$reportNull$$$0(1);
            }
            return targetClassFilter;
        }
        return new FQNameClassFilter(psiType.getCanonicalText());
    }

    public static TargetClassFilter createClassFilter(PsiClass psiClass) {
        if (psiClass instanceof PsiAnonymousClass) {
            return TargetClassFilter.ALL;
        }
        if (PsiUtil.isLocalClass((PsiClass)psiClass)) {
            return new LocalClassFilter(psiClass.getName());
        }
        String name = JVMNameUtil.getClassVMName(psiClass);
        return name != null ? new FQNameClassFilter(name) : TargetClassFilter.ALL;
    }

    @Nullable
    private Field findField(@Nullable Type t) {
        if (t instanceof ClassType) {
            ClassType cls = (ClassType)t;
            if (this.myTargetClassFilter.acceptClass(cls)) {
                return DebuggerUtils.findField((ReferenceType)cls, (String)this.myFieldName);
            }
            for (InterfaceType interfaceType : cls.interfaces()) {
                Field field = this.findField(interfaceType);
                if (field == null) continue;
                return field;
            }
            return this.findField(cls.superclass());
        }
        if (t instanceof InterfaceType) {
            InterfaceType iface = (InterfaceType)t;
            if (this.myTargetClassFilter.acceptClass(iface)) {
                return DebuggerUtils.findField((ReferenceType)iface, (String)this.myFieldName);
            }
            for (InterfaceType interfaceType : iface.superinterfaces()) {
                Field field = this.findField(interfaceType);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public ModifiableValue evaluateModifiable(EvaluationContextImpl context) throws EvaluateException {
        Object object = this.myObjectEvaluator.evaluate(context);
        if (object instanceof ReferenceType) {
            ReferenceType refType = (ReferenceType)object;
            Field field = this.findField(refType);
            if (field == null || !field.isStatic()) {
                field = DebuggerUtils.findField((ReferenceType)refType, (String)this.myFieldName);
            }
            if (field == null || !field.isStatic()) {
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.no.static.field", (Object[])new Object[]{this.myFieldName}));
            }
            MyModifier modifier = new MyModifier(refType, field);
            this.myEvaluatedField = field;
            this.myEvaluatedQualifier = refType;
            return new ModifiableValue(refType.getValue(field), modifier);
        }
        if (object instanceof ObjectReference) {
            ObjectReference objRef = (ObjectReference)object;
            ReferenceType refType = objRef.referenceType();
            if (!(refType instanceof ClassType) && !(refType instanceof ArrayType)) {
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.class.or.array.expected", (Object[])new Object[]{this.myFieldName}));
            }
            if (objRef instanceof ArrayReference && "length".equals(this.myFieldName)) {
                return new ModifiableValue(context.getVirtualMachineProxy().mirrorOf(((ArrayReference)objRef).length()), null);
            }
            Field field = this.findField(refType);
            if (field == null) {
                field = DebuggerUtils.findField((ReferenceType)refType, (String)this.myFieldName);
            }
            if (field == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.no.instance.field", (Object[])new Object[]{this.myFieldName}));
            }
            Mirror qualifier = field.isStatic() ? refType : objRef;
            MyModifier modifier = new MyModifier(qualifier, field);
            this.myEvaluatedQualifier = qualifier;
            this.myEvaluatedField = field;
            return new ModifiableValue(field.isStatic() ? refType.getValue(field) : objRef.getValue(field), modifier);
        }
        if (object == null) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)new NullPointerException());
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.evaluating.field", (Object[])new Object[]{this.myFieldName}));
    }

    @Override
    public Modifier getModifier() {
        if (this.myEvaluatedField != null && (this.myEvaluatedQualifier instanceof ClassType || this.myEvaluatedQualifier instanceof ObjectReference)) {
            return new MyModifier(this.myEvaluatedQualifier, this.myEvaluatedField);
        }
        return null;
    }

    public String toString() {
        return "field " + this.myFieldName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/expression/FieldEvaluator", "createClassFilter"));
    }

    public static interface TargetClassFilter {
        public static final TargetClassFilter ALL = refType -> true;

        public boolean acceptClass(ReferenceType var1);
    }

    private static final class FQNameClassFilter
    implements TargetClassFilter {
        private final String myQName;

        private FQNameClassFilter(String qName) {
            this.myQName = qName;
        }

        @Override
        public boolean acceptClass(ReferenceType refType) {
            return refType.name().equals(this.myQName);
        }
    }

    private static final class LocalClassFilter
    implements TargetClassFilter {
        private final String myLocalClassShortName;

        private LocalClassFilter(String localClassShortName) {
            this.myLocalClassShortName = localClassShortName;
        }

        @Override
        public boolean acceptClass(ReferenceType refType) {
            String name = refType.name();
            int index = name.lastIndexOf(this.myLocalClassShortName);
            if (index < 0) {
                return false;
            }
            for (int idx = index - 1; idx >= 0; --idx) {
                char ch = name.charAt(idx);
                if (ch == '$') {
                    return idx < index - 1;
                }
                if (Character.isDigit(ch)) continue;
                return false;
            }
            return false;
        }
    }

    private static class MyModifier
    implements Modifier {
        private final Object myEvaluatedQualifier;
        private final Field myEvaluatedField;

        private MyModifier(Object qualifier, Field field) {
            this.myEvaluatedQualifier = qualifier;
            this.myEvaluatedField = field;
        }

        public boolean canInspect() {
            return this.myEvaluatedQualifier instanceof ObjectReference;
        }

        public boolean canSetValue() {
            return true;
        }

        public void setValue(Value value) throws ClassNotLoadedException, InvalidTypeException {
            if (this.myEvaluatedQualifier instanceof ReferenceType) {
                ClassType classType = (ClassType)this.myEvaluatedQualifier;
                classType.setValue(this.myEvaluatedField, value);
            } else {
                ObjectReference objRef = (ObjectReference)this.myEvaluatedQualifier;
                objRef.setValue(this.myEvaluatedField, value);
            }
        }

        public Type getExpectedType() throws ClassNotLoadedException {
            return this.myEvaluatedField.type();
        }

        public NodeDescriptorImpl getInspectItem(Project project) {
            if (this.myEvaluatedQualifier instanceof ObjectReference) {
                return new FieldDescriptorImpl(project, (ObjectReference)this.myEvaluatedQualifier, this.myEvaluatedField);
            }
            return null;
        }
    }
}

