/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.AssignmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.SyntheticVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternEvaluator
implements Evaluator {
    @Nullable
    private final String myPrimitiveType;
    @Nullable
    protected final TypeEvaluator myTypeEvaluator;
    @Nullable
    protected final SyntheticVariableEvaluator myVariableEvaluator;

    public PatternEvaluator(@NotNull TypeEvaluator typeEvaluator, @Nullable SyntheticVariableEvaluator variableEvaluator) {
        if (typeEvaluator == null) {
            PatternEvaluator.$$$reportNull$$$0(0);
        }
        this.myPrimitiveType = null;
        this.myTypeEvaluator = typeEvaluator;
        this.myVariableEvaluator = variableEvaluator;
    }

    public PatternEvaluator(@NotNull String primitiveType, @Nullable SyntheticVariableEvaluator variableEvaluator) {
        if (primitiveType == null) {
            PatternEvaluator.$$$reportNull$$$0(1);
        }
        this.myPrimitiveType = primitiveType;
        this.myTypeEvaluator = null;
        this.myVariableEvaluator = variableEvaluator;
    }

    boolean match(Value value, EvaluationContextImpl context) throws EvaluateException {
        boolean res = false;
        if (this.myTypeEvaluator != null) {
            Type type = value.type();
            if (type instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)type;
                res = DebuggerUtilsImpl.instanceOf(referenceType, this.myTypeEvaluator.evaluate(context));
            }
        } else {
            Type type = value.type();
            if (type instanceof PrimitiveType) {
                PrimitiveType primitiveType = (PrimitiveType)type;
                res = primitiveType.name().equals(this.myPrimitiveType);
            }
        }
        if (res && this.myVariableEvaluator != null) {
            AssignmentEvaluator.assign(this.myVariableEvaluator.evaluateModifiable(context).getModifier(), value, context);
        }
        return res;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        return null;
    }

    public String toString() {
        if (this.myPrimitiveType != null) {
            return this.myPrimitiveType + " " + String.valueOf(this.myVariableEvaluator);
        }
        return String.valueOf(this.myTypeEvaluator) + " " + String.valueOf(this.myVariableEvaluator == null ? "" : this.myVariableEvaluator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "typeEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "primitiveType";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/engine/evaluation/expression/PatternEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

