/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.PatternEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

class PatternLabelEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance(PatternLabelEvaluator.class);
    @NotNull
    protected final Evaluator myOperandEvaluator;
    @NotNull
    protected final PatternEvaluator myPatternEvaluator;

    PatternLabelEvaluator(@NotNull Evaluator operandEvaluator, @NotNull PatternEvaluator patternEvaluator) {
        if (operandEvaluator == null) {
            PatternLabelEvaluator.$$$reportNull$$$0(0);
        }
        if (patternEvaluator == null) {
            PatternLabelEvaluator.$$$reportNull$$$0(1);
        }
        this.myOperandEvaluator = operandEvaluator;
        this.myPatternEvaluator = patternEvaluator;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Value value = (Value)this.myOperandEvaluator.evaluate(context);
        if (value == null) {
            return context.getVirtualMachineProxy().mirrorOf(false);
        }
        if (!(value instanceof ObjectReference)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.object.reference.expected", (Object[])new Object[0]));
        }
        try {
            boolean res = this.myPatternEvaluator.match(value, context);
            return context.getVirtualMachineProxy().mirrorOf(res);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    public String toString() {
        return String.valueOf(this.myPatternEvaluator.myTypeEvaluator) + " " + String.valueOf(this.myPatternEvaluator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "operandEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "patternEvaluator";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/engine/evaluation/expression/PatternLabelEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

