/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.events;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectCollectedException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\b\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/debugger/engine/events/DebuggerContextCommandImpl;", "Lcom/intellij/debugger/engine/events/SuspendContextCommandImpl;", "debuggerContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "customThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "<init>", "(Lcom/intellij/debugger/impl/DebuggerContextImpl;Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;)V", "getDebuggerContext", "()Lcom/intellij/debugger/impl/DebuggerContextImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "suspendContext$delegate", "Lkotlin/Lazy;", "thread", "getThread", "()Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "contextAction", "", "threadAction", "Companion", "intellij.java.debugger.impl"})
public abstract class DebuggerContextCommandImpl
extends SuspendContextCommandImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DebuggerContextImpl debuggerContext;
    @Nullable
    private final ThreadReferenceProxyImpl customThread;
    @NotNull
    private final Lazy suspendContext$delegate;
    @NotNull
    private static final Logger LOG;

    @JvmOverloads
    protected DebuggerContextCommandImpl(@NotNull DebuggerContextImpl debuggerContext, @Nullable ThreadReferenceProxyImpl customThread) {
        Intrinsics.checkNotNullParameter((Object)debuggerContext, (String)"debuggerContext");
        super(debuggerContext.getSuspendContext());
        this.debuggerContext = debuggerContext;
        this.customThread = customThread;
        this.suspendContext$delegate = LazyKt.lazy(() -> DebuggerContextCommandImpl.suspendContext_delegate$lambda$0(this));
    }

    public /* synthetic */ DebuggerContextCommandImpl(DebuggerContextImpl debuggerContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            threadReferenceProxyImpl = null;
        }
        this(debuggerContextImpl, threadReferenceProxyImpl);
    }

    @NotNull
    public final DebuggerContextImpl getDebuggerContext() {
        return this.debuggerContext;
    }

    @Override
    @Nullable
    public SuspendContextImpl getSuspendContext() {
        Lazy lazy = this.suspendContext$delegate;
        return (SuspendContextImpl)((Object)lazy.getValue());
    }

    private final ThreadReferenceProxyImpl getThread() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.customThread;
        if (threadReferenceProxyImpl == null) {
            threadReferenceProxyImpl = this.debuggerContext.getThreadProxy();
        }
        return threadReferenceProxyImpl;
    }

    @Override
    public final void contextAction(@NotNull SuspendContextImpl suspendContext) {
        boolean isSuspended;
        Intrinsics.checkNotNullParameter((Object)((Object)suspendContext), (String)"suspendContext");
        SuspendManager suspendManager = suspendContext.getDebugProcess().getSuspendManager();
        Intrinsics.checkNotNullExpressionValue((Object)suspendManager, (String)"getSuspendManager(...)");
        SuspendManager suspendManager2 = suspendManager;
        ThreadReferenceProxyImpl thread = this.getThread();
        if (thread == null) {
            v1 = suspendContext.getSuspendPolicy() == 2;
        } else {
            boolean bl;
            try {
                bl = suspendManager2.isSuspended(thread);
            }
            catch (ObjectCollectedException objectCollectedException) {
                this.notifyCancelled();
                return;
            }
            v1 = isSuspended = bl;
        }
        if (isSuspended) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Context thread " + suspendContext.getThread());
                LOG.debug("Debug thread " + thread);
            }
            this.threadAction(suspendContext);
        } else {
            SuspendContextImpl suspendContextForThread;
            SuspendContextImpl suspendContextImpl = suspendContextForThread = this.customThread != null ? suspendContext : SuspendManagerUtil.findContextByThread(suspendManager2, thread);
            if (suspendContextForThread != null && (thread == null || thread.status() != 0)) {
                suspendContextForThread.postponeCommand(this);
            } else {
                this.notifyCancelled();
            }
        }
    }

    public abstract void threadAction(@NotNull SuspendContextImpl var1);

    @JvmOverloads
    protected DebuggerContextCommandImpl(@NotNull DebuggerContextImpl debuggerContext) {
        Intrinsics.checkNotNullParameter((Object)debuggerContext, (String)"debuggerContext");
        this(debuggerContext, null, 2, null);
    }

    private static final SuspendContextImpl suspendContext_delegate$lambda$0(DebuggerContextCommandImpl this$0) {
        SuspendContextImpl suspendContextImpl;
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        SuspendContextImpl context = super.getSuspendContext();
        if (this$0.customThread == null) {
            suspendContextImpl = context;
        } else if (context == null || context.isResumed() || !context.suspends(this$0.customThread)) {
            DebugProcessImpl debugProcessImpl = this$0.debuggerContext.getDebugProcess();
            Intrinsics.checkNotNull((Object)((Object)debugProcessImpl));
            suspendContextImpl = SuspendManagerUtil.getPausedSuspendingContext(debugProcessImpl.getSuspendManager(), this$0.customThread);
            if (suspendContextImpl == null) {
                DebugProcessImpl debugProcessImpl2 = this$0.debuggerContext.getDebugProcess();
                Intrinsics.checkNotNull((Object)((Object)debugProcessImpl2));
                suspendContextImpl = SuspendManagerUtil.findContextByThread(debugProcessImpl2.getSuspendManager(), this$0.customThread);
            }
        } else {
            suspendContextImpl = context;
        }
        return suspendContextImpl;
    }

    static {
        Logger logger = Logger.getInstance(DebuggerContextCommandImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/debugger/engine/events/DebuggerContextCommandImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.java.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

