/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.feedback;

import com.intellij.debugger.feedback.KotlinDebuggerFeedbackSurveyBundle;
import com.intellij.debugger.feedback.KotlinDebuggerSurveyFeedbackDialog;
import com.intellij.debugger.feedback.UsageTracker;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.util.PlatformUtils;
import java.time.Month;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\rH\u0016J \u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/debugger/feedback/KotlinDebuggerFeedbackSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "<init>", "()V", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "", "getRequireIdeEAP", "()Z", "minimalNumberOfDebuggerUsage", "", "checkIdeIsSuitable", "checkExtraConditionSatisfied", "project", "Lcom/intellij/openapi/project/Project;", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "forTest", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "updateStateAfterNotificationShowed", "", "updateStateAfterDialogClosedOk", "intellij.java.debugger.impl"})
public final class KotlinDebuggerFeedbackSurveyConfig
implements InIdeFeedbackSurveyConfig {
    @NotNull
    private final String surveyId;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2024, Month.JULY, 1);
    private final boolean requireIdeEAP;
    private final int minimalNumberOfDebuggerUsage;

    public KotlinDebuggerFeedbackSurveyConfig() {
        this.surveyId = "kotlin_debugger_feedback_survey";
        this.minimalNumberOfDebuggerUsage = 5;
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return PlatformUtils.isIdeaCommunity() || PlatformUtils.isIdeaUltimate();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = ApplicationInfo.getInstance().getFullVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullVersion(...)");
        return StringsKt.startsWith$default((String)string, (String)"2024.1", (boolean)false, (int)2, null) && UsageTracker.Companion.kotlinDebuggedTimes() >= this.minimalNumberOfDebuggerUsage;
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new RequestFeedbackNotification("Feedback In IDE", KotlinDebuggerFeedbackSurveyBundle.INSTANCE.message("kotlin.debugger.feedback.notification.request.title", new Object[0]), "");
    }

    @NotNull
    public BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new KotlinDebuggerSurveyFeedbackDialog(project, forTest);
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }
}

