/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.JdiHelperClassLoader;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.VMDisconnectedException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class ClassLoadingUtils {
    private ClassLoadingUtils() {
    }

    public static ClassLoaderReference getClassLoader(EvaluationContext context, DebugProcess process) throws EvaluateException {
        try {
            ClassType loaderClass = (ClassType)process.findClass(context, "java.security.SecureClassLoader", context.getClassLoader());
            Method ctorMethod = DebuggerUtils.findMethod((ReferenceType)loaderClass, (String)"<init>", (String)"(Ljava/lang/ClassLoader;)V");
            return (ClassLoaderReference)context.computeAndKeep(() -> (ClassLoaderReference)((DebugProcessImpl)process).newInstance(context, loaderClass, Objects.requireNonNull(ctorMethod), Collections.singletonList(context.getClassLoader()), 1024, true));
        }
        catch (VMDisconnectedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvaluateException("Error creating evaluation class loader: " + String.valueOf(e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defineClass(String name, byte[] bytes, EvaluationContextImpl context, ClassLoaderReference classLoader) throws EvaluateException {
        try {
            VirtualMachineProxyImpl proxy = context.getVirtualMachineProxy();
            Method defineMethod = DebuggerUtils.findMethod((ReferenceType)classLoader.referenceType(), (String)"defineClass", (String)"(Ljava/lang/String;[BII)Ljava/lang/Class;");
            StringReference nameString = DebuggerUtilsEx.mirrorOfString(name, context);
            ArrayReference byteArray = DebuggerUtilsEx.mirrorOfByteArray(bytes, context);
            try {
                context.getDebugProcess().invokeInstanceMethod(context, classLoader, Objects.requireNonNull(defineMethod), Arrays.asList(nameString, byteArray, proxy.mirrorOf(0), proxy.mirrorOf(bytes.length)), 1024, true);
            }
            finally {
                DebuggerUtilsEx.enableCollection(nameString);
                DebuggerUtilsEx.enableCollection(byteArray);
            }
        }
        catch (VMDisconnectedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvaluateException("Error during class " + name + " definition: " + String.valueOf(e), (Throwable)e);
        }
    }

    @Nullable
    public static ClassType getHelperClass(Class<?> cls, EvaluationContextImpl evaluationContext, String ... additionalClassesToLoad) {
        for (JdiHelperClassLoader loader : JdiHelperClassLoader.getLoaders(evaluationContext)) {
            try {
                ClassType classType = loader.getHelperClass(cls, evaluationContext, additionalClassesToLoad);
                if (classType == null) continue;
                return classType;
            }
            catch (EvaluateException ex) {
                String message = String.format("Failed to load '%s' with %s", cls.getName(), loader.getClass().getName());
                Logger.getInstance(ClassLoadingUtils.class).error(message, (Throwable)ex);
            }
        }
        return null;
    }
}

