/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlightingComputer;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SourceCodeChecker;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class DebuggerContextUtil {
    public static void setStackFrame(final DebuggerStateManager manager, final StackFrameProxyImpl stackFrame) {
        ThreadingAssertions.assertEventDispatchThread();
        DebuggerContextImpl context = manager.getContext();
        final DebuggerSession session = context.getDebuggerSession();
        if (session != null) {
            Objects.requireNonNull(context.getManagerThread()).schedule(new DebuggerCommandImpl(PrioritizedTask.Priority.HIGH){

                @Override
                protected void action() {
                    SuspendContextImpl threadSuspendContext = SuspendManagerUtil.findContextByThread(session.getProcess().getSuspendManager(), stackFrame.threadProxy());
                    DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(session, threadSuspendContext, stackFrame.threadProxy(), stackFrame);
                    newContext.initCaches();
                    DebuggerInvocationUtil.invokeLaterAnyModality(session.getProject(), () -> {
                        manager.setState(newContext, session.getState(), DebuggerSession.Event.REFRESH, null);
                        SourceCodeChecker.checkSource(newContext);
                    });
                }
            });
        } else {
            manager.setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.REFRESH, null);
        }
    }

    public static void setThread(DebuggerStateManager contextManager, ThreadDescriptorImpl item) {
        ThreadingAssertions.assertEventDispatchThread();
        DebuggerSession session = contextManager.getContext().getDebuggerSession();
        DebuggerContextImpl newContext = DebuggerContextImpl.createDebuggerContext(session, item.getSuspendContext(), item.getThreadReference(), null);
        contextManager.setState(newContext, session != null ? session.getState() : DebuggerSession.State.DISPOSED, DebuggerSession.Event.CONTEXT, null);
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@NotNull DebuggerSession session, SuspendContextImpl suspendContext) {
        if (session == null) {
            DebuggerContextUtil.$$$reportNull$$$0(0);
        }
        DebuggerContextImpl debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(session, suspendContext, suspendContext != null ? suspendContext.getThread() : null, null);
        if (debuggerContextImpl == null) {
            DebuggerContextUtil.$$$reportNull$$$0(1);
        }
        return debuggerContextImpl;
    }

    public static SourcePosition findNearest(@NotNull DebuggerContextImpl context, @NotNull PsiElement psi, @NotNull PsiFile file) {
        if (context == null) {
            DebuggerContextUtil.$$$reportNull$$$0(2);
        }
        if (psi == null) {
            DebuggerContextUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            DebuggerContextUtil.$$$reportNull$$$0(4);
        }
        if (psi instanceof PsiCompiledElement) {
            return null;
        }
        return DebuggerContextUtil.findNearest(context, file, (PsiElement searchScope) -> IdentifierHighlightingComputer.getUsages((PsiElement)psi, (PsiElement)searchScope, (boolean)false));
    }

    public static SourcePosition findNearest(@NotNull DebuggerContextImpl context, @NotNull PsiFile file, Function<PsiElement, Collection<TextRange>> findUsages) {
        DebuggerSession session;
        if (context == null) {
            DebuggerContextUtil.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DebuggerContextUtil.$$$reportNull$$$0(6);
        }
        if ((session = context.getDebuggerSession()) == null) {
            return null;
        }
        try {
            XDebugSession debugSession = session.getXDebugSession();
            if (debugSession == null) {
                return null;
            }
            XSourcePosition position = debugSession.getCurrentPosition();
            Editor editor = FileEditorManager.getInstance((Project)file.getProject()).getSelectedTextEditor(true);
            if (editor == null || position == null || !position.getFile().equals(file.getOriginalFile().getVirtualFile())) {
                return null;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)PositionUtil.getContextElement((StackFrameContext)context), PsiMethod.class, (boolean)false);
            PsiMethod searchScope = method != null ? method : file;
            Collection<TextRange> ranges = findUsages.apply((PsiElement)searchScope);
            int breakPointLine = position.getLine();
            int bestLine = -1;
            int bestOffset = -1;
            int textOffset = method != null ? method.getTextOffset() : -1;
            for (TextRange range : ranges) {
                if (range.getEndOffset() < textOffset) continue;
                int line = editor.offsetToLogicalPosition((int)range.getStartOffset()).line;
                if (line > bestLine && line < breakPointLine) {
                    bestLine = line;
                    bestOffset = range.getStartOffset();
                    continue;
                }
                if (line != breakPointLine) continue;
                bestOffset = range.getStartOffset();
                break;
            }
            if (bestOffset > -1) {
                return SourcePosition.createFromOffset((PsiFile)file, (int)bestOffset);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerContextUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerContextUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebuggerContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDebuggerContext";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findNearest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

