/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerCompletableFuture;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.jdi.ArrayReferenceImpl;
import com.jetbrains.jdi.ClassTypeImpl;
import com.jetbrains.jdi.EventRequestManagerImpl;
import com.jetbrains.jdi.EventSetImpl;
import com.jetbrains.jdi.InterfaceTypeImpl;
import com.jetbrains.jdi.LocationImpl;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.StringReferenceImpl;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidType;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerUtilsAsync {
    private static final Logger LOG = Logger.getInstance(DebuggerUtilsAsync.class);

    public static boolean isAsyncEnabled() {
        return Registry.is((String)"debugger.async.jdi");
    }

    public static CompletableFuture<String> getStringValue(StringReference value) {
        return DebuggerUtilsAsync.rescheduleIfNeeded(DebuggerUtilsAsync.getStringValueJdiFuture(value));
    }

    static CompletableFuture<String> getStringValueJdiFuture(StringReference value) {
        if (value instanceof StringReferenceImpl) {
            StringReferenceImpl stringReference = (StringReferenceImpl)value;
            if (DebuggerUtilsAsync.isAsyncEnabled()) {
                return stringReference.valueAsync();
            }
        }
        return CompletableFuture.completedFuture(value.value());
    }

    public static CompletableFuture<List<Method>> allMethods(ReferenceType type) {
        if (type instanceof ReferenceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ReferenceTypeImpl)type).allMethodsAsync());
        }
        return CompletableFuture.completedFuture(type.allMethods());
    }

    public static CompletableFuture<List<Field>> allFields(ReferenceType type) {
        if (type instanceof ReferenceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ReferenceTypeImpl)type).allFieldsAsync());
        }
        return CompletableFuture.completedFuture(type.allFields());
    }

    public static CompletableFuture<List<Field>> fields(ReferenceType type) {
        if (type instanceof ReferenceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ReferenceTypeImpl)type).fieldsAsync());
        }
        return CompletableFuture.completedFuture(type.fields());
    }

    public static CompletableFuture<? extends Type> type(@Nullable Value value) {
        if (value == null) {
            return CompletableFuture.completedFuture(null);
        }
        if (value instanceof ObjectReferenceImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ObjectReferenceImpl)value).typeAsync());
        }
        return CompletableFuture.completedFuture(value.type());
    }

    public static CompletableFuture<Value> getValue(ObjectReference ref, Field field) {
        if (ref instanceof ObjectReferenceImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ObjectReferenceImpl)ref).getValueAsync(field));
        }
        return CompletableFuture.completedFuture(ref.getValue(field));
    }

    public static CompletableFuture<Map<Field, Value>> getValues(ObjectReference ref, List<Field> fields) {
        if (ref instanceof ObjectReferenceImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ObjectReferenceImpl)ref).getValuesAsync(fields));
        }
        return CompletableFuture.completedFuture(ref.getValues(fields));
    }

    public static CompletableFuture<Map<Field, Value>> getValues(ReferenceType type, List<Field> fields) {
        if (type instanceof ReferenceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ReferenceTypeImpl)type).getValuesAsync(fields));
        }
        return CompletableFuture.completedFuture(type.getValues(fields));
    }

    public static CompletableFuture<List<Value>> getValues(ArrayReference ref, int index, int length) {
        if (ref instanceof ArrayReferenceImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ArrayReferenceImpl)ref).getValuesAsync(index, length));
        }
        return CompletableFuture.completedFuture(ref.getValues(index, length));
    }

    public static CompletableFuture<List<ThreadReference>> allThreads(VirtualMachine vm) {
        if (vm instanceof VirtualMachineImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((VirtualMachineImpl)vm).allThreadsAsync());
        }
        return CompletableFuture.completedFuture(vm.allThreads());
    }

    public static CompletableFuture<Integer> length(ArrayReference ref) {
        if (ref instanceof ArrayReferenceImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ArrayReferenceImpl)ref).lengthAsync());
        }
        return CompletableFuture.completedFuture(ref.length());
    }

    public static CompletableFuture<String> sourceName(ReferenceType type) {
        if (type instanceof ReferenceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ReferenceTypeImpl)type).sourceNameAsync());
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> type.sourceName());
    }

    public static CompletableFuture<List<String>> availableStrata(ReferenceType type) {
        if (type instanceof ReferenceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ReferenceTypeImpl)type).availableStrataAsync());
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> type.availableStrata());
    }

    public static CompletableFuture<List<Location>> locationsOfLine(@NotNull ReferenceType type, int lineNumber) {
        if (type == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(0);
        }
        return DebuggerUtilsAsync.locationsOfLine(type, type.virtualMachine().getDefaultStratum(), null, lineNumber);
    }

    public static List<Location> locationsOfLineSync(@NotNull ReferenceType type, int lineNumber) throws AbsentInformationException {
        if (type == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(1);
        }
        return DebuggerUtilsAsync.locationsOfLineSync(type, type.virtualMachine().getDefaultStratum(), null, lineNumber);
    }

    public static CompletableFuture<List<Location>> locationsOfLine(ReferenceType type, String stratum, String sourceName, int lineNumber) {
        if (type instanceof ReferenceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ReferenceTypeImpl)type).locationsOfLineAsync(stratum, sourceName, lineNumber));
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> type.locationsOfLine(stratum, sourceName, lineNumber));
    }

    public static List<Location> locationsOfLineSync(ReferenceType type, String stratum, String sourceName, int lineNumber) throws AbsentInformationException {
        if (type instanceof ReferenceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            try {
                return (List)((ReferenceTypeImpl)type).locationsOfLineAsync(stratum, sourceName, lineNumber).get();
            }
            catch (Exception e) {
                if (e.getCause() instanceof AbsentInformationException) {
                    throw (AbsentInformationException)e.getCause();
                }
                LOG.warn((Throwable)e);
            }
        }
        return type.locationsOfLine(stratum, sourceName, lineNumber);
    }

    public static List<Location> allLineLocationsSync(ReferenceType type) throws AbsentInformationException {
        return DebuggerUtilsAsync.allLineLocationsSync(type, type.virtualMachine().getDefaultStratum(), null);
    }

    public static List<Location> allLineLocationsSync(ReferenceType type, String stratum, String sourceName) throws AbsentInformationException {
        if (type instanceof ReferenceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            try {
                return (List)((ReferenceTypeImpl)type).allLineLocationsAsync(stratum, sourceName).get();
            }
            catch (Exception e) {
                if (e.getCause() instanceof AbsentInformationException) {
                    throw (AbsentInformationException)e.getCause();
                }
                LOG.warn((Throwable)e);
            }
        }
        return type.allLineLocations(stratum, sourceName);
    }

    public static CompletableFuture<List<Location>> allLineLocations(Method method) {
        if (method instanceof MethodImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((MethodImpl)method).allLineLocationsAsync());
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> method.allLineLocations());
    }

    public static CompletableFuture<Boolean> instanceOf(@Nullable Type subType, @NotNull String superType) {
        if (superType == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(2);
        }
        return DebuggerUtilsAsync.instanceOf(subType, superType, true);
    }

    private static CompletableFuture<Boolean> instanceOf(@Nullable Type subType, @NotNull String superType, boolean reschedule) {
        if (superType == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(3);
        }
        if (!DebuggerUtilsAsync.isAsyncEnabled()) {
            return CompletableFuture.completedFuture(DebuggerUtils.instanceOf((Type)subType, (String)superType));
        }
        if (subType == null || subType instanceof VoidType) {
            return CompletableFuture.completedFuture(false);
        }
        if (subType instanceof PrimitiveType) {
            return CompletableFuture.completedFuture(superType.equals(subType.name()));
        }
        if ("java.lang.Object".equals(superType)) {
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture<Boolean> res = new CompletableFuture<Boolean>();
        DebuggerUtilsAsync.instanceOfObject(subType, superType, res).thenRun(() -> res.complete(false));
        if (!reschedule) {
            return res;
        }
        return DebuggerUtilsAsync.reschedule(res);
    }

    private static CompletableFuture<Void> instanceOfObject(@Nullable Type subType, @NotNull String superType, CompletableFuture<Boolean> res) {
        if (superType == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(4);
        }
        if (subType == null || res.isDone()) {
            return CompletableFuture.completedFuture(null);
        }
        if (DebuggerUtilsAsync.typeEquals(subType, superType)) {
            res.complete(true);
            return CompletableFuture.completedFuture(null);
        }
        if (subType instanceof ClassType) {
            return CompletableFuture.allOf(new CompletableFuture[]{DebuggerUtilsAsync.superclass((ClassType)subType).thenCompose(s -> DebuggerUtilsAsync.instanceOfObject(s, superType, res)), DebuggerUtilsAsync.interfaces((ClassType)subType).thenCompose(interfaces -> CompletableFuture.allOf((CompletableFuture[])interfaces.stream().map(i -> DebuggerUtilsAsync.instanceOfObject(i, superType, res)).toArray(CompletableFuture[]::new)))});
        }
        if (subType instanceof InterfaceType) {
            return CompletableFuture.allOf(new CompletableFuture[]{DebuggerUtilsAsync.superinterfaces((InterfaceType)subType).thenCompose(interfaces -> CompletableFuture.allOf((CompletableFuture[])interfaces.stream().map(i -> DebuggerUtilsAsync.instanceOfObject(i, superType, res)).toArray(CompletableFuture[]::new)))});
        }
        if (subType instanceof ArrayType && superType.endsWith("[]")) {
            try {
                String superTypeItem = superType.substring(0, superType.length() - 2);
                Type subTypeItem = ((ArrayType)subType).componentType();
                return DebuggerUtilsAsync.instanceOf(subTypeItem, superTypeItem, false).thenAccept(r -> {
                    if (r.booleanValue()) {
                        res.complete(true);
                    }
                });
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                // empty catch block
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public static CompletableFuture<Void> deleteEventRequest(EventRequestManager eventRequestManager, EventRequest request) {
        if (DebuggerUtilsAsync.isAsyncEnabled() && eventRequestManager instanceof EventRequestManagerImpl) {
            return ((EventRequestManagerImpl)eventRequestManager).deleteEventRequestAsync(request);
        }
        try {
            eventRequestManager.deleteEventRequest(request);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error("Exception in EventRequestManager.deleteEventRequest", (Throwable)e, new String[]{ThreadDumper.dumpThreadsToString()});
        }
        return CompletableFuture.completedFuture(null);
    }

    private static boolean typeEquals(@NotNull Type type, @NotNull String typeName) {
        int genericPos;
        if (type == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(5);
        }
        if (typeName == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(6);
        }
        if ((genericPos = typeName.indexOf(60)) > -1) {
            typeName = typeName.substring(0, genericPos);
        }
        return type.name().replace('$', '.').equals(typeName.replace('$', '.'));
    }

    public static CompletableFuture<Type> findAnyBaseType(@NotNull Type subType, Function<? super Type, ? extends CompletableFuture<Boolean>> checker) {
        if (subType == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(7);
        }
        CompletableFuture<Type> res = new CompletableFuture<Type>();
        DebuggerUtilsAsync.findAnyBaseType(subType, checker, res).thenRun(() -> res.complete(null));
        return DebuggerUtilsAsync.reschedule(res);
    }

    private static CompletableFuture<Void> findAnyBaseType(@Nullable Type type, Function<? super Type, ? extends CompletableFuture<Boolean>> checker, CompletableFuture<Type> res) {
        if (type == null || res.isDone()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage self = checker.apply(type).thenAccept(r -> {
            if (r.booleanValue()) {
                res.complete(type);
            }
        });
        if (type instanceof ClassType) {
            return CompletableFuture.allOf(new CompletableFuture[]{self, DebuggerUtilsAsync.superclass((ClassType)type).thenCompose(s -> DebuggerUtilsAsync.findAnyBaseType(s, checker, res)), DebuggerUtilsAsync.interfaces((ClassType)type).thenCompose(interfaces -> CompletableFuture.allOf((CompletableFuture[])interfaces.stream().map(i -> DebuggerUtilsAsync.findAnyBaseType(i, checker, res)).toArray(CompletableFuture[]::new)))});
        }
        if (type instanceof InterfaceType) {
            return CompletableFuture.allOf(new CompletableFuture[]{self, DebuggerUtilsAsync.superinterfaces((InterfaceType)type).thenCompose(interfaces -> CompletableFuture.allOf((CompletableFuture[])interfaces.stream().map(i -> DebuggerUtilsAsync.findAnyBaseType(i, checker, res)).toArray(CompletableFuture[]::new)))});
        }
        return self;
    }

    public static CompletableFuture<Method> method(Location location) {
        if (location instanceof LocationImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(DebuggerUtilsEx.getMethodAsync((LocationImpl)location));
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> DebuggerUtilsEx.getMethod(location));
    }

    public static CompletableFuture<Boolean> isObsolete(Method method) {
        if (method instanceof MethodImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((MethodImpl)method).isObsoleteAsync());
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> method.isObsolete());
    }

    public static CompletableFuture<StackFrame> frame(ThreadReference thread, int index) {
        if (thread instanceof ThreadReferenceImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ThreadReferenceImpl)thread).frameAsync(index));
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> thread.frame(index));
    }

    public static CompletableFuture<List<StackFrame>> frames(ThreadReference thread, int start, int length) {
        if (thread instanceof ThreadReferenceImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ThreadReferenceImpl)thread).framesAsync(start, length));
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> thread.frames(start, length));
    }

    public static CompletableFuture<Integer> frameCount(ThreadReference thread) {
        if (thread instanceof ThreadReferenceImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((ThreadReferenceImpl)thread).frameCountAsync());
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> thread.frameCount());
    }

    public static CompletableFuture<String> nameAsync(ThreadReference thread) {
        if (thread instanceof ThreadReferenceImpl) {
            ThreadReferenceImpl threadReferenceImpl = (ThreadReferenceImpl)thread;
            if (DebuggerUtilsAsync.isAsyncEnabled()) {
                return DebuggerUtilsAsync.reschedule(threadReferenceImpl.nameAsync());
            }
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> thread.name());
    }

    public static CompletableFuture<List<Method>> methods(ReferenceType type) {
        if (type instanceof ReferenceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return ((ReferenceTypeImpl)type).methodsAsync();
        }
        return CompletableFuture.completedFuture(type.methods());
    }

    public static CompletableFuture<List<InterfaceType>> superinterfaces(InterfaceType iface) {
        if (iface instanceof InterfaceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return ((InterfaceTypeImpl)iface).superinterfacesAsync();
        }
        return CompletableFuture.completedFuture(iface.superinterfaces());
    }

    public static CompletableFuture<ClassType> superclass(ClassType cls) {
        if (cls instanceof ClassTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return ((ClassTypeImpl)cls).superclassAsync();
        }
        return CompletableFuture.completedFuture(cls.superclass());
    }

    public static CompletableFuture<List<InterfaceType>> interfaces(ClassType cls) {
        if (cls instanceof ClassTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return ((ClassTypeImpl)cls).interfacesAsync();
        }
        return CompletableFuture.completedFuture(cls.interfaces());
    }

    public static CompletableFuture<Stream<? extends ReferenceType>> supertypes(ReferenceType type) {
        if (!DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.toCompletableFuture(() -> DebuggerUtilsImpl.supertypes(type));
        }
        if (type instanceof InterfaceType) {
            return DebuggerUtilsAsync.superinterfaces((InterfaceType)type).thenApply(Collection::stream);
        }
        if (type instanceof ClassType) {
            return DebuggerUtilsAsync.superclass((ClassType)type).thenCombine(DebuggerUtilsAsync.interfaces((ClassType)type), (superclass, interfaces) -> StreamEx.ofNullable((Object)superclass).prepend((Collection)interfaces));
        }
        return CompletableFuture.completedFuture(StreamEx.empty());
    }

    public static CompletableFuture<byte[]> bytecodes(Method method) {
        if (method instanceof MethodImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return ((MethodImpl)method).bytecodesAsync();
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> method.bytecodes());
    }

    public static CompletableFuture<byte[]> constantPool(ReferenceType type) {
        if (type instanceof ReferenceTypeImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return ((ReferenceTypeImpl)type).constantPoolAsync();
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> type.constantPool());
    }

    public static CompletableFuture<Void> setEnabled(EventRequest request, boolean value) {
        EventRequestManager eventRequestManager = request.virtualMachine().eventRequestManager();
        if (eventRequestManager instanceof EventRequestManagerImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return ((EventRequestManagerImpl)eventRequestManager).setEnabledAsync(request, value);
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> request.setEnabled(value));
    }

    public static CompletableFuture<Void> suspend(VirtualMachine vm) {
        if (vm instanceof VirtualMachineImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return DebuggerUtilsAsync.reschedule(((VirtualMachineImpl)vm).suspendAsync());
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> vm.suspend());
    }

    public static CompletableFuture<Void> resume(VirtualMachine vm) {
        if (vm instanceof VirtualMachineImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return ((VirtualMachineImpl)vm).resumeAsync();
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> vm.resume());
    }

    public static CompletableFuture<Void> resume(ThreadReference thread) {
        LOG.assertTrue(thread.suspendCount() > 0, (Object)("Suspend count must be greater zero before resume, " + String.valueOf(thread)));
        if (thread instanceof ThreadReferenceImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return ((ThreadReferenceImpl)thread).resumeAsync();
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> thread.resume());
    }

    public static CompletableFuture<Void> resume(EventSet eventSet) {
        if (eventSet instanceof EventSetImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return ((EventSetImpl)eventSet).resumeAsync();
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> eventSet.resume());
    }

    public static CompletableFuture<List<ReferenceType>> allCLasses(VirtualMachine virtualMachine) {
        if (virtualMachine instanceof VirtualMachineImpl && DebuggerUtilsAsync.isAsyncEnabled()) {
            return ((VirtualMachineImpl)virtualMachine).allClassesAsync();
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> virtualMachine.allClasses());
    }

    public static CompletableFuture<Void> disableCollection(Value value) {
        if (value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            if (value instanceof ObjectReferenceImpl) {
                ObjectReferenceImpl objectReferenceImpl = (ObjectReferenceImpl)value;
                if (DebuggerUtilsAsync.isAsyncEnabled()) {
                    return objectReferenceImpl.disableCollectionAsync();
                }
            }
            return DebuggerUtilsAsync.toCompletableFuture(() -> objectReference.disableCollection());
        }
        return CompletableFuture.completedFuture(null);
    }

    static CompletableFuture<Boolean> isCollectedJdiFuture(ObjectReference reference) {
        if (reference instanceof ObjectReferenceImpl) {
            ObjectReferenceImpl objectReferenceImpl = (ObjectReferenceImpl)reference;
            if (DebuggerUtilsAsync.isAsyncEnabled()) {
                return objectReferenceImpl.isCollectedAsync();
            }
        }
        return DebuggerUtilsAsync.toCompletableFuture(() -> reference.isCollected());
    }

    private static <T> CompletableFuture<T> rescheduleIfNeeded(CompletableFuture<T> future) {
        if (future.isDone()) {
            return future;
        }
        return DebuggerUtilsAsync.reschedule(future);
    }

    public static <T> CompletableFuture<T> reschedule(CompletableFuture<T> future) {
        DebuggerManagerThreadImpl thread = DebuggerManagerThreadImpl.getCurrentThread();
        LOG.assertTrue(thread != null);
        DebuggerCommandImpl event = DebuggerManagerThreadImpl.getCurrentCommand();
        LOG.assertTrue(event != null);
        final PrioritizedTask.Priority priority = event.getPriority();
        SuspendContextImpl suspendContext = event instanceof SuspendContextCommandImpl ? ((SuspendContextCommandImpl)event).getSuspendContext() : null;
        DebuggerCompletableFuture res = new DebuggerCompletableFuture();
        future.whenComplete((r, ex) -> {
            if (DebuggerManagerThreadImpl.isManagerThread()) {
                DebuggerUtilsAsync.completeFuture(r, ex, res);
            } else if (suspendContext != null) {
                thread.schedule(new SuspendContextCommandImpl(suspendContext, (Throwable)ex, res){
                    final /* synthetic */ Throwable val$ex;
                    final /* synthetic */ CompletableFuture val$res;
                    {
                        this.val$ex = throwable;
                        this.val$res = completableFuture;
                        super(arg0);
                    }

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return priority;
                    }

                    @Override
                    public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                        if (suspendContext == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DebuggerUtilsAsync.completeFuture(r, this.val$ex, this.val$res);
                    }

                    @Override
                    protected void commandCancelled() {
                        this.val$res.cancel(false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerUtilsAsync$1", "contextAction"));
                    }
                });
            } else {
                thread.schedule(new DebuggerCommandImpl(priority, (Throwable)ex, res){
                    final /* synthetic */ Throwable val$ex;
                    final /* synthetic */ CompletableFuture val$res;
                    {
                        this.val$ex = throwable;
                        this.val$res = completableFuture;
                        super(arg0);
                    }

                    @Override
                    protected void action() {
                        DebuggerUtilsAsync.completeFuture(r, this.val$ex, this.val$res);
                    }

                    @Override
                    protected void commandCancelled() {
                        this.val$res.cancel(false);
                    }
                });
            }
        });
        return res;
    }

    public static Throwable unwrap(@Nullable Throwable throwable) {
        Throwable cause;
        while ((throwable instanceof CompletionException || throwable instanceof ExecutionException) && (cause = throwable.getCause()) != throwable) {
            throwable = cause;
        }
        return throwable;
    }

    public static <T> T logError(@NotNull Throwable throwable) {
        Throwable e;
        if (throwable == null) {
            DebuggerUtilsAsync.$$$reportNull$$$0(8);
        }
        if (!((e = DebuggerUtilsAsync.unwrap(throwable)) instanceof CancellationException)) {
            DebuggerUtilsImpl.logError(e.getMessage(), e, true);
        }
        return null;
    }

    public static <T, E extends Exception> CompletableFuture<T> toCompletableFuture(ThrowableComputable<? extends T, E> provider) {
        try {
            return CompletableFuture.completedFuture(provider.compute());
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public static <E extends Exception> CompletableFuture<Void> toCompletableFuture(ThrowableRunnable<E> provider) {
        try {
            provider.run();
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public static <T> void completeFuture(T res, Throwable ex, CompletableFuture<T> future) {
        if (ex != null) {
            future.completeExceptionally(ex);
        } else {
            future.complete(res);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsAsync";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "locationsOfLine";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "locationsOfLineSync";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "instanceOf";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "instanceOfObject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "typeEquals";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findAnyBaseType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "logError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

