/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.SourcePositionHighlighter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.jdi.GeneratedLocation;
import com.intellij.debugger.jdi.GeneratedReferenceType;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.ui.CollectionHistoryView;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.settings.DebuggerSettingsUtils;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.java.debugger.impl.shared.SharedDebuggerUtils;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.threadDumpParser.ThreadState;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.content.Content;
import com.intellij.unscramble.DumpItemKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.jdi.ArrayReferenceImpl;
import com.jetbrains.jdi.JNITypeParser;
import com.jetbrains.jdi.LocationImpl;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class DebuggerUtilsEx
extends DebuggerUtils {
    private static final Logger LOG = Logger.getInstance(DebuggerUtilsEx.class);
    private static final Key<Map<String, String>> DEBUGGER_ALTERNATIVE_SOURCE_MAPPING = Key.create((String)"DEBUGGER_ALTERNATIVE_SOURCE_MAPPING");
    public static final Comparator<Method> LAMBDA_ORDINAL_COMPARATOR = Comparator.comparingInt(m -> DebuggerUtilsEx.getLambdaOrdinal(m.name()));

    public static List<CodeFragmentFactory> getCodeFragmentFactories(@Nullable PsiElement context) {
        DefaultCodeFragmentFactory defaultFactory = DefaultCodeFragmentFactory.getInstance();
        SmartList suitableFactories = new SmartList();
        CodeFragmentFactory.EXTENSION_POINT_NAME.forEachExtensionSafe(arg_0 -> DebuggerUtilsEx.lambda$getCodeFragmentFactories$0(defaultFactory, context, (List)suitableFactories, arg_0));
        suitableFactories.add(defaultFactory);
        return suitableFactories;
    }

    public static PsiMethod findPsiMethod(PsiFile file, int offset) {
        PsiElement element = null;
        while (offset >= 0 && (element = file.findElementAt(offset)) == null) {
            --offset;
        }
        while (element != null) {
            if (element instanceof PsiClass || element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiMethod) {
                return (PsiMethod)element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Deprecated
    public static ReferenceType getSuperClass(@NotNull String baseQualifiedName, @NotNull ReferenceType checkedType) {
        if (baseQualifiedName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(0);
        }
        if (checkedType == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(1);
        }
        if (baseQualifiedName.equals(checkedType.name())) {
            return checkedType;
        }
        if (checkedType instanceof ClassType) {
            ReferenceType superClass;
            ClassType classType = (ClassType)checkedType;
            ClassType superClassType = classType.superclass();
            if (superClassType != null && (superClass = DebuggerUtilsEx.getSuperClass(baseQualifiedName, superClassType)) != null) {
                return superClass;
            }
            List<InterfaceType> interfaces = classType.allInterfaces();
            for (InterfaceType iface : interfaces) {
                ReferenceType superClass2 = DebuggerUtilsEx.getSuperClass(baseQualifiedName, iface);
                if (superClass2 == null) continue;
                return superClass2;
            }
        }
        if (checkedType instanceof InterfaceType) {
            List<InterfaceType> list = ((InterfaceType)checkedType).superinterfaces();
            for (InterfaceType superInterface : list) {
                ReferenceType superClass = DebuggerUtilsEx.getSuperClass(baseQualifiedName, superInterface);
                if (superClass == null) continue;
                return superClass;
            }
        }
        return null;
    }

    public static ClassFilter create(Element element) throws InvalidDataException {
        return DebuggerSettingsUtils.create((Element)element);
    }

    private static boolean isFiltered(ClassFilter classFilter, String qName) {
        if (!classFilter.isEnabled()) {
            return false;
        }
        try {
            if (classFilter.matches(qName)) {
                return true;
            }
        }
        catch (PatternSyntaxException e) {
            LOG.debug((Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Exception while matching ClassFilter \"" + classFilter.getPattern() + "\" with the input \"" + qName + "\"", (Throwable)e);
        }
        return false;
    }

    public static boolean isFiltered(@NotNull String qName, ClassFilter[] classFilters) {
        if (qName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(2);
        }
        return DebuggerUtilsEx.isFiltered(qName, Arrays.stream(classFilters));
    }

    public static boolean isFiltered(@NotNull String qName, Stream<? extends ClassFilter> classFilters) {
        if (qName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(3);
        }
        if (qName.indexOf(91) != -1) {
            return false;
        }
        return classFilters.anyMatch(filter -> DebuggerUtilsEx.isFiltered(filter, qName));
    }

    public static int getEnabledNumber(ClassFilter[] classFilters) {
        return (int)Arrays.stream(classFilters).filter(ClassFilter::isEnabled).count();
    }

    @Deprecated
    public static ClassFilter[] readFilters(List<? extends Element> children) {
        return DebuggerSettingsUtils.readFilters(children);
    }

    @Deprecated
    public static void writeFilters(@NotNull Element parentNode, @NonNls String tagName, ClassFilter[] filters) throws WriteExternalException {
        if (parentNode == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(4);
        }
        DebuggerSettingsUtils.writeFilters((Element)parentNode, (String)tagName, (ClassFilter[])filters);
    }

    @Deprecated(forRemoval=true)
    public static boolean filterEquals(ClassFilter[] filters1, ClassFilter[] filters2) {
        return DebuggerSettingsUtils.filterEquals((ClassFilter[])filters1, (ClassFilter[])filters2);
    }

    private static boolean elementListsEqual(List<? extends Element> l1, List<? extends Element> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<? extends Element> i1 = l1.iterator();
        for (Element element : l2) {
            Element elem1 = i1.next();
            if (DebuggerUtilsEx.elementsEqual(elem1, element)) continue;
            return false;
        }
        return true;
    }

    private static boolean attributeListsEqual(List<? extends Attribute> l1, List<? extends Attribute> l2) {
        if (l1 == null) {
            return l2 == null;
        }
        if (l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<? extends Attribute> i1 = l1.iterator();
        for (Attribute attribute : l2) {
            Attribute attr1 = i1.next();
            if (Objects.equals(attr1.getName(), attribute.getName()) && Objects.equals(attr1.getValue(), attribute.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean elementsEqual(Element e1, Element e2) {
        if (e1 == null) {
            return e2 == null;
        }
        if (!Objects.equals(e1.getName(), e2.getName())) {
            return false;
        }
        if (!DebuggerUtilsEx.elementListsEqual(e1.getChildren(), e2.getChildren())) {
            return false;
        }
        return DebuggerUtilsEx.attributeListsEqual(e1.getAttributes(), e2.getAttributes());
    }

    public static boolean externalizableEqual(JDOMExternalizable e1, JDOMExternalizable e2) {
        Element root1 = new Element("root");
        Element root2 = new Element("root");
        try {
            e1.writeExternal(root1);
        }
        catch (WriteExternalException e) {
            LOG.debug((Throwable)e);
        }
        try {
            e2.writeExternal(root2);
        }
        catch (WriteExternalException e) {
            LOG.debug((Throwable)e);
        }
        return DebuggerUtilsEx.elementsEqual(root1, root2);
    }

    @NotNull
    public static List<Pair<Breakpoint, Event>> getEventDescriptors(@Nullable SuspendContextImpl suspendContext) {
        EventSet events;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (suspendContext != null && !ContainerUtil.isEmpty((Collection)(events = suspendContext.getEventSet()))) {
            SmartList eventDescriptors = new SmartList();
            for (Event event : events) {
                Requestor requestor2 = RequestManagerImpl.findRequestor(event.request());
                if (!(requestor2 instanceof Breakpoint)) continue;
                eventDescriptors.add(Pair.create((Object)((Breakpoint)requestor2), (Object)event));
            }
            SmartList smartList = eventDescriptors;
            if (smartList == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(5);
            }
            return smartList;
        }
        List<Pair<Breakpoint, Event>> list = Collections.emptyList();
        if (list == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static void addThreadDump(Project project, List<ThreadState> threads, RunnerLayoutUi ui, GlobalSearchScope searchScope) {
        ArrayList javaThreadDump = new ArrayList(DumpItemKt.toDumpItems(threads));
        List filters = ExceptionFilters.getFilters((GlobalSearchScope)searchScope);
        SharedDebuggerUtils.createThreadDumpPanel((Project)project, javaThreadDump, (RunnerLayoutUi)ui, (List)filters);
    }

    public static void addCollectionHistoryTab(@NotNull XDebugSession session, @NotNull XValueNodeImpl node) {
        ValueDescriptorImpl descriptor;
        XValueContainer container;
        if (session == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(7);
        }
        if (node == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(8);
        }
        if ((container = node.getValueContainer()) instanceof JavaValue && (descriptor = ((JavaValue)container).getDescriptor()) instanceof FieldDescriptor) {
            Field field = ((FieldDescriptor)((Object)descriptor)).getField();
            String clsName = field.declaringType().name().replace("$", ".");
            String fieldName = field.name();
            DebuggerUtilsEx.addCollectionHistoryTab(session, clsName, fieldName, node);
        }
    }

    public static void addCollectionHistoryTab(@NotNull XDebugSession session, @NotNull String clsName, @NotNull String fieldName, @Nullable XValueNodeImpl node) {
        if (session == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(9);
        }
        if (clsName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(10);
        }
        if (fieldName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(11);
        }
        XDebugProcess process = session.getDebugProcess();
        RunnerLayoutUi ui = session.getUI();
        if (ui == null) {
            return;
        }
        String title = JavaDebuggerBundle.message((String)"collection.history.tab.title", (Object[])new Object[]{clsName + "." + fieldName});
        for (Content content : ui.getContents()) {
            if (!title.equals(content.getDisplayName())) continue;
            ui.removeContent(content, true);
        }
        JComponent view = new CollectionHistoryView(clsName, fieldName, process, node).getComponent();
        Content content = ui.createContent(title, view, title, null, null);
        content.setCloseable(true);
        content.setDescription(JavaDebuggerBundle.message((String)"collection.history", (Object[])new Object[0]));
        ui.addContent(content);
        ui.selectAndFocus(content, true, true);
    }

    /*
     * Unable to fully structure code
     */
    protected static <R, T> R processCollectibleValue(@NotNull ThrowableComputable<? extends T, ? extends EvaluateException> valueComputable, @NotNull Function<? super T, ? extends R> processor, @NotNull SuspendContextImpl suspendContext) throws EvaluateException {
        if (valueComputable == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(13);
        }
        if (suspendContext == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(14);
        }
        retries = 3;
        while (true) lbl-1000:
        // 3 sources

        {
            try {
                result = valueComputable.compute();
                return processor.apply(result);
            }
            catch (ObjectCollectedException oce) {
                if (--retries >= 0) ** GOTO lbl-1000
                return DebuggerUtilsEx.suspendAllAndEvaluate(valueComputable, processor, suspendContext.getVirtualMachineProxy());
            }
            catch (EvaluateException e) {
                if (e.getCause() instanceof ObjectCollectedException) {
                    if (--retries >= 0) continue;
                    return DebuggerUtilsEx.suspendAllAndEvaluate(valueComputable, processor, suspendContext.getVirtualMachineProxy());
                }
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R, T> R suspendAllAndEvaluate(@NotNull ThrowableComputable<? extends T, ? extends EvaluateException> valueComputable, @NotNull Function<? super T, ? extends R> processor, @NotNull VirtualMachineProxyImpl virtualMachineProxy) throws EvaluateException {
        if (valueComputable == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(16);
        }
        if (virtualMachineProxy == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(17);
        }
        if (Registry.is((String)"debugger.collectible.value.retries.error", (boolean)true)) {
            LOG.error("Retries exhausted, applying suspend-all evaluation");
        }
        virtualMachineProxy.suspend();
        try {
            R r = processor.apply(valueComputable.compute());
            return r;
        }
        finally {
            virtualMachineProxy.resume();
        }
    }

    public static StringReference mirrorOfString(@NotNull String s, @NotNull SuspendContextImpl context) {
        if (s == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(18);
        }
        if (context == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(19);
        }
        VirtualMachine vm = context.getVirtualMachineProxy().getVirtualMachine();
        try {
            return DebuggerUtilsEx.processCollectibleValue(() -> vm.mirrorOf(s), value -> {
                context.keep((ObjectReference)value);
                return value;
            }, context);
        }
        catch (EvaluateException e) {
            throw new RuntimeException(e);
        }
    }

    public static StringReference mirrorOfString(@NotNull String s, @NotNull EvaluationContext context) throws EvaluateException {
        if (s == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(20);
        }
        if (context == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(21);
        }
        return DebuggerUtilsEx.mirrorOfString(s, (SuspendContextImpl)context.getSuspendContext());
    }

    @Deprecated
    public static StringReference mirrorOfString(@NotNull String s, VirtualMachineProxyImpl virtualMachineProxy, EvaluationContext context) throws EvaluateException {
        if (s == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(22);
        }
        VirtualMachine vm = virtualMachineProxy.getVirtualMachine();
        return (StringReference)context.computeAndKeep(() -> vm.mirrorOf(s));
    }

    @NotNull
    public static ArrayReference mirrorOfArray(@NotNull ArrayType arrayType, int dimension, EvaluationContext context) throws EvaluateException {
        if (arrayType == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(23);
        }
        ArrayReference arrayReference = (ArrayReference)context.computeAndKeep(() -> context.getDebugProcess().newInstance(arrayType, dimension));
        if (arrayReference == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(24);
        }
        return arrayReference;
    }

    @NotNull
    public static ArrayReference mirrorOfArray(@NotNull ArrayType arrayType, @NotNull List<? extends Value> values, @NotNull EvaluationContext context) throws EvaluateException {
        if (arrayType == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(25);
        }
        if (values == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(26);
        }
        if (context == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(27);
        }
        ArrayReference res = (ArrayReference)context.computeAndKeep(() -> context.getDebugProcess().newInstance(arrayType, values.size()));
        try {
            DebuggerUtilsEx.setArrayValues(res, values, false);
        }
        catch (Exception e) {
            throw new EvaluateException(e.getMessage(), (Throwable)e);
        }
        ArrayReference arrayReference = res;
        if (arrayReference == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(28);
        }
        return arrayReference;
    }

    @NotNull
    public static ArrayReference mirrorOfByteArray(byte[] bytes, EvaluationContext context) throws EvaluateException, InvalidTypeException, ClassNotLoadedException {
        context = ((EvaluationContextImpl)context).withAutoLoadClasses(true);
        ArrayType arrayClass = (ArrayType)context.getDebugProcess().findClass(context, "byte[]", context.getClassLoader());
        ArrayReference reference = DebuggerUtilsEx.mirrorOfArray(arrayClass, bytes.length, context);
        VirtualMachine virtualMachine = reference.virtualMachine();
        ArrayList<ByteValue> mirrors = new ArrayList<ByteValue>(bytes.length);
        for (byte b : bytes) {
            mirrors.add(virtualMachine.mirrorOf(b));
        }
        DebuggerUtilsEx.setArrayValues(reference, mirrors, false);
        ArrayReference arrayReference = reference;
        if (arrayReference == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(29);
        }
        return arrayReference;
    }

    public static void setArrayValues(@NotNull ArrayReference array, @NotNull List<? extends Value> values, boolean checkAssignable) throws ClassNotLoadedException, InvalidTypeException {
        if (array == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(30);
        }
        if (values == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(31);
        }
        if (array instanceof ArrayReferenceImpl) {
            ((ArrayReferenceImpl)array).setValues(0, values, 0, -1, checkAssignable);
        } else {
            array.setValues(values);
        }
    }

    @NotNull
    public static CodeFragmentFactory getCodeFragmentFactory(@Nullable PsiElement context, @Nullable FileType fileType) {
        DefaultCodeFragmentFactory defaultFactory = DefaultCodeFragmentFactory.getInstance();
        if (fileType == null) {
            if (context == null) {
                DefaultCodeFragmentFactory defaultCodeFragmentFactory = defaultFactory;
                if (defaultCodeFragmentFactory == null) {
                    DebuggerUtilsEx.$$$reportNull$$$0(32);
                }
                return defaultCodeFragmentFactory;
            }
            PsiFile file = context.getContainingFile();
            fileType = file != null ? file.getFileType() : null;
        }
        for (CodeFragmentFactory factory : CodeFragmentFactory.EXTENSION_POINT_NAME.getExtensionList()) {
            if (factory == defaultFactory || fileType != null && !factory.getFileType().equals(fileType) || !factory.isContextAccepted(context)) continue;
            CodeFragmentFactory codeFragmentFactory = factory;
            if (codeFragmentFactory == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(33);
            }
            return codeFragmentFactory;
        }
        DefaultCodeFragmentFactory defaultCodeFragmentFactory = defaultFactory;
        if (defaultCodeFragmentFactory == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(34);
        }
        return defaultCodeFragmentFactory;
    }

    @NotNull
    public static CodeFragmentFactory findAppropriateCodeFragmentFactory(TextWithImports text, PsiElement context) {
        CodeFragmentFactory factory = (CodeFragmentFactory)ReadAction.compute(() -> DebuggerUtilsEx.getCodeFragmentFactory(context, text.getFileType()));
        return new CodeFragmentFactoryContextWrapper(factory);
    }

    @NotNull
    public static ThreeState getEffectiveAssertionStatus(@NotNull Location location) {
        Value value;
        Field field;
        ReferenceType type;
        if (location == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(35);
        }
        if ((type = location.declaringType()) instanceof ClassType && (field = DebuggerUtils.findField((ReferenceType)type, (String)"$assertionsDisabled")) != null && field.isStatic() && field.isSynthetic() && (value = type.getValue(field)) instanceof BooleanValue) {
            ThreeState threeState = ThreeState.fromBoolean((!((BooleanValue)value).value() ? 1 : 0) != 0);
            if (threeState == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(36);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(37);
        }
        return threeState;
    }

    public static String methodKey(Method m) {
        return m.declaringType().name() + "." + m.name() + m.signature();
    }

    public static String methodNameWithArguments(Method m) {
        return m.name() + "(" + StringUtil.join(m.argumentTypeNames(), StringUtil::getShortName, (String)", ") + ")";
    }

    public static String methodName(Method m) {
        return DebuggerUtilsEx.methodName(DebuggerUtilsEx.signatureToName(m.declaringType().signature()), m.name(), m.signature());
    }

    public static boolean methodMatches(@NotNull Method m, @NotNull String name, @NotNull String signature) {
        if (m == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(38);
        }
        if (name == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(39);
        }
        if (signature == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(40);
        }
        return name.equals(m.name()) && signature.equals(m.signature());
    }

    public static String methodName(String className, String methodName, String signature) {
        Type type = Type.getMethodType((String)signature);
        String params = Arrays.stream(type.getArgumentTypes()).map(Type::getClassName).collect(Collectors.joining(", "));
        return className + "." + methodName + "(" + params + ")";
    }

    public static String signatureToName(String s) {
        return Type.getType((String)s).getClassName();
    }

    public static String typeNameToSignature(String name) {
        return JNITypeParser.typeNameToSignature((String)name);
    }

    public static List<Method> declaredMethodsByName(@NotNull ReferenceType type, @NotNull String name) {
        if (type == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(41);
        }
        if (name == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(42);
        }
        return ((StreamEx)StreamEx.of(type.methods()).filter(m -> name.equals(m.name()))).toList();
    }

    @Nullable
    public static List<Location> allLineLocations(Method method) {
        try {
            return method.allLineLocations();
        }
        catch (AbsentInformationException ignored) {
            return null;
        }
    }

    @Nullable
    public static List<Location> allLineLocations(ReferenceType cls) {
        try {
            return DebuggerUtilsAsync.allLineLocationsSync(cls);
        }
        catch (AbsentInformationException ignored) {
            return null;
        }
        catch (ObjectCollectedException ignored) {
            return Collections.emptyList();
        }
    }

    public static int getLineNumber(Location location, boolean zeroBased) {
        try {
            return location.lineNumber() - (zeroBased ? 1 : 0);
        }
        catch (IllegalArgumentException | InternalError e) {
            return -1;
        }
    }

    public static int getCodeIndex(Location location) {
        try {
            return Math.toIntExact(location.codeIndex());
        }
        catch (IllegalArgumentException | InternalError e) {
            return -1;
        }
    }

    @Nullable
    public static String getSourceName(Location location, @Nullable String defaultName) {
        return DebuggerUtilsEx.getSourceName(location, (? super Throwable e) -> defaultName);
    }

    @Nullable
    public static String getSourceName(Location location, @NotNull Function<? super Throwable, String> defaultNameProvider) {
        if (defaultNameProvider == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(43);
        }
        try {
            return location.sourceName();
        }
        catch (AbsentInformationException | IllegalArgumentException | InternalError e) {
            return defaultNameProvider.apply(e);
        }
    }

    public static boolean isVoid(@NotNull Method method) {
        if (method == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(44);
        }
        return "void".equals(method.returnTypeName());
    }

    @Contract(value="null -> null")
    public static Method getMethod(@Nullable Location location) {
        if (location == null) {
            return null;
        }
        try {
            return location.method();
        }
        catch (IllegalArgumentException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public static CompletableFuture<Method> getMethodAsync(LocationImpl location) {
        return location.methodAsync().exceptionally(throwable -> {
            if (DebuggerUtilsAsync.unwrap(throwable) instanceof IllegalArgumentException) {
                LOG.info(throwable);
                return null;
            }
            throw (RuntimeException)throwable;
        });
    }

    @NotNull
    public static List<Location> locationsOfLine(@NotNull Method method, int line) {
        List<Location> list;
        if (method == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(45);
        }
        try {
            list = method.locationsOfLine("Java", null, line);
        }
        catch (AbsentInformationException absentInformationException) {
            List<Location> list2 = Collections.emptyList();
            if (list2 == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(47);
            }
            return list2;
        }
        if (list == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(46);
        }
        return list;
    }

    public static List<Value> getArgumentValues(@NotNull StackFrame frame) {
        if (frame == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(48);
        }
        try {
            return frame.getArgumentValues();
        }
        catch (InternalException e) {
            if (e.errorCode() == 32) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, double value) {
        if (PsiTypes.doubleType().getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiTypes.floatType().getName().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        if (PsiTypes.longType().getName().equals(expectedType)) {
            return vm.mirrorOf((long)value);
        }
        if (PsiTypes.intType().getName().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiTypes.shortType().getName().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiTypes.byteType().getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        if (PsiTypes.charType().getName().equals(expectedType)) {
            return vm.mirrorOf((char)value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, long value) {
        if (PsiTypes.longType().getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiTypes.intType().getName().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiTypes.shortType().getName().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiTypes.byteType().getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        if (PsiTypes.charType().getName().equals(expectedType)) {
            return vm.mirrorOf((char)value);
        }
        if (PsiTypes.doubleType().getName().equals(expectedType)) {
            return vm.mirrorOf((double)value);
        }
        if (PsiTypes.floatType().getName().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, boolean value) {
        if (PsiTypes.booleanType().getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl vm, String expectedType, char value) {
        if (PsiTypes.charType().getName().equals(expectedType)) {
            return vm.mirrorOf(value);
        }
        if (PsiTypes.longType().getName().equals(expectedType)) {
            return vm.mirrorOf((long)value);
        }
        if (PsiTypes.intType().getName().equals(expectedType)) {
            return vm.mirrorOf((int)value);
        }
        if (PsiTypes.shortType().getName().equals(expectedType)) {
            return vm.mirrorOf((short)value);
        }
        if (PsiTypes.byteType().getName().equals(expectedType)) {
            return vm.mirrorOf((byte)value);
        }
        if (PsiTypes.doubleType().getName().equals(expectedType)) {
            return vm.mirrorOf((double)value);
        }
        if (PsiTypes.floatType().getName().equals(expectedType)) {
            return vm.mirrorOf((float)value);
        }
        return null;
    }

    public static String truncateString(String str) {
        if (str.length() > 1005) {
            return str.substring(0, 1005);
        }
        return str;
    }

    public static String getThreadStatusText(int statusId) {
        return switch (statusId) {
            case 3 -> JavaDebuggerBundle.message((String)"status.thread.monitor", (Object[])new Object[0]);
            case 5 -> JavaDebuggerBundle.message((String)"status.thread.not.started", (Object[])new Object[0]);
            case 1 -> JavaDebuggerBundle.message((String)"status.thread.running", (Object[])new Object[0]);
            case 2 -> JavaDebuggerBundle.message((String)"status.thread.sleeping", (Object[])new Object[0]);
            case -1 -> JavaDebuggerBundle.message((String)"status.thread.unknown", (Object[])new Object[0]);
            case 4 -> JavaDebuggerBundle.message((String)"status.thread.wait", (Object[])new Object[0]);
            case 0 -> JavaDebuggerBundle.message((String)"status.thread.zombie", (Object[])new Object[0]);
            default -> JavaDebuggerBundle.message((String)"status.thread.undefined", (Object[])new Object[0]);
        };
    }

    public static void setAlternativeSourceUrl(String className, String source, Project project) {
        ConcurrentHashMap<String, String> map2 = (ConcurrentHashMap<String, String>)project.getUserData(DEBUGGER_ALTERNATIVE_SOURCE_MAPPING);
        if (map2 == null) {
            map2 = new ConcurrentHashMap<String, String>();
            project.putUserData(DEBUGGER_ALTERNATIVE_SOURCE_MAPPING, map2);
        }
        map2.put(className, source);
    }

    @Nullable
    public static String getAlternativeSourceUrl(@Nullable String className, Project project) {
        Map map2 = (Map)project.getUserData(DEBUGGER_ALTERNATIVE_SOURCE_MAPPING);
        return map2 != null ? (String)map2.get(className) : null;
    }

    @Nullable
    public static XSourcePosition toXSourcePosition(@Nullable SourcePosition position) {
        if (position != null) {
            VirtualFile file = position.getFile().getVirtualFile();
            if (file == null) {
                file = position.getFile().getOriginalFile().getVirtualFile();
            }
            if (file != null) {
                return new JavaXSourcePosition(position, file);
            }
        }
        return null;
    }

    @Nullable
    public static SourcePosition toSourcePosition(@Nullable XSourcePosition position, Project project) {
        if (position != null) {
            if (position instanceof JavaXSourcePosition) {
                return ((JavaXSourcePosition)position).mySourcePosition;
            }
            PsiFile psiFile = DebuggerUtilsEx.getPsiFile(position, project);
            if (psiFile != null) {
                return SourcePosition.createFromOffset((PsiFile)psiFile, (int)position.getOffset());
            }
        }
        return null;
    }

    @ApiStatus.Internal
    public static void setStaticBooleanField(@NotNull DebugProcessImpl process, final @NotNull String className, final @NotNull String fieldName, final boolean value) {
        if (process == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(49);
        }
        if (className == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(50);
        }
        if (fieldName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(51);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        final RequestManagerImpl requestsManager = process.getRequestsManager();
        ClassPrepareRequestor requestor2 = new ClassPrepareRequestor(){

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                try {
                    requestsManager.deleteRequest((Requestor)this);
                    Field field = DebuggerUtils.findField((ReferenceType)referenceType, (String)fieldName);
                    BooleanValue mirror = referenceType.virtualMachine().mirrorOf(value);
                    ((ClassType)referenceType).setValue(field, mirror);
                }
                catch (Exception e) {
                    LOG.warn("Error while setting field '" + fieldName + "' in class '" + className + "'", (Throwable)e);
                }
            }
        };
        requestsManager.callbackOnPrepareClasses(requestor2, className);
        try {
            ClassType classType = (ClassType)process.findClass(null, className, null);
            if (classType != null) {
                requestor2.processClassPrepare((DebugProcess)process, (ReferenceType)classType);
            }
        }
        catch (Exception e) {
            LOG.warn("Error while setting field '" + fieldName + "' in class '" + className + "'", (Throwable)e);
        }
    }

    @Nullable
    public static TextRange getHighlightingRangeInsideLine(@Nullable TextRange range, @Nullable PsiFile file, int line) {
        Document document;
        if (range != null && file != null && (document = file.getViewProvider().getDocument()) != null) {
            TextRange res;
            TextRange lineRange = DocumentUtil.getLineTextRange((Document)document, (int)line);
            return lineRange.equals((Object)(res = range.intersection(lineRange))) ? null : res;
        }
        return range;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @Nullable
    public static PsiFile getPsiFile(@Nullable XSourcePosition xSourcePosition, Project project) {
        VirtualFile file;
        XSourcePosition position;
        ThreadingAssertions.softAssertReadAccess();
        if (position != null && (file = position.getFile()).isValid()) {
            void project2;
            return PsiManager.getInstance((Project)project2).findFile(file);
        }
        return null;
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiFile file, int offset) {
        return file != null ? file.findElementAt(offset) : null;
    }

    public static String getLocationMethodQName(@NotNull Location location) {
        if (location == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(52);
        }
        StringBuilder res = new StringBuilder();
        ReferenceType type = location.declaringType();
        if (type != null) {
            res.append(type.name()).append('.');
        }
        res.append(DebuggerUtilsEx.getLocationMethodName(location));
        return res.toString();
    }

    public static String getLocationMethodName(@NotNull Location location) {
        if (location == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(53);
        }
        if (location instanceof GeneratedLocation) {
            GeneratedLocation generatedLocation = (GeneratedLocation)location;
            return generatedLocation.methodName();
        }
        Method method = DebuggerUtilsEx.getMethod(location);
        if (method == null) {
            return "<invalid method>";
        }
        return method.name();
    }

    private static PsiElement getNextElement(PsiElement element) {
        PsiElement sibling = element.getNextSibling();
        if (sibling != null) {
            return sibling;
        }
        if ((element = element.getParent()) != null) {
            return DebuggerUtilsEx.getNextElement(element);
        }
        return null;
    }

    public static boolean isLambdaClassName(String typeName) {
        return DebuggerUtilsEx.getLambdaBaseClassName(typeName) != null;
    }

    @Nullable
    public static String getLambdaBaseClassName(String typeName) {
        return StringUtil.substringBefore((String)typeName, (String)"$$Lambda");
    }

    public static boolean isLambdaName(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && name.startsWith("lambda$");
    }

    public static boolean isLambda(@Nullable Method method) {
        return method != null && DebuggerUtilsEx.isLambdaName(method.name());
    }

    public static boolean isProxyClassName(@Nullable String name) {
        return !StringUtil.isEmpty((String)name) && StringUtil.getShortName((String)name).startsWith("$Proxy");
    }

    public static boolean isProxyClass(@Nullable ReferenceType type) {
        return type instanceof ClassType && DebuggerUtilsEx.isProxyClassName(type.name());
    }

    public static int getLambdaOrdinal(@NotNull String name) {
        if (name == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(54);
        }
        return StringUtil.parseInt((String)StringUtil.substringAfterLast((String)name, (String)"$"), (int)-1);
    }

    @RequiresReadLock
    public static List<PsiLambdaExpression> collectLambdas(@NotNull SourcePosition position, final boolean onlyOnTheLine) {
        if (position == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(55);
        }
        ThreadingAssertions.softAssertReadAccess();
        PsiFile file = position.getFile();
        final int line = position.getLine();
        final Document document = file.getViewProvider().getDocument();
        if (document == null || line < 0 || line >= document.getLineCount()) {
            return Collections.emptyList();
        }
        TextRange lineRange = DocumentUtil.getLineTextRange((Document)document, (int)line);
        PsiElement element = file.findElementAt(lineRange.getStartOffset());
        if (element == null) {
            return Collections.emptyList();
        }
        SmartList lambdas = new SmartList();
        JavaRecursiveElementVisitor lambdaCollector = new JavaRecursiveElementVisitor((List)lambdas){
            final /* synthetic */ List val$lambdas;
            {
                this.val$lambdas = list;
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitLambdaExpression(expression);
                if (!onlyOnTheLine || DebuggerUtilsEx.getFirstElementOnTheLine(expression, document, line) != null) {
                    this.val$lambdas.add(expression);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/debugger/impl/DebuggerUtilsEx$2", "visitLambdaExpression"));
            }
        };
        element.accept((PsiElementVisitor)lambdaCollector);
        PsiElement sibling = DebuggerUtilsEx.getNextElement(element);
        while (sibling != null && DebuggerUtilsEx.intersects(lineRange, sibling)) {
            sibling.accept((PsiElementVisitor)lambdaCollector);
            sibling = DebuggerUtilsEx.getNextElement(sibling);
        }
        PsiElement method = DebuggerUtilsEx.getContainingMethod(element);
        if (method instanceof PsiLambdaExpression && !lambdas.contains(method)) {
            lambdas.add((PsiLambdaExpression)method);
        }
        return lambdas;
    }

    @Nullable
    public static PsiElement getBody(PsiElement method) {
        if (method instanceof PsiParameterListOwner) {
            return ((PsiParameterListOwner)method).getBody();
        }
        if (method instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)method).getBody();
        }
        return null;
    }

    public static PsiParameter @NotNull [] getParameters(PsiElement method) {
        if (method instanceof PsiParameterListOwner) {
            PsiParameter[] psiParameterArray = ((PsiParameterListOwner)method).getParameterList().getParameters();
            if (psiParameterArray == null) {
                DebuggerUtilsEx.$$$reportNull$$$0(56);
            }
            return psiParameterArray;
        }
        if (PsiParameter.EMPTY_ARRAY == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(57);
        }
        return PsiParameter.EMPTY_ARRAY;
    }

    public static boolean evaluateBoolean(ExpressionEvaluator evaluator, EvaluationContextImpl context) throws EvaluateException {
        Object value = UnBoxingEvaluator.unbox(evaluator.evaluate((EvaluationContext)context), context);
        if (!(value instanceof BooleanValue)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.boolean.expected", (Object[])new Object[0]));
        }
        return ((BooleanValue)value).booleanValue();
    }

    public static boolean intersects(@NotNull TextRange range, @NotNull PsiElement elem) {
        TextRange elemRange;
        if (range == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(58);
        }
        if (elem == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(59);
        }
        return (elemRange = elem.getTextRange()) != null && elemRange.intersects(range);
    }

    @RequiresReadLock
    @Nullable
    public static PsiElement getFirstElementOnTheLine(@NotNull PsiLambdaExpression lambda, Document document, int line) {
        if (lambda == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(60);
        }
        ThreadingAssertions.softAssertReadAccess();
        TextRange lineRange = DocumentUtil.getLineTextRange((Document)document, (int)line);
        if (!DebuggerUtilsEx.intersects(lineRange, (PsiElement)lambda)) {
            return null;
        }
        PsiElement body = lambda.getBody();
        if (body == null || !DebuggerUtilsEx.intersects(lineRange, body)) {
            return null;
        }
        if (body instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)body).getStatements();
            if (statements.length == 0) {
                LOG.assertTrue(lineRange.contains(body.getTextOffset()));
                return body;
            }
            for (PsiStatement statement : statements) {
                PsiElement found = DebuggerUtilsEx.getFirstElementOnTheLine(lineRange, (PsiElement)statement);
                if (found == null) continue;
                return found;
            }
        } else {
            PsiElement found = DebuggerUtilsEx.getFirstElementOnTheLine(lineRange, body);
            if (found != null) {
                return found;
            }
        }
        return null;
    }

    private static PsiElement getFirstElementOnTheLine(TextRange lineRange, PsiElement element) {
        if (lineRange.contains(element.getTextOffset())) {
            return element;
        }
        if (DebuggerUtilsEx.intersects(lineRange, element)) {
            for (PsiElement child : SyntaxTraverser.psiTraverser((PsiElement)element)) {
                if (!lineRange.contains(child.getTextOffset())) continue;
                return child;
            }
        }
        return null;
    }

    public static boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        PsiElement elem;
        if (pos == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(61);
        }
        if (method == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(62);
        }
        if ((elem = pos.getElementAt()) == null) {
            return false;
        }
        return Comparing.equal((Object)DebuggerUtilsEx.getContainingMethod(elem), (Object)method);
    }

    public static boolean methodMatches(@NotNull PsiMethod psiMethod, String className, @Nullable String name, String signature, DebugProcessImpl process) {
        if (psiMethod == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(63);
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        try {
            if (containingClass != null && (name == null || JVMNameUtil.getJVMMethodName(psiMethod).equals(name)) && JVMNameUtil.getJVMSignature(psiMethod).getName(process).equals(signature)) {
                String methodClassName = JVMNameUtil.getClassVMName(containingClass);
                if (Objects.equals(methodClassName, className)) {
                    return true;
                }
                if (methodClassName != null) {
                    if (ContainerUtil.exists((Iterable)VirtualMachineProxy.getCurrent().classesByName(className), t -> DebuggerUtilsEx.instanceOf((com.sun.jdi.Type)t, (String)methodClassName))) {
                        return true;
                    }
                    PsiClass aClass = PositionManagerImpl.findClass(process.getProject(), className, process.getSearchScope(), true);
                    return aClass != null && aClass.isInheritor(containingClass, true);
                }
            }
        }
        catch (EvaluateException e) {
            LOG.debug((Throwable)e);
        }
        return false;
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable PsiElement elem) {
        return PsiTreeUtil.getContextOfType((PsiElement)elem, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClassInitializer.class});
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable SourcePosition position) {
        if (position == null) {
            return null;
        }
        return DebuggerUtilsEx.getContainingMethod(position.getElementAt());
    }

    public static void disableCollection(ObjectReference reference) {
        try {
            reference.disableCollection();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void enableCollection(ObjectReference reference) {
        if (reference instanceof ObjectReferenceImpl) {
            ((ObjectReferenceImpl)reference).enableCollectionAsync();
        } else {
            try {
                reference.enableCollection();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public static int bytecodeToSourceLine(PsiFile psiFile, int originalLine) {
        int line;
        LineNumbersMapping mapping;
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null && (mapping = (LineNumbersMapping)file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null && (line = mapping.bytecodeToSource(originalLine + 1)) > -1) {
            return line - 1;
        }
        return -1;
    }

    public static boolean isInLibraryContent(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(64);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (file == null) {
                return true;
            }
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            return projectFileIndex.isInLibrary(file);
        });
    }

    @NotNull
    public static Location findOrCreateLocation(@NotNull VirtualMachine virtualMachine, @NotNull StackTraceElement stackTraceElement) {
        if (virtualMachine == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(65);
        }
        if (stackTraceElement == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(66);
        }
        return DebuggerUtilsEx.findOrCreateLocation(virtualMachine, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber());
    }

    @NotNull
    public static Location findOrCreateLocation(@NotNull VirtualMachine virtualMachine, @NotNull String className, @NotNull String methodName, int line) {
        ReferenceType classType;
        if (virtualMachine == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(67);
        }
        if (className == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(68);
        }
        if (methodName == null) {
            DebuggerUtilsEx.$$$reportNull$$$0(69);
        }
        if ((classType = (ReferenceType)ContainerUtil.getFirstItem(virtualMachine.classesByName(className))) == null) {
            classType = new GeneratedReferenceType(virtualMachine, className);
        } else if (line >= 0) {
            for (Method method : DebuggerUtilsEx.declaredMethodsByName(classType, methodName)) {
                List<Location> locations = DebuggerUtilsEx.locationsOfLine(method, line);
                if (locations.isEmpty()) continue;
                Location location = locations.get(0);
                if (location == null) {
                    DebuggerUtilsEx.$$$reportNull$$$0(70);
                }
                return location;
            }
        }
        return new GeneratedLocation(classType, methodName, line);
    }

    private static /* synthetic */ void lambda$getCodeFragmentFactories$0(DefaultCodeFragmentFactory defaultFactory, PsiElement context, List suitableFactories, CodeFragmentFactory factory) {
        if (factory != defaultFactory && factory.isContextAccepted(context)) {
            suitableFactories.add(factory);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 24, 28, 29, 32, 33, 34, 36, 37, 46, 47, 56, 57, 70 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseQualifiedName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 5: 
            case 6: 
            case 24: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 46: 
            case 47: 
            case 56: 
            case 57: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsEx";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clsName";
                break;
            }
            case 11: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueComputable";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualMachineProxy";
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 19: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 35: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 39: 
            case 42: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultNameProvider";
                break;
            }
            case 44: 
            case 45: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 50: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualMachine";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceElement";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsEx";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventDescriptors";
                break;
            }
            case 24: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "mirrorOfArray";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "mirrorOfByteArray";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragmentFactory";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveAssertionStatus";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFiltered";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeFilters";
                break;
            }
            case 5: 
            case 6: 
            case 24: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 46: 
            case 47: 
            case 56: 
            case 57: 
            case 70: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addCollectionHistoryTab";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processCollectibleValue";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "suspendAllAndEvaluate";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mirrorOfString";
                break;
            }
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mirrorOfArray";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setArrayValues";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveAssertionStatus";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "methodMatches";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "declaredMethodsByName";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSourceName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isVoid";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentValues";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "setStaticBooleanField";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getLocationMethodQName";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getLocationMethodName";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaOrdinal";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "collectLambdas";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getFirstElementOnTheLine";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "inTheMethod";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryContent";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 24, 28, 29, 32, 33, 34, 36, 37, 46, 47, 56, 57, 70 -> new IllegalStateException(string);
        };
    }

    private static class JavaXSourcePosition
    implements XSourcePosition,
    ExecutionPointHighlighter.HighlighterProvider {
        private final SourcePosition mySourcePosition;
        @NotNull
        private final VirtualFile myFile;

        JavaXSourcePosition(@NotNull SourcePosition sourcePosition, @NotNull VirtualFile file) {
            if (sourcePosition == null) {
                JavaXSourcePosition.$$$reportNull$$$0(0);
            }
            if (file == null) {
                JavaXSourcePosition.$$$reportNull$$$0(1);
            }
            this.mySourcePosition = sourcePosition;
            this.myFile = file;
        }

        public int getLine() {
            return this.mySourcePosition.getLine();
        }

        public int getOffset() {
            return this.mySourcePosition.getOffset();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                JavaXSourcePosition.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        @NotNull
        public Navigatable createNavigatable(@NotNull Project project) {
            if (project == null) {
                JavaXSourcePosition.$$$reportNull$$$0(3);
            }
            Navigatable navigatable = XDebuggerUtilImpl.createNavigatable((Project)project, (XSourcePosition)this);
            if (navigatable == null) {
                JavaXSourcePosition.$$$reportNull$$$0(4);
            }
            return navigatable;
        }

        @Nullable
        public TextRange getHighlightRange() {
            return SourcePositionHighlighter.getHighlightRangeFor((SourcePosition)this.mySourcePosition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePosition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/impl/DebuggerUtilsEx$JavaXSourcePosition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNavigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createNavigatable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
}

