/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.PossiblySyncCommand;
import com.intellij.debugger.impl.EventQueueClosedException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class EventQueue<E> {
    private static final Logger LOG = Logger.getInstance(EventQueue.class);
    private final LinkedList[] myEvents;
    private final ReentrantLock myLock = new ReentrantLock();
    private final Condition myEventsAvailable = this.myLock.newCondition();
    private volatile E myCurrentEvent;
    private volatile boolean myIsClosed = false;
    private int myAsyncCommandsCounter = 0;

    public EventQueue(int countPriorities) {
        this.myEvents = new LinkedList[countPriorities];
        Arrays.setAll(this.myEvents, i -> new LinkedList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushBack(@NotNull E event, int priority) {
        if (event == null) {
            EventQueue.$$$reportNull$$$0(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("pushBack event " + String.valueOf(event));
        }
        this.myLock.lock();
        try {
            if (this.isClosed()) {
                boolean bl = false;
                return bl;
            }
            this.getEventsList(priority).addFirst(event);
            this.processAdd(event);
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(@NotNull E event, int priority) {
        if (event == null) {
            EventQueue.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("put event " + String.valueOf(event));
        }
        this.myLock.lock();
        try {
            if (this.isClosed()) {
                boolean bl = false;
                return bl;
            }
            this.getEventsList(priority).offer(event);
            this.processAdd(event);
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
        return true;
    }

    private LinkedList<E> getEventsList(int priority) {
        return this.myEvents[priority];
    }

    public void close() {
        this.myLock.lock();
        try {
            this.myIsClosed = true;
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
    }

    private E getEvent() throws EventQueueClosedException {
        this.myLock.lock();
        try {
            while (true) {
                if (this.myIsClosed) {
                    throw new EventQueueClosedException();
                }
                for (int i = 0; i < this.myEvents.length; ++i) {
                    E event = this.getEventsList(i).poll();
                    if (event == null) continue;
                    this.processRemove(event);
                    E e = event;
                    return e;
                }
                this.myEventsAvailable.awaitUninterruptibly();
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    public E get() throws EventQueueClosedException {
        try {
            this.myCurrentEvent = this.getEvent();
            return this.myCurrentEvent;
        }
        catch (EventQueueClosedException e) {
            this.myCurrentEvent = null;
            throw e;
        }
    }

    public boolean isClosed() {
        return this.myIsClosed;
    }

    public E getCurrentEvent() {
        return this.myCurrentEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<E> clearQueue() {
        this.myLock.lock();
        ArrayList<E> allEvents = new ArrayList<E>();
        for (int i = 0; i < this.myEvents.length; ++i) {
            LinkedList<E> eventList = this.getEventsList(i);
            allEvents.addAll(eventList);
            eventList.clear();
        }
        allEvents.forEach(this::processRemove);
        ArrayList<E> arrayList = allEvents;
        ArrayList<E> arrayList2 = arrayList;
        if (arrayList2 == null) {
            EventQueue.$$$reportNull$$$0(2);
        }
        return arrayList2;
        finally {
            this.myLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.myLock.lock();
        try {
            boolean bl = ContainerUtil.and((Object[])this.myEvents, AbstractCollection::isEmpty);
            return bl;
        }
        finally {
            this.myLock.unlock();
        }
    }

    public boolean hasAsyncCommands() {
        this.myLock.lock();
        try {
            boolean bl = this.myAsyncCommandsCounter > 0;
            return bl;
        }
        finally {
            this.myLock.unlock();
        }
    }

    private void processAdd(@NotNull E event) {
        if (event == null) {
            EventQueue.$$$reportNull$$$0(3);
        }
        if (!(event instanceof PossiblySyncCommand)) {
            ++this.myAsyncCommandsCounter;
        }
    }

    private void processRemove(@NotNull E event) {
        if (event == null) {
            EventQueue.$$$reportNull$$$0(4);
        }
        if (!(event instanceof PossiblySyncCommand)) {
            LOG.assertTrue(--this.myAsyncCommandsCounter >= 0);
        }
    }

    public void reopen() {
        this.myIsClosed = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/EventQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/EventQueue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "clearQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pushBack";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAdd";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processRemove";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

