/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.ClassDefineTrialException;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001aC\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\f\"\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\r\u001a\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u001a\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\"#\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"tryLoadInClassLoader", "Lcom/sun/jdi/ClassType;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "className", "", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "tryToDefineInClassLoader", "loaderForDefine", "loaderForLookup", "additionalClassesToLoad", "", "(Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;Lcom/sun/jdi/ClassLoaderReference;Lcom/sun/jdi/ClassLoaderReference;Ljava/lang/String;[Ljava/lang/String;)Lcom/sun/jdi/ClassType;", "getTopClassloader", "currentClassLoader", "ideaRtPath", "Ljava/net/URL;", "kotlin.jvm.PlatformType", "getIdeaRtPath", "()Ljava/net/URL;", "ideaRtPath$delegate", "Lkotlin/Lazy;", "defineClass", "", "name", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nHelperClassCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelperClassCache.kt\ncom/intellij/debugger/impl/HelperClassCacheKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
public final class HelperClassCacheKt {
    @NotNull
    private static final Lazy ideaRtPath$delegate = LazyKt.lazy(HelperClassCacheKt::ideaRtPath_delegate$lambda$0);

    private static final ClassType tryLoadInClassLoader(EvaluationContextImpl evaluationContext, String className, ClassLoaderReference classLoader) {
        try {
            return (ClassType)evaluationContext.getDebugProcess().findClass(evaluationContext, className, classLoader);
        }
        catch (EvaluateException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvocationException && Intrinsics.areEqual((Object)"java.lang.ClassNotFoundException", (Object)((InvocationException)cause).exception().type().name())) {
                return null;
            }
            throw e;
        }
    }

    private static final ClassType tryToDefineInClassLoader(EvaluationContextImpl evaluationContext, ClassLoaderReference loaderForDefine, ClassLoaderReference loaderForLookup, String className, String ... additionalClassesToLoad) {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)className);
        spreadBuilder.addSpread((Object)additionalClassesToLoad);
        for (String fqn : CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]))) {
            ClassType alreadyDefined = HelperClassCacheKt.tryLoadInClassLoader(evaluationContext, fqn, loaderForDefine);
            if (alreadyDefined != null) continue;
            HelperClassCacheKt.defineClass(fqn, evaluationContext, loaderForDefine);
        }
        return HelperClassCacheKt.tryLoadInClassLoader(evaluationContext, className, loaderForLookup);
    }

    private static final ClassLoaderReference getTopClassloader(EvaluationContextImpl evaluationContext, ClassLoaderReference currentClassLoader) {
        DebugProcessImpl debugProcessImpl = evaluationContext.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)debugProcessImpl), (String)"getDebugProcess(...)");
        DebugProcessImpl process = debugProcessImpl;
        ReferenceType classLoaderClass = process.findClass(evaluationContext, "java.lang.ClassLoader", currentClassLoader);
        Method parentMethod = DebuggerUtils.findMethod((ReferenceType)classLoaderClass, (String)"getParent", (String)"()Ljava/lang/ClassLoader;");
        if (parentMethod == null) {
            boolean $i$a$-checkNotNull-HelperClassCacheKt$getTopClassloader$22 = false;
            String $i$a$-checkNotNull-HelperClassCacheKt$getTopClassloader$22 = "getParent method is not available";
            throw new IllegalStateException($i$a$-checkNotNull-HelperClassCacheKt$getTopClassloader$22.toString());
        }
        ClassLoaderReference classLoader = currentClassLoader;
        Value parent;
        while ((parent = process.invokeInstanceMethod(evaluationContext, classLoader, parentMethod, CollectionsKt.emptyList(), 0, true)) instanceof ClassLoaderReference) {
            classLoader = (ClassLoaderReference)parent;
        }
        return classLoader;
    }

    private static final URL getIdeaRtPath() {
        Lazy lazy = ideaRtPath$delegate;
        return (URL)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void defineClass(String name, EvaluationContextImpl evaluationContext, ClassLoaderReference classLoader) {
        try {
            Object object = new URL[]{HelperClassCacheKt.getIdeaRtPath()};
            URLClassLoader rtJarClassLoader = new URLClassLoader((URL[])object, null);
            object = rtJarClassLoader.getResourceAsStream(StringsKt.replace$default((String)name, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class");
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)object;
                boolean bl = false;
                if (stream == null) {
                    throw new EvaluateException("Unable to find " + name + " class bytes in idea-rt.jar: " + HelperClassCacheKt.getIdeaRtPath());
                }
                try {
                    ClassLoadingUtils.defineClass(name, stream.readAllBytes(), evaluationContext, classLoader);
                }
                catch (EvaluateException e) {
                    throw new ClassDefineTrialException(CollectionsKt.listOf((Object)((Object)e)));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (IOException ioe) {
            throw new EvaluateException("Unable to read " + name + " class bytes", (Throwable)ioe);
        }
    }

    private static final URL ideaRtPath_delegate$lambda$0() {
        String string = DebuggerUtilsImpl.getIdeaRtPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdeaRtPath(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path.toUri().toURL();
    }

    public static final /* synthetic */ ClassLoaderReference access$getTopClassloader(EvaluationContextImpl evaluationContext, ClassLoaderReference currentClassLoader) {
        return HelperClassCacheKt.getTopClassloader(evaluationContext, currentClassLoader);
    }

    public static final /* synthetic */ ClassType access$tryToDefineInClassLoader(EvaluationContextImpl evaluationContext, ClassLoaderReference loaderForDefine, ClassLoaderReference loaderForLookup, String className, String ... additionalClassesToLoad) {
        return HelperClassCacheKt.tryToDefineInClassLoader(evaluationContext, loaderForDefine, loaderForLookup, className, additionalClassesToLoad);
    }

    public static final /* synthetic */ ClassType access$tryLoadInClassLoader(EvaluationContextImpl evaluationContext, String className, ClassLoaderReference classLoader) {
        return HelperClassCacheKt.tryLoadInClassLoader(evaluationContext, className, classLoader);
    }
}

