/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.EventQueue;
import com.intellij.debugger.impl.EventQueueClosedException;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.sun.jdi.VMDisconnectedException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;

public abstract class InvokeThread<E extends PrioritizedTask> {
    private static final Logger LOG = Logger.getInstance(InvokeThread.class);
    private static final ThreadLocal<WorkerThreadRequest<?>> ourWorkerRequest = new ThreadLocal();
    private static final AtomicInteger ourWorkerCounter = new AtomicInteger(1);
    protected final EventQueue<E> myEvents = new EventQueue(PrioritizedTask.Priority.values().length);
    private WorkerThreadRequest<E> myCurrentRequest = null;

    public InvokeThread() {
        this.startNewWorkerThread();
    }

    protected abstract void processEvent(@NotNull E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startNewWorkerThread() {
        InvokeThread invokeThread = this;
        synchronized (invokeThread) {
            InvokeThread.assertCurrentThreadIsActive();
            WorkerThreadRequest workerRequest = new WorkerThreadRequest(this);
            WorkerThreadRequest<E> oldRequest = this.myCurrentRequest;
            this.myCurrentRequest = workerRequest;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Started new worker thread request " + String.valueOf(workerRequest) + ", was " + String.valueOf(oldRequest));
            }
            workerRequest.setRequestFuture(ApplicationManager.getApplication().executeOnPooledThread(workerRequest));
        }
    }

    protected static boolean assertCurrentThreadIsActive() {
        WorkerThreadRequest<?> threadRequest;
        InvokeThread<?> thread = InvokeThread.currentThread();
        if (thread == null) {
            return true;
        }
        WorkerThreadRequest<?> currentRequest = thread.getCurrentRequest();
        if (currentRequest != (threadRequest = InvokeThread.getCurrentThreadRequest())) {
            String message = "Expected worker request " + String.valueOf(threadRequest) + " instead of " + String.valueOf(currentRequest) + " closed=" + thread.myEvents.isClosed();
            InvokeThread.reportCommandError(new IllegalStateException(message));
            return false;
        }
        return true;
    }

    private void doProcessEvent(@Async.Execute E event) {
        this.processEvent(event);
    }

    private void run(@NotNull WorkerThreadRequest<?> threadRequest) {
        if (threadRequest == null) {
            InvokeThread.$$$reportNull$$$0(0);
        }
        try {
            DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> ProgressManager.getInstance().runProcess(() -> {
                while (true) {
                    try {
                        while (!threadRequest.isStopRequested() && InvokeThread.assertCurrentThreadIsActive()) {
                            this.doProcessEvent((PrioritizedTask)this.myEvents.get());
                        }
                    }
                    catch (EventQueueClosedException | VMDisconnectedException ignored) {
                    }
                    catch (ProcessCanceledException ignored) {
                        continue;
                    }
                    catch (CompletionException e) {
                        if (e.getCause() instanceof VMDisconnectedException) break;
                        InvokeThread.reportCommandError(e);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof InterruptedException) break;
                        InvokeThread.reportCommandError(e);
                        continue;
                    }
                    catch (Throwable e) {
                        InvokeThread.reportCommandError(e);
                        continue;
                    }
                    break;
                }
            }, threadRequest.myProgressIndicator));
        }
        finally {
            if (threadRequest == this.getCurrentRequest()) {
                this.processRemaining();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request " + String.valueOf(threadRequest) + " exited");
            }
        }
    }

    public void processRemaining() {
        for (PrioritizedTask event : this.myEvents.clearQueue()) {
            try {
                this.processEvent(event);
            }
            catch (Throwable throwable) {}
        }
    }

    private static void reportCommandError(Throwable e) {
        try {
            LOG.error(e);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    public static InvokeThread<?> currentThread() {
        WorkerThreadRequest<?> request = InvokeThread.getCurrentThreadRequest();
        return request != null ? request.getOwner() : null;
    }

    public boolean schedule(@NotNull @Async.Schedule E r) {
        if (r == null) {
            InvokeThread.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("schedule " + String.valueOf(r) + " in " + String.valueOf(this));
        }
        this.setCommandManagerThread(r);
        return this.myEvents.put(r, r.getPriority().ordinal());
    }

    public boolean pushBack(@NotNull E r) {
        if (r == null) {
            InvokeThread.$$$reportNull$$$0(2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("pushBack " + String.valueOf(r) + " in " + String.valueOf(this));
        }
        this.setCommandManagerThread(r);
        return this.myEvents.pushBack(r, r.getPriority().ordinal());
    }

    @ApiStatus.Internal
    public void setCommandManagerThread(E event) {
        if (event instanceof DebuggerCommandImpl) {
            DebuggerCommandImpl command2 = (DebuggerCommandImpl)event;
            command2.setCommandManagerThread$intellij_java_debugger_impl((DebuggerManagerThreadImpl)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchToRequest(WorkerThreadRequest newRequest) {
        WorkerThreadRequest<?> currentThreadRequest;
        InvokeThread invokeThread = this;
        synchronized (invokeThread) {
            currentThreadRequest = InvokeThread.getCurrentThreadRequest();
            LOG.assertTrue(currentThreadRequest != null);
            this.myCurrentRequest = newRequest;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Switched current request from " + String.valueOf(currentThreadRequest) + " to " + String.valueOf(newRequest));
            }
        }
        currentThreadRequest.requestStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerThreadRequest<E> getCurrentRequest() {
        InvokeThread invokeThread = this;
        synchronized (invokeThread) {
            return this.myCurrentRequest;
        }
    }

    public static WorkerThreadRequest<?> getCurrentThreadRequest() {
        return ourWorkerRequest.get();
    }

    public void close() {
        this.myEvents.close();
        LOG.debug("Closing evaluation");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadRequest";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/impl/InvokeThread";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "schedule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "pushBack";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class WorkerThreadRequest<E extends PrioritizedTask>
    implements Runnable {
        private final InvokeThread<E> myOwner;
        private final ProgressIndicator myProgressIndicator = new EmptyProgressIndicator();
        private volatile Future<?> myRequestFuture;
        private final int myId = ourWorkerCounter.getAndIncrement();

        WorkerThreadRequest(InvokeThread<E> owner) {
            this.myOwner = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                while (this.myRequestFuture == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            ourWorkerRequest.set(this);
            try {
                ConcurrencyUtil.runUnderThreadName((String)"DebuggerManagerThread", () -> this.myOwner.run(this));
            }
            finally {
                ourWorkerRequest.remove();
                boolean bl = Thread.interrupted();
            }
        }

        public void requestStop() {
            Future<?> future = this.myRequestFuture;
            assert (future != null);
            this.myProgressIndicator.cancel();
            future.cancel(true);
        }

        public boolean isStopRequested() {
            Future<?> future = this.myRequestFuture;
            assert (future != null);
            return this.myProgressIndicator.isCanceled() || future.isCancelled() || future.isDone();
        }

        @ApiStatus.Internal
        @NotNull
        public ProgressIndicator getProgressIndicator() {
            ProgressIndicator progressIndicator = this.myProgressIndicator;
            if (progressIndicator == null) {
                WorkerThreadRequest.$$$reportNull$$$0(0);
            }
            return progressIndicator;
        }

        public void join() throws InterruptedException, ExecutionException {
            assert (this.myRequestFuture != null);
            try {
                this.myRequestFuture.get();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }

        public void join(long timeout) throws InterruptedException, ExecutionException {
            assert (this.myRequestFuture != null);
            try {
                this.myRequestFuture.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException | TimeoutException exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setRequestFuture(Future<?> requestFuture) {
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                this.myRequestFuture = requestFuture;
                this.notifyAll();
            }
        }

        public InvokeThread<E> getOwner() {
            return this.myOwner;
        }

        public boolean isDone() {
            assert (this.myRequestFuture != null);
            return this.myRequestFuture.isDone() && ourWorkerRequest.get() == null;
        }

        public String toString() {
            return String.valueOf(this.myId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/InvokeThread$WorkerThreadRequest", "getProgressIndicator"));
        }
    }
}

