/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PositionUtil
extends ContextUtil {
    public static SourcePosition getSourcePosition(StackFrameContext context) {
        if (context instanceof DebuggerContextImpl) {
            return ((DebuggerContextImpl)context).getSourcePosition();
        }
        return ContextUtil.getSourcePosition(context);
    }

    @Nullable
    public static PsiElement getContextElement(StackFrameContext context) {
        if (context instanceof DebuggerContextImpl) {
            return ((DebuggerContextImpl)context).getContextElement();
        }
        return ContextUtil.getContextElement(context);
    }

    @Nullable
    public static <T extends PsiElement> T getPsiElementAt(@NotNull Project project, @NotNull Class<T> expectedPsiElementClass, @Nullable SourcePosition sourcePosition) {
        if (project == null) {
            PositionUtil.$$$reportNull$$$0(0);
        }
        if (expectedPsiElementClass == null) {
            PositionUtil.$$$reportNull$$$0(1);
        }
        if (sourcePosition == null) {
            return null;
        }
        return (T)((PsiElement)ReadAction.compute(() -> {
            PsiFile psiFile = sourcePosition.getFile();
            Document document = psiFile.getViewProvider().getDocument();
            if (document == null) {
                return null;
            }
            int spOffset = sourcePosition.getOffset();
            if (spOffset < 0) {
                return null;
            }
            int offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)spOffset, (String)" \t");
            return PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), (Class)expectedPsiElementClass, (boolean)false);
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "expectedPsiElementClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/impl/PositionUtil";
        objectArray[2] = "getPsiElementAt";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

