/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.LambdaMetafactory;
import org.jetbrains.annotations.NotNull;

public class RemoteConnectionBuilder {
    private static final Logger LOG = Logger.getInstance(RemoteConnectionBuilder.class);
    private final int myTransport;
    private final boolean myServer;
    private final String myAddress;
    private boolean myCheckValidity;
    private boolean myAsyncAgent;
    private boolean myQuiet;
    private boolean mySuspend = true;
    private Project myProject;
    private boolean myMatchWithExecutionTarget = false;

    public RemoteConnectionBuilder(boolean server, int transport, String address) {
        this.myTransport = transport;
        this.myServer = server;
        this.myAddress = address;
    }

    public RemoteConnectionBuilder checkValidity(boolean check) {
        this.myCheckValidity = check;
        return this;
    }

    public RemoteConnectionBuilder asyncAgent(boolean useAgent) {
        this.myAsyncAgent = useAgent;
        return this;
    }

    public RemoteConnectionBuilder project(Project project) {
        this.myProject = project;
        return this;
    }

    public RemoteConnectionBuilder quiet() {
        this.myQuiet = true;
        return this;
    }

    public RemoteConnectionBuilder suspend(boolean suspend) {
        this.mySuspend = suspend;
        return this;
    }

    public RemoteConnectionBuilder matchWithExecutionTarget() {
        this.myMatchWithExecutionTarget = true;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public RemoteConnection create(JavaParameters parameters) throws ExecutionException {
        if (this.myCheckValidity) {
            RemoteConnectionBuilder.checkTargetJPDAInstalled(parameters);
        }
        useSockets = this.myTransport == 0;
        address = "";
        if (StringUtil.isEmptyOrSpaces((String)this.myAddress)) {
            try {
                address = DebuggerUtils.getInstance().findAvailableDebugAddress(useSockets);
            }
            catch (ExecutionException e) {
                if (!this.myCheckValidity) ** GOTO lbl13
                throw e;
            }
        } else {
            address = this.myAddress;
        }
lbl13:
        // 3 sources

        debugAddress = this.myServer != false && useSockets != false ? DebuggerManagerImpl.LOCALHOST_ADDRESS_FALLBACK + ":" + address : address;
        debuggeeRunProperties = new StringBuilder();
        debuggeeRunProperties.append("transport=").append(DebugProcessImpl.findConnector(useSockets, this.myServer).transport().name());
        debuggeeRunProperties.append(",address=").append(debugAddress);
        debuggeeRunProperties.append(this.mySuspend != false ? ",suspend=y" : ",suspend=n");
        debuggeeRunProperties.append(this.myServer != false ? ",server=n" : ",server=y");
        if (StringUtil.containsWhitespaces((CharSequence)debuggeeRunProperties)) {
            debuggeeRunProperties.append("\"").append((CharSequence)debuggeeRunProperties).append("\"");
        }
        if (this.myQuiet) {
            debuggeeRunProperties.append(",quiet=y");
        }
        if (Registry.is((String)"debugger.jdwp.include.virtual.threads")) {
            debuggeeRunProperties.append(",includevirtualthreads=y");
        }
        _debuggeeRunProperties = debuggeeRunProperties.toString();
        ApplicationManager.getApplication().runReadAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$create$0(com.intellij.execution.configurations.JavaParameters java.lang.String ), ()V)((RemoteConnectionBuilder)this, (JavaParameters)parameters, (String)_debuggeeRunProperties));
        return new RemoteConnection(useSockets, DebuggerManagerImpl.LOCALHOST_ADDRESS_FALLBACK, address, this.myServer);
    }

    private static void addRtJar(@NotNull PathsList pathsList) {
        if (pathsList == null) {
            RemoteConnectionBuilder.$$$reportNull$$$0(0);
        }
        if (Registry.is((String)"debugger.add.rt.jar", (boolean)true)) {
            if (PluginManagerCore.isRunningFromSources()) {
                String path = DebuggerUtilsImpl.getIdeaRtPath();
                pathsList.remove(JavaSdkUtil.getIdeaRtJarPath());
                pathsList.addTail(path);
                LOG.debug("Running from sources IDE, add rt.jar: " + path);
            } else {
                boolean isIdeaBuild = ContainerUtil.exists((Iterable)pathsList.getPathList(), p -> p.contains("intellij.java.rt"));
                if (isIdeaBuild) {
                    String path = JavaSdkUtil.getIdeaRtJarPath();
                    pathsList.addFirst(path);
                    LOG.debug("Running IDEA from release IDE, add rt.jar: " + path);
                } else {
                    JavaSdkUtil.addRtJar((PathsList)pathsList);
                    LOG.debug("Running from release IDE, add rt.jar");
                }
            }
        }
    }

    private static void checkTargetJPDAInstalled(@NotNull JavaParameters parameters) throws ExecutionException {
        if (parameters == null) {
            RemoteConnectionBuilder.$$$reportNull$$$0(1);
        }
        if (parameters.getJdk() == null) {
            throw new ExecutionException(JavaDebuggerBundle.message((String)"error.jdk.not.specified", (Object[])new Object[0]));
        }
    }

    private /* synthetic */ void lambda$create$0(JavaParameters parameters, String _debuggeeRunProperties) {
        JavaSdkVersion version;
        RemoteConnectionBuilder.addRtJar(parameters.getClassPath());
        if (this.myAsyncAgent) {
            AsyncStacksUtils.addDebuggerAgent(parameters, this.myProject, true, null, this.myMatchWithExecutionTarget);
        }
        if (DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT && (version = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)parameters.getJdk())) != null && version.isAtLeast(JavaSdkVersion.JDK_24)) {
            String p = "--enable-native-access=ALL-UNNAMED";
            parameters.getVMParametersList().replaceOrPrepend(p, p);
        }
        parameters.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "");
        parameters.getVMParametersList().replaceOrPrepend("-agentlib:jdwp=", "-agentlib:jdwp=" + _debuggeeRunProperties);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/impl/RemoteConnectionBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addRtJar";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTargetJPDAInstalled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

