/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.jdi.SlotLocalVariable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecompiledLocalVariable
implements SlotLocalVariable {
    public static final String PARAM_PREFIX = "param_";
    public static final String SLOT_PREFIX = "slot_";
    private final int mySlot;
    private final String mySignature;
    private final boolean myIsParam;
    private final Collection<String> myMatchedNames;

    public DecompiledLocalVariable(int slot, boolean isParam, @Nullable String signature, @NotNull Collection<String> names) {
        if (names == null) {
            DecompiledLocalVariable.$$$reportNull$$$0(0);
        }
        this.mySlot = slot;
        this.myIsParam = isParam;
        this.mySignature = signature;
        this.myMatchedNames = names;
    }

    public int slot() {
        return this.mySlot;
    }

    @Nullable
    public String signature() {
        return this.mySignature;
    }

    public boolean isParam() {
        return this.myIsParam;
    }

    @NotNull
    public String getDefaultName() {
        String string = (this.myIsParam ? PARAM_PREFIX : SLOT_PREFIX) + this.mySlot;
        if (string == null) {
            DecompiledLocalVariable.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getDisplayName() {
        String nameString = StringUtil.join(this.myMatchedNames, (String)" | ");
        if (this.myIsParam && this.myMatchedNames.size() == 1) {
            return nameString;
        }
        if (!this.myMatchedNames.isEmpty()) {
            return nameString + " (" + this.getDefaultName() + ")";
        }
        return this.getDefaultName();
    }

    @NotNull
    public Collection<String> getMatchedNames() {
        Collection<String> collection = this.myMatchedNames;
        if (collection == null) {
            DecompiledLocalVariable.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public String toString() {
        return this.getDisplayName() + " (slot " + this.mySlot + ", " + this.mySignature + ")";
    }

    public static int getParamId(@Nullable String name) {
        if (!StringUtil.isEmpty((String)name)) {
            return StringUtil.parseInt((String)StringUtil.substringAfter((String)name, (String)PARAM_PREFIX), (int)-1);
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/DecompiledLocalVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/DecompiledLocalVariable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

