/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.jdi.ThreadGroupReferenceProxy;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ThreadGroupReference;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Unmodifiable;

public class ThreadGroupReferenceProxyImpl
extends ObjectReferenceProxyImpl
implements ThreadGroupReferenceProxy {
    private static final Logger LOG = Logger.getInstance(ThreadGroupReferenceProxyImpl.class);
    private ThreadGroupReferenceProxyImpl myParentThreadGroupProxy;
    private boolean myIsParentGroupCached = false;
    private String myName;

    public ThreadGroupReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxy, ThreadGroupReference threadGroupReference) {
        super(virtualMachineProxy, threadGroupReference);
    }

    public ThreadGroupReference getThreadGroupReference() {
        return (ThreadGroupReference)this.getObjectReference();
    }

    public String name() {
        this.checkValid();
        if (this.myName == null) {
            this.myName = this.getThreadGroupReference().name();
        }
        return this.myName;
    }

    public ThreadGroupReferenceProxyImpl parent() {
        this.checkValid();
        if (!this.myIsParentGroupCached) {
            this.myParentThreadGroupProxy = this.getVirtualMachineProxy().getThreadGroupReferenceProxy(this.getThreadGroupReference().parent());
            this.myIsParentGroupCached = true;
        }
        return this.myParentThreadGroupProxy;
    }

    @Override
    @NonNls
    public String toString() {
        return "ThreadGroupReferenceProxy: " + this.getThreadGroupReference().toString();
    }

    public void suspend() {
        this.getThreadGroupReference().suspend();
    }

    public void resume() {
        this.getThreadGroupReference().resume();
    }

    public @Unmodifiable List<ThreadReferenceProxyImpl> threads() {
        return ContainerUtil.map(this.getThreadGroupReference().threads(), this.getVirtualMachineProxy()::getThreadReferenceProxy);
    }

    public @Unmodifiable List<ThreadGroupReferenceProxyImpl> threadGroups() {
        return ContainerUtil.map(this.getThreadGroupReference().threadGroups(), this.getVirtualMachineProxy()::getThreadGroupReferenceProxy);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
    }
}

