/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.memory.agent.MemoryAgentActionResult;
import com.intellij.debugger.memory.agent.MemoryAgentCapabilities;
import com.intellij.debugger.memory.agent.MemoryAgentImpl;
import com.intellij.debugger.memory.agent.MemoryAgentInitializer;
import com.intellij.debugger.memory.agent.MemoryAgentProgressPoint;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MemoryAgent {
    public static final int DEFAULT_GC_ROOTS_PATHS_LIMIT = 10;
    public static final int DEFAULT_GC_ROOTS_OBJECTS_LIMIT = 50;

    @NotNull
    public static MemoryAgent get(@NotNull EvaluationContextImpl evaluationContext) {
        if (evaluationContext == null) {
            MemoryAgent.$$$reportNull$$$0(0);
        }
        if (!MemoryAgent.isAgentEnabled(evaluationContext.getDebugProcess())) {
            MemoryAgent memoryAgent = MemoryAgentImpl.DISABLED;
            if (memoryAgent == null) {
                MemoryAgent.$$$reportNull$$$0(1);
            }
            return memoryAgent;
        }
        MemoryAgent memoryAgent = MemoryAgentInitializer.getAgent(evaluationContext);
        if (memoryAgent == null) {
            MemoryAgent.$$$reportNull$$$0(2);
        }
        return memoryAgent;
    }

    public static boolean isAgentEnabled(@NotNull DebugProcess debugProcess) {
        if (debugProcess == null) {
            MemoryAgent.$$$reportNull$$$0(3);
        }
        return DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT && !DebuggerUtilsImpl.isRemote(debugProcess);
    }

    public void cancelAction();

    public boolean isDisabled();

    @Nullable
    public MemoryAgentProgressPoint checkProgress();

    public void setProgressIndicator(@NotNull ProgressIndicator var1);

    @NotNull
    public MemoryAgentCapabilities getCapabilities();

    @NotNull
    public MemoryAgentActionResult<Pair<long[], ObjectReference[]>> estimateObjectSize(@NotNull EvaluationContextImpl var1, @NotNull ObjectReference var2, long var3) throws EvaluateException;

    @NotNull
    public MemoryAgentActionResult<Pair<long[], long[]>> getShallowAndRetainedSizesByObjects(@NotNull EvaluationContextImpl var1, @NotNull List<ObjectReference> var2, long var3) throws EvaluateException;

    @NotNull
    public MemoryAgentActionResult<ObjectsAndSizes> getSortedShallowAndRetainedSizesByClass(@NotNull EvaluationContextImpl var1, @NotNull ReferenceType var2, long var3, long var5) throws EvaluateException;

    @NotNull
    public MemoryAgentActionResult<long[]> getShallowSizeByClasses(@NotNull EvaluationContextImpl var1, @NotNull List<ReferenceType> var2, long var3) throws EvaluateException;

    @NotNull
    public MemoryAgentActionResult<long[]> getRetainedSizeByClasses(@NotNull EvaluationContextImpl var1, @NotNull List<ReferenceType> var2, long var3) throws EvaluateException;

    @NotNull
    public MemoryAgentActionResult<Pair<long[], long[]>> getShallowAndRetainedSizeByClasses(@NotNull EvaluationContextImpl var1, @NotNull List<ReferenceType> var2, long var3) throws EvaluateException;

    @NotNull
    public MemoryAgentActionResult<ReferringObjectsInfo> findPathsToClosestGCRoots(@NotNull EvaluationContextImpl var1, @NotNull ObjectReference var2, int var3, int var4, long var5) throws EvaluateException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/MemoryAgent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/MemoryAgent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAgentEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static class ObjectsAndSizes {
        private final ObjectReference[] myObjects;
        private final long[] myShallowSizes;
        private final long[] myRetainedSizes;

        public ObjectsAndSizes(ObjectReference[] objects, long[] shallowSizes, long[] retainedSizes) {
            this.myObjects = objects;
            this.myShallowSizes = shallowSizes;
            this.myRetainedSizes = retainedSizes;
        }

        public long[] getShallowSizes() {
            return this.myShallowSizes;
        }

        public long[] getRetainedSizes() {
            return this.myRetainedSizes;
        }

        public ObjectReference[] getObjects() {
            return this.myObjects;
        }
    }
}

