/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.parsers;

import com.intellij.debugger.memory.agent.UnexpectedValueFormatException;
import com.intellij.debugger.memory.agent.parsers.ResultParser;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/debugger/memory/agent/parsers/ObjectReferencesParser;", "Lcom/intellij/debugger/memory/agent/parsers/ResultParser;", "", "Lcom/sun/jdi/ObjectReference;", "<init>", "()V", "parse", "value", "Lcom/sun/jdi/Value;", "intellij.java.debugger.impl"})
public final class ObjectReferencesParser
implements ResultParser<List<? extends ObjectReference>> {
    @NotNull
    public static final ObjectReferencesParser INSTANCE = new ObjectReferencesParser();

    private ObjectReferencesParser() {
    }

    @Override
    @NotNull
    public List<ObjectReference> parse(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof ArrayReference) {
            ArrayList<Value> result = new ArrayList<Value>();
            for (Value item : ((ArrayReference)value).getValues()) {
                if (!(item instanceof ObjectReference)) break;
                result.add(item);
            }
            if (result.size() != ((ArrayReference)value).length()) {
                throw new UnexpectedValueFormatException("All values should be object references but some of them are not");
            }
            return result;
        }
        throw new UnexpectedValueFormatException("Array with object references expected");
    }
}

