/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.parsers;

import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.memory.agent.CompoundRootReferringObject;
import com.intellij.debugger.memory.agent.MemoryAgentReferenceKind;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.debugger.memory.agent.UnexpectedValueFormatException;
import com.intellij.debugger.memory.agent.parsers.BooleanArrayParser;
import com.intellij.debugger.memory.agent.parsers.IntArrayParser;
import com.intellij.debugger.memory.agent.parsers.MemoryAgentReferringObjectCreator;
import com.intellij.debugger.memory.agent.parsers.ObjectReferencesParser;
import com.intellij.debugger.memory.agent.parsers.ResultParser;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J8\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/debugger/memory/agent/parsers/ObjectsReferencesInfoParser;", "Lcom/intellij/debugger/memory/agent/parsers/ResultParser;", "Lcom/intellij/debugger/memory/agent/ReferringObjectsInfo;", "<init>", "()V", "parse", "value", "Lcom/sun/jdi/Value;", "parseLinksInfos", "", "Lcom/intellij/debugger/engine/ReferringObject;", "objects", "Lcom/sun/jdi/ObjectReference;", "weakSoftReachable", "", "intellij.java.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nParsers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parsers.kt\ncom/intellij/debugger/memory/agent/parsers/ObjectsReferencesInfoParser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,248:1\n37#2,2:249\n*S KotlinDebug\n*F\n+ 1 Parsers.kt\ncom/intellij/debugger/memory/agent/parsers/ObjectsReferencesInfoParser\n*L\n117#1:249,2\n*E\n"})
public final class ObjectsReferencesInfoParser
implements ResultParser<ReferringObjectsInfo> {
    @NotNull
    public static final ObjectsReferencesInfoParser INSTANCE = new ObjectsReferencesInfoParser();

    private ObjectsReferencesInfoParser() {
    }

    @Override
    @NotNull
    public ReferringObjectsInfo parse(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof ArrayReference)) {
            throw new UnexpectedValueFormatException("Array of arrays is expected");
        }
        if (((ArrayReference)value).length() != 3) {
            throw new UnexpectedValueFormatException("Array must represent 3 values: objects, backward references and weak/soft reachability flags");
        }
        Value value2 = ((ArrayReference)value).getValue(0);
        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"getValue(...)");
        Object objects = ObjectReferencesParser.INSTANCE.parse(value2);
        Value value3 = ((ArrayReference)value).getValue(2);
        Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"getValue(...)");
        Object weakSoftReachable = BooleanArrayParser.INSTANCE.parse(value3);
        Value value4 = ((ArrayReference)value).getValue(1);
        Intrinsics.checkNotNullExpressionValue((Object)value4, (String)"getValue(...)");
        List<List<ReferringObject>> backwardReferences = this.parseLinksInfos((List<? extends ObjectReference>)objects, (List<Boolean>)weakSoftReachable, value4);
        return new ReferringObjectsInfo((List<? extends ObjectReference>)objects, backwardReferences);
    }

    private final List<List<ReferringObject>> parseLinksInfos(List<? extends ObjectReference> objects, List<Boolean> weakSoftReachable, Value value) {
        if (!(value instanceof ArrayReference)) {
            throw new UnexpectedValueFormatException("Array of arrays is expected");
        }
        ArrayList result = new ArrayList();
        for (Value linksInfo : ((ArrayReference)value).getValues()) {
            ArrayReference infos;
            if (!(linksInfo instanceof ArrayReference)) {
                throw new UnexpectedValueFormatException("Object references information should be represented by array");
            }
            Value value2 = ((ArrayReference)linksInfo).getValue(0);
            Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"getValue(...)");
            Object indices = IntArrayParser.INSTANCE.parse(value2);
            Value value3 = ((ArrayReference)linksInfo).getValue(1);
            Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"getValue(...)");
            Object kinds = IntArrayParser.INSTANCE.parse(value3);
            Value value4 = ((ArrayReference)linksInfo).getValue(2);
            if ((value4 instanceof ArrayReference ? (ArrayReference)value4 : null) == null) {
                throw new UnexpectedValueFormatException("Object references information should be represented by array");
            }
            infos = infos;
            Set distinctIndices = new LinkedHashSet();
            LinkedList<ReferringObject> referenceInfos = new LinkedList<ReferringObject>();
            List rootReferenceKinds = new ArrayList();
            Iterator iterator = ((Iterable)indices).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                int index = ((Number)iterator.next()).intValue();
                if (index == -1) {
                    MemoryAgentReferenceKind memoryAgentReferenceKind = MemoryAgentReferenceKind.valueOf(((Number)kinds.get(i)).intValue());
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)memoryAgentReferenceKind), (String)"valueOf(...)");
                    rootReferenceKinds.add(memoryAgentReferenceKind);
                    continue;
                }
                if (distinctIndices.contains(index)) continue;
                distinctIndices.add(index);
                MemoryAgentReferenceKind memoryAgentReferenceKind = MemoryAgentReferenceKind.valueOf(((Number)kinds.get(i)).intValue());
                Intrinsics.checkNotNullExpressionValue((Object)((Object)memoryAgentReferenceKind), (String)"valueOf(...)");
                referenceInfos.add(MemoryAgentReferringObjectCreator.INSTANCE.createReferringObject(objects.get(index), memoryAgentReferenceKind, weakSoftReachable.get(index), infos.getValue(i)));
            }
            if (!((Collection)rootReferenceKinds).isEmpty()) {
                Collection $this$toTypedArray$iv = rootReferenceKinds;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                referenceInfos.add(0, new CompoundRootReferringObject(thisCollection$iv.toArray(new MemoryAgentReferenceKind[0])));
            }
            result.add(referenceInfos);
        }
        return result;
    }
}

