/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentUtil;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTask;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.debugger.memory.filtering.InstanceProviderEx;
import com.intellij.debugger.memory.ui.ExpressionEditorWithHistory;
import com.intellij.debugger.memory.ui.FilteringProgressView;
import com.intellij.debugger.memory.ui.InstancesViewTreeTableModel;
import com.intellij.debugger.memory.ui.InstancesWithStackFrameView;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.ErrorsValueGroup;
import com.intellij.debugger.memory.utils.InstanceJavaValue;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRenderer;
import com.intellij.xdebugger.memory.ui.InstancesTree;
import com.intellij.xdebugger.memory.ui.InstancesViewBase;
import com.intellij.xdebugger.memory.utils.InstancesProvider;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

class InstancesView
extends InstancesViewBase {
    private static final Logger LOG = Logger.getInstance(InstancesView.class);
    private static final int MAX_TREE_NODE_COUNT = 2000;
    private static final int FILTERING_CHUNK_SIZE = 50;
    private static final int FILTERING_BUTTON_ADDITIONAL_WIDTH = 30;
    private static final int BORDER_LAYOUT_DEFAULT_GAP = 5;
    private static final int DEFAULT_INSTANCES_LIMIT = 500000;
    private static final int MAX_DURATION_TO_UPDATE_TREE_SECONDS = 3;
    private static final int FILTERING_PROGRESS_UPDATING_MIN_DELAY_MILLIS = 17;
    private final InstancesTree myInstancesTree;
    private final XDebuggerExpressionEditor myFilterConditionEditor;
    private final MyNodeManager myNodeManager;
    private final Consumer<? super String> myWarningMessageConsumer;
    private final JButton myFilterButton;
    private final FilteringProgressView myProgress;
    private final Object myFilteringTaskLock;
    private final XDebugSession myDebugSession;
    private final DebugProcessImpl myDebugProcess;
    private final String myClassName;
    private InstancesViewRepresentation myRepresentation;
    private volatile FilteringTask myFilteringTask;
    private volatile Future<?> myFilteringTaskFuture;
    private final ReferenceType myClassType;
    private boolean myIsDisposed;

    InstancesView(@NotNull XDebugSession session, InstancesProvider instancesProvider, @NotNull ReferenceType classType, Consumer<? super String> warningMessageConsumer) {
        if (session == null) {
            InstancesView.$$$reportNull$$$0(0);
        }
        if (classType == null) {
            InstancesView.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout(0, JBUIScale.scale((int)5)), session, instancesProvider);
        this.myFilterButton = new JButton(CommonBundle.message((String)"button.filter", (Object[])new Object[0]));
        this.myProgress = new FilteringProgressView();
        this.myFilteringTaskLock = new Object();
        this.myIsDisposed = false;
        this.myClassType = classType;
        this.myClassName = classType.name();
        this.myDebugSession = session;
        this.myDebugProcess = (DebugProcessImpl)DebuggerManager.getInstance((Project)session.getProject()).getDebugProcess(session.getDebugProcess().getProcessHandler());
        this.myNodeManager = new MyNodeManager(session.getProject());
        this.myWarningMessageConsumer = warningMessageConsumer;
        XDebuggerEditorsProvider editorsProvider = session.getDebugProcess().getEditorsProvider();
        this.myFilterConditionEditor = new ExpressionEditorWithHistory(session.getProject(), this.myClassName, editorsProvider, (Disposable)this);
        Dimension filteringButtonSize = this.myFilterConditionEditor.getEditorComponent().getPreferredSize();
        filteringButtonSize.width = JBUIScale.scale((int)30) + this.getFilterButton().getPreferredSize().width;
        this.getFilterButton().setPreferredSize(filteringButtonSize);
        JBPanel filteringPane = new JBPanel((LayoutManager)new BorderLayout(JBUIScale.scale((int)5), 0));
        JBLabel sideEffectsWarning = new JBLabel(JavaDebuggerBundle.message((String)"warning.filtering.may.have.side.effects", (Object[])new Object[0]), 4);
        sideEffectsWarning.setBorder((Border)JBUI.Borders.emptyTop((int)1));
        sideEffectsWarning.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        sideEffectsWarning.setFontColor(UIUtil.FontColor.BRIGHTER);
        filteringPane.add((Component)new JBLabel(JavaDebuggerBundle.message((String)"condition", (Object[])new Object[0])), (Object)"West");
        filteringPane.add((Component)this.myFilterConditionEditor.getComponent(), (Object)"Center");
        filteringPane.add((Component)this.getFilterButton(), (Object)"East");
        filteringPane.add((Component)sideEffectsWarning, (Object)"South");
        this.getProgress().addStopActionListener(this::cancelFilteringTask);
        this.selectRepresentation(null);
        this.myInstancesTree = new InstancesTree(session.getProject(), editorsProvider, this.getValueMarkers(session), this::updateInstances);
        this.getFilterButton().addActionListener(e -> {
            String expression = this.myFilterConditionEditor.getExpression().getExpression();
            if (!expression.isEmpty()) {
                this.myFilterConditionEditor.saveTextInHistory();
            }
            this.getFilterButton().setEnabled(false);
            this.myInstancesTree.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES);
        });
        this.add((Component)filteringPane, "North");
        this.updateRepresentation();
        JComponent focusedComponent = this.myFilterConditionEditor.getEditorComponent();
        UiNotifyConnector.doWhenFirstShown((JComponent)focusedComponent, () -> IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, true));
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.cancelFilteringTask());
            }

            public void sessionResumed() {
                ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.getProgress().setVisible(true));
            }
        });
    }

    protected InstancesTree getInstancesTree() {
        return this.myInstancesTree;
    }

    public void dispose() {
        this.myIsDisposed = true;
        this.cancelFilteringTask();
        Disposer.dispose((Disposable)this.myInstancesTree);
    }

    private void updateInstances() {
        this.cancelFilteringTask();
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.LOWEST;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy());
                XExpression expression = (XExpression)ReadAction.compute(() -> InstancesView.this.myFilterConditionEditor.getExpression());
                if (InstancesView.this.myIsDisposed) {
                    return;
                }
                if (InstancesView.this.selectRepresentation(expression)) {
                    InstancesView.this.updateRepresentation();
                }
                List<JavaReferenceInfo> instances = InstancesView.this.myRepresentation.fetchInstances(evaluationContext);
                Object object = InstancesView.this.myFilteringTaskLock;
                synchronized (object) {
                    InstancesView.this.myFilteringTask = new FilteringTask(InstancesView.this.myClassName, InstancesView.this.myDebugProcess, expression, new MyValuesList(instances), new MyFilteringCallback(evaluationContext));
                    InstancesView.this.myFilteringTaskFuture = ApplicationManager.getApplication().executeOnPooledThread((Runnable)InstancesView.this.myFilteringTask);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/ui/InstancesView$2", "threadAction"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelFilteringTask() {
        if (this.myFilteringTask != null) {
            Object object = this.myFilteringTaskLock;
            synchronized (object) {
                if (this.myFilteringTask != null) {
                    this.myFilteringTask.cancel();
                    this.myFilteringTask = null;
                    this.myFilteringTaskFuture.cancel(false);
                    this.myFilteringTaskFuture = null;
                }
            }
        }
    }

    public JButton getFilterButton() {
        return this.myFilterButton;
    }

    public FilteringProgressView getProgress() {
        return this.myProgress;
    }

    private boolean isMemoryViewSuitable(@Nullable XExpression expression) {
        InstancesProvider instancesProvider;
        if (!(MemoryAgent.isAgentEnabled(this.myDebugProcess) && Registry.is((String)"debugger.memory.agent.use.in.memory.view") && (instancesProvider = this.getInstancesProvider()) instanceof InstanceProviderEx)) {
            return false;
        }
        InstanceProviderEx instanceProviderEx = (InstanceProviderEx)instancesProvider;
        boolean returnAll = instanceProviderEx.returnAllInstancesOfAClass();
        return returnAll && (expression == null || FilteringTask.isEmptyFilter(expression)) || instanceProviderEx.estimateInstancesCount() <= 2000;
    }

    private boolean selectRepresentation(@Nullable XExpression expression) {
        boolean useMemoryView = this.isMemoryViewSuitable(expression);
        if (this.myRepresentation == null || useMemoryView != this.myRepresentation instanceof TreeTableRepresentation) {
            this.myRepresentation = useMemoryView ? new TreeTableRepresentation() : new TreeRepresentation();
            return true;
        }
        return false;
    }

    private void updateRepresentation() {
        this.myRepresentation.customizeView(this, this.myDebugSession, this.myClassName);
    }

    private void customizeView(@NotNull InstancesView view, @NotNull XDebugSession session, String className, JComponent tree) {
        if (view == null) {
            InstancesView.$$$reportNull$$$0(2);
        }
        if (session == null) {
            InstancesView.$$$reportNull$$$0(3);
        }
        final StackFrameList list = new StackFrameList(this.myDebugProcess.getProject());
        list.addListSelectionListener(e -> list.navigateToSelectedValue(false));
        new DoubleClickListener(this){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                list.navigateToSelectedValue(true);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/memory/ui/InstancesView$3", "onDoubleClick"));
            }
        }.installOn((Component)((Object)list));
        InstancesWithStackFrameView instancesWithStackFrame = new InstancesWithStackFrameView(session, tree, this.myInstancesTree, list, className);
        Component component = ((BorderLayout)view.getLayout()).getLayoutComponent("Center");
        if (component != null) {
            view.remove(component);
        }
        view.add(instancesWithStackFrame.getComponent(), "Center");
    }

    private @Unmodifiable @NotNull List<JavaReferenceInfo> getInstances(int limit) {
        List list = ContainerUtil.map((Collection)this.getInstancesProvider().getInstances(limit), referenceInfo -> (JavaReferenceInfo)referenceInfo);
        if (list == null) {
            InstancesView.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/ui/InstancesView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeView";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyNodeManager
    extends NodeManagerImpl {
        MyNodeManager(Project project) {
            super(project, null);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor, EvaluationContext evaluationContext) {
            return new DebuggerTreeNodeImpl(null, descriptor);
        }

        @Override
        public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor) {
            return new DebuggerTreeNodeImpl(null, descriptor);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createMessageNode(String message) {
            return new DebuggerTreeNodeImpl(null, new MessageDescriptor(message));
        }
    }

    private static interface InstancesViewRepresentation {
        public void customizeView(@NotNull InstancesView var1, @NotNull XDebugSession var2, String var3);

        public List<JavaReferenceInfo> fetchInstances(@NotNull EvaluationContextImpl var1);
    }

    private final class TreeTableRepresentation
    implements InstancesViewRepresentation {
        private TreeTableRepresentation() {
        }

        @Override
        public void customizeView(@NotNull InstancesView view, @NotNull XDebugSession session, String className) {
            if (view == null) {
                TreeTableRepresentation.$$$reportNull$$$0(0);
            }
            if (session == null) {
                TreeTableRepresentation.$$$reportNull$$$0(1);
            }
            InstancesViewTreeTableModel treeTableModel = new InstancesViewTreeTableModel(InstancesView.this.myInstancesTree);
            JBTreeTable treeTable = new JBTreeTable((TreeTableModel)treeTableModel, (Tree)InstancesView.this.myInstancesTree);
            treeTable.setDefaultRenderer(Long.class, (TableCellRenderer)treeTableModel.createTableCellRenderer());
            treeTable.getTree().setCellRenderer((TreeCellRenderer)new XDebuggerTreeRenderer(InstancesView.this.myInstancesTree.getProject()));
            InstancesView.this.customizeView(view, session, className, (JComponent)treeTable);
        }

        @Override
        public List<JavaReferenceInfo> fetchInstances(@NotNull EvaluationContextImpl evaluationContext) {
            InstanceProviderEx provider;
            if (evaluationContext == null) {
                TreeTableRepresentation.$$$reportNull$$$0(2);
            }
            if ((provider = (InstanceProviderEx)InstancesView.this.getInstancesProvider()).returnAllInstancesOfAClass()) {
                return MemoryAgentUtil.calculateSizes(evaluationContext, InstancesView.this.myClassType, 2000L, InstancesView.this.getProgress().getProgressIndicator());
            }
            List<JavaReferenceInfo> instances = InstancesView.this.getInstances(2000);
            List references = ContainerUtil.map(instances, JavaReferenceInfo::getObjectReference);
            return MemoryAgentUtil.calculateSizesByObjects(evaluationContext, references, InstancesView.this.getProgress().getProgressIndicator());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluationContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesView$TreeTableRepresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchInstances";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class TreeRepresentation
    implements InstancesViewRepresentation {
        private TreeRepresentation() {
        }

        @Override
        public void customizeView(@NotNull InstancesView view, @NotNull XDebugSession session, String className) {
            if (view == null) {
                TreeRepresentation.$$$reportNull$$$0(0);
            }
            if (session == null) {
                TreeRepresentation.$$$reportNull$$$0(1);
            }
            InstancesView.this.customizeView(view, session, className, (JComponent)new JBScrollPane((Component)InstancesView.this.myInstancesTree));
        }

        @Override
        public List<JavaReferenceInfo> fetchInstances(@NotNull EvaluationContextImpl evaluationContext) {
            int limit;
            List<JavaReferenceInfo> instances;
            if (evaluationContext == null) {
                TreeRepresentation.$$$reportNull$$$0(2);
            }
            if ((instances = InstancesView.this.getInstances(limit = DebuggerUtils.isAndroidVM((VirtualMachine)evaluationContext.getVirtualMachineProxy().getVirtualMachine()) ? 30000 : 500000)).size() > limit) {
                InstancesView.this.myWarningMessageConsumer.accept(XDebuggerBundle.message((String)"memory.view.instances.warning.not.all.loaded", (Object[])new Object[]{limit}));
                instances = instances.subList(0, limit);
            }
            return instances;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluationContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesView$TreeRepresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchInstances";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyValuesList
    implements FilteringTask.ValuesList {
        private final List<? extends JavaReferenceInfo> myRefs;

        MyValuesList(List<? extends JavaReferenceInfo> refs) {
            this.myRefs = refs;
        }

        @Override
        public int size() {
            return this.myRefs.size();
        }

        @Override
        public JavaReferenceInfo get(int index) {
            return this.myRefs.get(index);
        }
    }

    private class MyFilteringCallback
    implements FilteringTaskCallback {
        private final ErrorsValueGroup myErrorsGroup;
        private final EvaluationContextImpl myEvaluationContext;
        private final ProgressIndicator myProgressIndicator;
        private boolean myIsInProcess;
        private long myFilteringStartedTime;
        private int myProceedCount;
        private int myMatchedCount;
        private int myErrorsCount;
        private int myTotalInstancesCount;
        private long myLastTreeUpdatingTime;
        private long myLastProgressUpdatingTime;
        @Nullable
        private FilteringResult myCompletionReason;
        private XValueChildrenList myChildren;

        MyFilteringCallback(EvaluationContextImpl evaluationContext) {
            if (evaluationContext == null) {
                MyFilteringCallback.$$$reportNull$$$0(0);
            }
            this.myErrorsGroup = new ErrorsValueGroup();
            this.myIsInProcess = false;
            this.myCompletionReason = null;
            this.myChildren = new XValueChildrenList();
            this.myEvaluationContext = evaluationContext;
            this.myProgressIndicator = InstancesView.this.getProgress().getProgressIndicator();
        }

        @Override
        public void started(int total) {
            this.myTotalInstancesCount = total;
            this.myLastTreeUpdatingTime = this.myFilteringStartedTime = System.nanoTime();
            this.myLastProgressUpdatingTime = System.nanoTime();
            this.myIsInProcess = false;
            this.myErrorsCount = 0;
            this.myProceedCount = 0;
            this.myMatchedCount = 0;
            this.myCompletionReason = null;
            ApplicationManager.getApplication().invokeLater(() -> this.myProgressIndicator.start());
        }

        @Override
        @NotNull
        public FilteringTaskCallback.Action matched(@NotNull JavaReferenceInfo ref) {
            if (ref == null) {
                MyFilteringCallback.$$$reportNull$$$0(1);
            }
            InstanceJavaValue val = new InstanceJavaValue(ref.createDescriptor(InstancesView.this.myDebugProcess.getProject()), this.myEvaluationContext, InstancesView.this.myNodeManager);
            ++this.myMatchedCount;
            ++this.myProceedCount;
            this.myChildren.add((XNamedValue)val);
            this.updateProgress();
            this.updateTree();
            FilteringTaskCallback.Action action = this.myMatchedCount < 2000 ? FilteringTaskCallback.Action.CONTINUE : FilteringTaskCallback.Action.STOP;
            if (action == null) {
                MyFilteringCallback.$$$reportNull$$$0(2);
            }
            return action;
        }

        @Override
        @NotNull
        public FilteringTaskCallback.Action notMatched(@NotNull JavaReferenceInfo ref) {
            if (ref == null) {
                MyFilteringCallback.$$$reportNull$$$0(3);
            }
            ++this.myProceedCount;
            this.updateProgress();
            FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
            if (action == null) {
                MyFilteringCallback.$$$reportNull$$$0(4);
            }
            return action;
        }

        @Override
        @NotNull
        public FilteringTaskCallback.Action error(@NotNull JavaReferenceInfo ref, @NotNull String description) {
            if (ref == null) {
                MyFilteringCallback.$$$reportNull$$$0(5);
            }
            if (description == null) {
                MyFilteringCallback.$$$reportNull$$$0(6);
            }
            InstanceJavaValue val = new InstanceJavaValue(ref.createDescriptor(InstancesView.this.myDebugProcess.getProject()), this.myEvaluationContext, InstancesView.this.myNodeManager);
            this.myErrorsGroup.addErrorValue(description, val);
            ++this.myProceedCount;
            ++this.myErrorsCount;
            this.updateProgress();
            FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
            if (action == null) {
                MyFilteringCallback.$$$reportNull$$$0(7);
            }
            return action;
        }

        @Override
        public void completed(@NotNull FilteringResult reason) {
            if (reason == null) {
                MyFilteringCallback.$$$reportNull$$$0(8);
            }
            if (!this.myErrorsGroup.isEmpty()) {
                this.myChildren.addBottomGroup((XValueGroup)this.myErrorsGroup);
            }
            long duration = System.nanoTime() - this.myFilteringStartedTime;
            LOG.info(String.format("Filtering completed in %d ms for %d instances", TimeUnit.NANOSECONDS.toMillis(duration), this.myProceedCount));
            XValueChildrenList childrenList = this.myChildren;
            ApplicationManager.getApplication().invokeLater(() -> {
                this.updateIndicator();
                InstancesView.this.myInstancesTree.addChildren(childrenList, true);
                InstancesView.this.getFilterButton().setEnabled(true);
                this.myIsInProcess = false;
                this.myCompletionReason = reason;
                this.myProgressIndicator.stop();
            });
        }

        private void updateProgress() {
            long now = System.nanoTime();
            if (now - this.myLastProgressUpdatingTime > TimeUnit.MILLISECONDS.toNanos(17L)) {
                ApplicationManager.getApplication().invokeLater(() -> this.updateIndicator());
                this.myLastProgressUpdatingTime = now;
            }
        }

        private void updateIndicator() {
            this.myProgressIndicator.setFraction((double)this.myProceedCount / (double)this.myTotalInstancesCount);
            this.myProgressIndicator.setText(this.getDescription());
        }

        private void updateTree() {
            long now = System.nanoTime();
            int newChildrenCount = this.myChildren.size();
            if (newChildrenCount >= 50 || newChildrenCount > 0 && now - this.myLastTreeUpdatingTime > TimeUnit.SECONDS.toNanos(3L)) {
                XValueChildrenList children = this.myChildren;
                ApplicationManager.getApplication().invokeLater(() -> InstancesView.this.myInstancesTree.addChildren(children, false));
                this.myChildren = new XValueChildrenList();
                this.myLastTreeUpdatingTime = System.nanoTime();
            }
        }

        @NlsContexts.ProgressText
        private String getDescription() {
            Object itemsInfo = JavaDebuggerBundle.message((String)"progress.text.shown.x.of.y", (Object[])new Object[]{this.myMatchedCount, this.myTotalInstancesCount});
            if (this.myIsInProcess || this.myCompletionReason == null) {
                return itemsInfo;
            }
            switch (this.myCompletionReason) {
                case ALL_CHECKED: {
                    break;
                }
                case INTERRUPTED: {
                    itemsInfo = (String)itemsInfo + " " + JavaDebuggerBundle.message((String)"progress.suffix.filtering.has.been.interrupted", (Object[])new Object[0]);
                    break;
                }
                case LIMIT_REACHED: {
                    itemsInfo = (String)itemsInfo + " " + JavaDebuggerBundle.message((String)"progress.suffix.limit.has.been.reached", (Object[])new Object[0]);
                }
            }
            if (this.myErrorsCount != 0) {
                String errors = JavaDebuggerBundle.message((String)"progress.text.errors.count", (Object[])new Object[]{this.myErrorsCount});
                return new HtmlBuilder().append((String)itemsInfo).br().append(errors).wrapWith("html").toString();
            }
            return itemsInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluationContext";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/memory/ui/InstancesView$MyFilteringCallback";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesView$MyFilteringCallback";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "matched";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "notMatched";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "error";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "matched";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "notMatched";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "completed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 7 -> new IllegalStateException(string);
            };
        }
    }
}

