/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StackFrameList
extends XDebuggerFramesList {
    private static final MyOpenFilesState myEditorState = new MyOpenFilesState();

    StackFrameList(Project project) {
        super(project);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DebuggerUIUtil.invokeLater(() -> StackFrameList.this.navigateToSelectedValue(false));
                }
            }
        });
    }

    void clearFrameItems() {
        this.clear();
    }

    void setFrameItems(@NotNull List<@Nullable StackFrameItem> items2, @NotNull DebugProcessImpl debugProcess) {
        if (items2 == null) {
            StackFrameList.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            StackFrameList.$$$reportNull$$$0(1);
        }
        this.setFrameItems(items2, debugProcess, null);
    }

    void setFrameItems(final @NotNull List<@Nullable StackFrameItem> items2, final @NotNull DebugProcessImpl debugProcess, final @Nullable Runnable onDone) {
        if (items2 == null) {
            StackFrameList.$$$reportNull$$$0(2);
        }
        if (debugProcess == null) {
            StackFrameList.$$$reportNull$$$0(3);
        }
        debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                StackFrameList.this.setFrameItems(ContainerUtil.map((Collection)items2, info -> info == null ? null : info.createFrame(debugProcess)), onDone);
            }
        });
    }

    void setFrameItems(@NotNull List<@Nullable XStackFrame> frames, @Nullable Runnable onDone) {
        if (frames == null) {
            StackFrameList.$$$reportNull$$$0(4);
        }
        this.clear();
        if (!frames.isEmpty()) {
            boolean separator = false;
            for (XStackFrame frame : frames) {
                if (frame == null) {
                    separator = true;
                    continue;
                }
                if (separator) {
                    StackFrameItem.setWithSeparator(frame);
                    separator = false;
                }
                DebuggerUIUtil.invokeLater(() -> this.getModel().add((Object)frame));
            }
            if (onDone != null) {
                onDone.run();
            }
        }
    }

    void navigateToSelectedValue(boolean focusOnEditor) {
        XStackFrame frame = this.getSelectedFrame();
        if (frame != null) {
            this.navigateToFrame(frame, focusOnEditor);
        }
    }

    private void navigateToFrame(@NotNull XStackFrame frame, boolean focusOnEditor) {
        XSourcePosition position;
        if (frame == null) {
            StackFrameList.$$$reportNull$$$0(5);
        }
        if ((position = frame.getSourcePosition()) == null) {
            return;
        }
        VirtualFile file = position.getFile();
        int line = position.getLine();
        Project project = this.getProject();
        OpenFileHyperlinkInfo info = new OpenFileHyperlinkInfo(project, file, line);
        OpenFileDescriptor descriptor = info.getDescriptor();
        if (descriptor != null) {
            FileEditorManagerImpl manager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project);
            VirtualFile lastFile = StackFrameList.myEditorState.myLastOpenedFile;
            if (StackFrameList.myEditorState.myIsNeedToCloseLastOpenedFile && lastFile != null && manager.isFileOpen(lastFile) && !lastFile.equals(descriptor.getFile())) {
                manager.closeFile(StackFrameList.myEditorState.myLastOpenedFile, false, true);
            }
            descriptor.setScrollType(ScrollType.CENTER);
            descriptor.setUseCurrentWindow(true);
            if (lastFile == null || !lastFile.equals(descriptor.getFile())) {
                StackFrameList.myEditorState.myIsNeedToCloseLastOpenedFile = !manager.isFileOpen(descriptor.getFile());
            }
            descriptor.navigateInEditor(project, focusOnEditor);
            FileEditor[] editors = manager.getEditors(descriptor.getFile());
            if (editors.length != 0) {
                StackFrameList.myEditorState.myLastOpenedFile = descriptor.getFile();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/StackFrameList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setFrameItems";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToFrame";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyOpenFilesState {
        VirtualFile myLastOpenedFile;
        boolean myIsNeedToCloseLastOpenedFile;

        private MyOpenFilesState() {
        }
    }
}

