/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.memory.agent.MemoryAgentUtil;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

class DebuggerLaunchingConfigurable
implements ConfigurableUi<DebuggerSettings> {
    private JRadioButton myRbSocket;
    private JRadioButton myRbShmem;
    private JCheckBox myCbShowAlternativeSource;
    private JCheckBox myCbKillImmediately;
    private JCheckBox myCbAlwaysDebug;
    private JCheckBox myCbEnableMemoryAgent;

    DebuggerLaunchingConfigurable() {
    }

    public void reset(@NotNull DebuggerSettings settings) {
        if (settings == null) {
            DebuggerLaunchingConfigurable.$$$reportNull$$$0(0);
        }
        if (!SystemInfo.isWindows) {
            this.myRbSocket.setSelected(true);
            this.myRbShmem.setEnabled(false);
        } else {
            if (settings.getTransport() == 1) {
                this.myRbShmem.setSelected(true);
            } else {
                this.myRbSocket.setSelected(true);
            }
            this.myRbShmem.setEnabled(true);
        }
        this.myCbShowAlternativeSource.setSelected(settings.SHOW_ALTERNATIVE_SOURCE);
        this.myCbKillImmediately.setSelected(settings.KILL_PROCESS_IMMEDIATELY);
        this.myCbAlwaysDebug.setSelected(settings.ALWAYS_DEBUG);
        this.myCbEnableMemoryAgent.setSelected(settings.ENABLE_MEMORY_AGENT);
    }

    public void apply(@NotNull DebuggerSettings settings) {
        if (settings == null) {
            DebuggerLaunchingConfigurable.$$$reportNull$$$0(1);
        }
        this.getSettingsTo(settings);
    }

    private void getSettingsTo(DebuggerSettings settings) {
        settings.setTransport(this.myRbShmem.isSelected() ? 1 : 0);
        settings.SHOW_ALTERNATIVE_SOURCE = this.myCbShowAlternativeSource.isSelected();
        settings.KILL_PROCESS_IMMEDIATELY = this.myCbKillImmediately.isSelected();
        settings.ALWAYS_DEBUG = this.myCbAlwaysDebug.isSelected();
        settings.ENABLE_MEMORY_AGENT = this.myCbEnableMemoryAgent.isSelected();
    }

    public boolean isModified(@NotNull DebuggerSettings currentSettings) {
        if (currentSettings == null) {
            DebuggerLaunchingConfigurable.$$$reportNull$$$0(2);
        }
        DebuggerSettings debuggerSettings = currentSettings.clone();
        this.getSettingsTo(debuggerSettings);
        return !debuggerSettings.equals((Object)currentSettings);
    }

    @NotNull
    public JComponent getComponent() {
        this.myCbShowAlternativeSource = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.show.alternative.source", (Object[])new Object[0]));
        this.myRbSocket = new JRadioButton(JavaDebuggerBundle.message((String)"label.debugger.launching.configurable.socket", (Object[])new Object[0]));
        this.myRbShmem = new JRadioButton(JavaDebuggerBundle.message((String)"label.debugger.launching.configurable.shmem", (Object[])new Object[0]));
        this.myCbKillImmediately = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.kill.immediately", (Object[])new Object[0]));
        this.myCbAlwaysDebug = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.always.debug", (Object[])new Object[0]));
        this.myCbEnableMemoryAgent = new JCheckBox(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.enable.memory.agent", (Object[])new Object[0]));
        this.myCbEnableMemoryAgent.setToolTipText(JavaDebuggerBundle.message((String)"label.debugger.general.configurable.enable.memory.agent.tooltip.text", (Object[])new Object[0]));
        ButtonGroup gr = new ButtonGroup();
        gr.add(this.myRbSocket);
        gr.add(this.myRbShmem);
        JBBox box = JBBox.createHorizontalBox();
        box.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        box.add((Component)this.myRbSocket);
        box.add(Box.createRigidArea((Dimension)JBUI.size((int)10, (int)0)));
        box.add((Component)this.myRbShmem);
        JPanel transportPanel = new JPanel(new BorderLayout());
        transportPanel.add((Component)new JLabel(JavaDebuggerBundle.message((String)"label.debugger.launching.configurable.debugger.transport", (Object[])new Object[0])), "West");
        transportPanel.add((Component)box, "Center");
        VerticalBox panel = new VerticalBox();
        panel.setOpaque(false);
        panel.add((Component)transportPanel);
        panel.add((Component)this.myCbShowAlternativeSource);
        panel.add((Component)this.myCbKillImmediately);
        if (MemoryAgentUtil.isPlatformSupported()) {
            panel.add((Component)this.myCbEnableMemoryAgent);
        }
        if (Registry.is((String)"execution.java.always.debug")) {
            panel.add((Component)this.myCbAlwaysDebug);
        }
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)panel, "North");
        JPanel jPanel = result;
        if (jPanel == null) {
            DebuggerLaunchingConfigurable.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/settings/DebuggerLaunchingConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/settings/DebuggerLaunchingConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

