/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class DebuggerSettingsStatisticsCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("debugger.settings.ide", 9);
    private static final VarargEventId SHOW_ALTERNATIVE_SOURCE = GROUP.registerVarargEvent("showAlternativeSource", new EventField[]{EventFields.Enabled});
    private static final VarargEventId HOTSWAP_IN_BACKROUND = GROUP.registerVarargEvent("hotswapInBackround", new EventField[]{EventFields.Enabled});
    private static final VarargEventId ENABLE_MEMORY_AGENT = GROUP.registerVarargEvent("enableMemoryAgent", new EventField[]{EventFields.Enabled});
    private static final VarargEventId ALWAYS_SMART_STEP_INTO = GROUP.registerVarargEvent("alwaysSmartStepInto", new EventField[]{EventFields.Enabled});
    private static final VarargEventId SKIP_CONSTRUCTORS = GROUP.registerVarargEvent("skipConstructors", new EventField[]{EventFields.Enabled});
    private static final VarargEventId SKIP_GETTERS = GROUP.registerVarargEvent("skipGetters", new EventField[]{EventFields.Enabled});
    private static final VarargEventId SKIP_CLASSLOADERS = GROUP.registerVarargEvent("skipClassloaders", new EventField[]{EventFields.Enabled});
    private static final VarargEventId COMPILE_BEFORE_HOTSWAP = GROUP.registerVarargEvent("compileBeforeHotswap", new EventField[]{EventFields.Enabled});
    private static final VarargEventId HOTSWAP_SHOW_FLOATING_BUTTON = GROUP.registerVarargEvent("showHotSwapButtonInEditor", new EventField[]{EventFields.Enabled});
    private static final VarargEventId HOTSWAP_HANG_WARNING_ENABLED = GROUP.registerVarargEvent("hotswapHangWarningEnabled", new EventField[]{EventFields.Enabled});
    private static final VarargEventId WATCH_RETURN_VALUES = GROUP.registerVarargEvent("watchReturnValues", new EventField[]{EventFields.Enabled});
    private static final VarargEventId AUTO_VARIABLES_MODE = GROUP.registerVarargEvent("autoVariablesMode", new EventField[]{EventFields.Enabled});
    private static final VarargEventId KILL_PROCESS_IMMEDIATELY = GROUP.registerVarargEvent("killProcessImmediately", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RESUME_ONLY_CURRENT_THREAD = GROUP.registerVarargEvent("resumeOnlyCurrentThread", new EventField[]{EventFields.Enabled});
    private static final VarargEventId HIDE_STACK_FRAMES_USING_STEPPING_FILTER = GROUP.registerVarargEvent("hideStackFramesUsingSteppingFilter", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INSTRUMENTING_AGENT = GROUP.registerVarargEvent("instrumentingAgent", new EventField[]{EventFields.Enabled});
    private static final VarargEventId AGENT_THROTTLING = GROUP.registerVarargEvent("agentThrottling", "Debugger agent throttling in case of detected overhead", new EventField[]{EventFields.Enabled});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet<MetricEvent> set = new HashSet<MetricEvent>();
        DebuggerSettings settings = DebuggerSettings.getInstance();
        DebuggerSettings sDefault = new DebuggerSettings();
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.SHOW_ALTERNATIVE_SOURCE, (VarargEventId)SHOW_ALTERNATIVE_SOURCE);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.ENABLE_MEMORY_AGENT, (VarargEventId)ENABLE_MEMORY_AGENT);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.ALWAYS_SMART_STEP_INTO, (VarargEventId)ALWAYS_SMART_STEP_INTO);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.SKIP_CONSTRUCTORS, (VarargEventId)SKIP_CONSTRUCTORS);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.SKIP_GETTERS, (VarargEventId)SKIP_GETTERS);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.SKIP_CLASSLOADERS, (VarargEventId)SKIP_CLASSLOADERS);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.COMPILE_BEFORE_HOTSWAP, (VarargEventId)COMPILE_BEFORE_HOTSWAP);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.HOTSWAP_SHOW_FLOATING_BUTTON, (VarargEventId)HOTSWAP_SHOW_FLOATING_BUTTON);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.HOTSWAP_HANG_WARNING_ENABLED, (VarargEventId)HOTSWAP_HANG_WARNING_ENABLED);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.WATCH_RETURN_VALUES, (VarargEventId)WATCH_RETURN_VALUES);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.AUTO_VARIABLES_MODE, (VarargEventId)AUTO_VARIABLES_MODE);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.KILL_PROCESS_IMMEDIATELY, (VarargEventId)KILL_PROCESS_IMMEDIATELY);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.RESUME_ONLY_CURRENT_THREAD, (VarargEventId)RESUME_ONLY_CURRENT_THREAD);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.HIDE_STACK_FRAMES_USING_STEPPING_FILTER, (VarargEventId)HIDE_STACK_FRAMES_USING_STEPPING_FILTER);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.INSTRUMENTING_AGENT, (VarargEventId)INSTRUMENTING_AGENT);
        MetricEventUtilKt.addBoolIfDiffers(set, (Object)settings, (Object)sDefault, s -> s.AGENT_THROTTLING, (VarargEventId)AGENT_THROTTLING);
        HashSet<MetricEvent> hashSet = set;
        if (hashSet == null) {
            DebuggerSettingsStatisticsCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/DebuggerSettingsStatisticsCollector", "getMetrics"));
    }
}

