/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.statistics;

import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.SteppingAction;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.statistics.BreakpointInstallStatistic;
import com.intellij.debugger.statistics.Engine;
import com.intellij.debugger.statistics.EvaluationOnPauseStatus;
import com.intellij.debugger.statistics.StatisticElement;
import com.intellij.debugger.statistics.StatisticsStorage;
import com.intellij.debugger.statistics.StatisticsStorageKt;
import com.intellij.debugger.statistics.SteppingStatistic;
import com.intellij.debugger.statistics.ThreadDumpStatus;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007J\u001c\u00101\u001a\u00020.2\n\u00102\u001a\u0006\u0012\u0002\b\u0003032\u0006\u00104\u001a\u00020\u0015H\u0007J\u001c\u00105\u001a\u00020.2\n\u00102\u001a\u0006\u0012\u0002\b\u0003032\u0006\u00104\u001a\u00020\u0015H\u0007J\u001c\u00106\u001a\u00020.2\n\u00102\u001a\u0006\u0012\u0002\b\u0003032\u0006\u00104\u001a\u00020\u0015H\u0007J \u00107\u001a\u00020.2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u00104\u001a\u00020\u0015H\u0007J\u001a\u0010<\u001a\u00020.2\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;H\u0007J\u0018\u0010=\u001a\u00020.2\u0006\u00108\u001a\u0002092\u0006\u0010>\u001a\u00020\u001fH\u0007J\"\u0010?\u001a\u00020.2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u001cH\u0007J\u001a\u0010B\u001a\u00020.2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010C\u001a\u00020'H\u0007J\u001a\u0010D\u001a\u00020.2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010C\u001a\u00020'H\u0007J\u0012\u0010E\u001a\u00020.2\b\u00108\u001a\u0004\u0018\u000109H\u0007J\u001a\u0010F\u001a\u00020.2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010G\u001a\u00020\u0014H\u0007J\"\u0010H\u001a\u00020.2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010C\u001a\u00020'2\u0006\u0010I\u001a\u00020'H\u0002J\u0018\u0010J\u001a\u00020.2\u0006\u00108\u001a\u0002092\u0006\u0010K\u001a\u00020\"H\u0007J\u0018\u0010L\u001a\u00020.2\u0006\u00108\u001a\u0002092\u0006\u0010M\u001a\u00020\"H\u0007J\u0018\u0010N\u001a\u00020.2\u0006\u00108\u001a\u0002092\u0006\u0010A\u001a\u00020!H\u0007J\u0016\u0010O\u001a\u00020.2\u0006\u00108\u001a\u0002092\u0006\u0010P\u001a\u00020\u0015R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00150\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001c0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010 \u001a\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0004\u0012\u00020\"0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010&\u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020'0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\u00020)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010Q\u001a\u0004\u0018\u00010\u0014*\u0006\u0012\u0002\b\u0003038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010S\u00a8\u0006T"}, d2={"Lcom/intellij/debugger/statistics/DebuggerStatistics;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "breakpointTypeField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "steppingActionField", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/debugger/engine/SteppingAction;", "languageField", "Lcom/intellij/debugger/statistics/Engine;", "dumpedCoroutinesCounter", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "dumpedVirtualThreadsCounter", "threadDumpTriggeringExceptionField", "breakpointInstallationOverhead", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "", "breakpointInstallSearchOverhead", "breakpointVisitOverhead", "steppingOverhead", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "steppingFailedMethodNotCalled", "smartStepTargetsDetection", "Lcom/intellij/debugger/actions/JvmSmartStepIntoHandler$SmartStepIntoDetectionStatus;", "breakpointSkipped", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lcom/intellij/debugger/engine/DebugProcessEvents$SkippedBreakpointReason;", "threadDump", "Lcom/intellij/debugger/statistics/ThreadDumpStatus;", "", "evaluationOnPause", "Lcom/intellij/debugger/statistics/EvaluationOnPauseStatus;", "threadDumpTriggeringException", "timeBucketCount", "", "bucketUpperLimits", "", "getBucketUpperLimits$intellij_java_debugger_impl", "()[J", "agentOverheadDetected", "logProcessStatistics", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "logBreakpointInstallOverhead", "breakpoint", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "timeMs", "logBreakpointInstallSearchOverhead", "logBreakpointVisit", "logSteppingOverhead", "project", "Lcom/intellij/openapi/project/Project;", "statistic", "Lcom/intellij/debugger/statistics/SteppingStatistic;", "logMethodSkippedDuringStepping", "logBreakpointSkipped", "reason", "logSmartStepIntoTargetsDetection", "language", "status", "logEvaluatablePauseSuccess", "isDebuggerAgentAvailable", "logEvaluatablePauseFailure", "logEvaluatablePauseDisabled", "logThreadDumpTriggerException", "name", "logEvaluatablePauseStatus", "isSuccess", "logCoroutineDump", "coroutinesCount", "logVirtualThreadsDump", "virtualThreadsCount", "logPlatformThreadDumpFallback", "logAgentOverheadDetected", "passedSinceSessionStartMs", "type", "getType", "(Lcom/intellij/debugger/ui/breakpoints/Breakpoint;)Ljava/lang/String;", "intellij.java.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDebuggerStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerStatistics.kt\ncom/intellij/debugger/statistics/DebuggerStatistics\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,197:1\n11745#2:198\n12096#2,3:199\n261#3,3:202\n261#3,3:205\n261#3,3:208\n261#3,3:211\n261#3,3:214\n261#3,3:217\n*S KotlinDebug\n*F\n+ 1 DebuggerStatistics.kt\ncom/intellij/debugger/statistics/DebuggerStatistics\n*L\n99#1:198\n99#1:199,3\n45#1:202,3\n46#1:205,3\n66#1:208,3\n68#1:211,3\n70#1:214,3\n73#1:217,3\n*E\n"})
public final class DebuggerStatistics
extends CounterUsagesCollector {
    @NotNull
    public static final DebuggerStatistics INSTANCE;
    @NotNull
    private static final EventLogGroup GROUP;
    @NotNull
    private static final StringEventField breakpointTypeField;
    @NotNull
    private static final EnumEventField<SteppingAction> steppingActionField;
    @NotNull
    private static final EnumEventField<Engine> languageField;
    @NotNull
    private static final IntEventField dumpedCoroutinesCounter;
    @NotNull
    private static final IntEventField dumpedVirtualThreadsCounter;
    @NotNull
    private static final StringEventField threadDumpTriggeringExceptionField;
    @NotNull
    private static final EventId2<String, Long> breakpointInstallationOverhead;
    @NotNull
    private static final EventId2<String, Long> breakpointInstallSearchOverhead;
    @NotNull
    private static final EventId2<String, Long> breakpointVisitOverhead;
    @NotNull
    private static final EventId3<SteppingAction, Engine, Long> steppingOverhead;
    @NotNull
    private static final EventId2<SteppingAction, Engine> steppingFailedMethodNotCalled;
    @NotNull
    private static final EventId2<Engine, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus> smartStepTargetsDetection;
    @NotNull
    private static final EventId1<DebugProcessEvents.SkippedBreakpointReason> breakpointSkipped;
    @NotNull
    private static final EventId3<ThreadDumpStatus, Integer, Integer> threadDump;
    @NotNull
    private static final EventId1<EvaluationOnPauseStatus> evaluationOnPause;
    @NotNull
    private static final EventId2<String, Integer> threadDumpTriggeringException;
    @NotNull
    private static final EventId3<Integer, Integer, Boolean> timeBucketCount;
    @NotNull
    private static final long[] bucketUpperLimits;
    @NotNull
    private static final EventId1<Long> agentOverheadDetected;

    private DebuggerStatistics() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public final long[] getBucketUpperLimits$intellij_java_debugger_impl() {
        return bucketUpperLimits;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void logProcessStatistics(@NotNull DebugProcess debugProcess) {
        void $this$mapTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Map<StatisticElement, Long> collectedStats = StatisticsStorage.Companion.collectAndClearData(debugProcess);
        for (Map.Entry<StatisticElement, Long> entry : collectedStats.entrySet()) {
            StatisticElement key = entry.getKey();
            long timeMs = ((Number)entry.getValue()).longValue();
            object = key;
            if (object instanceof BreakpointInstallStatistic) {
                DebuggerStatistics.logBreakpointInstallOverhead(((BreakpointInstallStatistic)key).getBreakpoint(), timeMs);
                continue;
            }
            if (object instanceof SteppingStatistic) {
                Project project = debugProcess.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                DebuggerStatistics.logSteppingOverhead(project, (SteppingStatistic)key, timeMs);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        boolean isRemote = DebuggerUtilsImpl.isRemote(debugProcess);
        int[] bucketCounts = StatisticsStorage.Companion.collectCommandsPerformance$intellij_java_debugger_impl(debugProcess);
        long[] $this$map$iv = bucketUpperLimits;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_18 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it == Long.MAX_VALUE ? Integer.MAX_VALUE : (int)it);
        }
        int[] intUpperLimits = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        for (Pair pair : ArraysKt.zip((int[])intUpperLimits, (int[])bucketCounts)) {
            int upperLimitMs = ((Number)pair.component1()).intValue();
            int count = ((Number)pair.component2()).intValue();
            timeBucketCount.log(debugProcess.getProject(), (Object)upperLimitMs, (Object)count, (Object)isRemote);
        }
    }

    @JvmStatic
    public static final void logBreakpointInstallOverhead(@NotNull Breakpoint<?> breakpoint, long timeMs) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        String string = INSTANCE.getType(breakpoint);
        if (string == null) {
            return;
        }
        String type = string;
        breakpointInstallationOverhead.log(breakpoint.getProject(), (Object)type, (Object)timeMs);
    }

    @JvmStatic
    public static final void logBreakpointInstallSearchOverhead(@NotNull Breakpoint<?> breakpoint, long timeMs) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        String string = INSTANCE.getType(breakpoint);
        if (string == null) {
            return;
        }
        String type = string;
        breakpointInstallSearchOverhead.log(breakpoint.getProject(), (Object)type, (Object)timeMs);
    }

    @JvmStatic
    public static final void logBreakpointVisit(@NotNull Breakpoint<?> breakpoint, long timeMs) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        String string = INSTANCE.getType(breakpoint);
        if (string == null) {
            return;
        }
        String type = string;
        breakpointVisitOverhead.log(breakpoint.getProject(), (Object)type, (Object)timeMs);
    }

    @JvmStatic
    public static final void logSteppingOverhead(@NotNull Project project, @NotNull SteppingStatistic statistic, long timeMs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)statistic, (String)"statistic");
        steppingOverhead.log(project, (Object)statistic.getAction(), (Object)statistic.getEngine(), (Object)timeMs);
    }

    @JvmStatic
    public static final void logMethodSkippedDuringStepping(@NotNull Project project, @Nullable SteppingStatistic statistic) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (statistic == null) {
            return;
        }
        steppingFailedMethodNotCalled.log(project, (Object)statistic.getAction(), (Object)statistic.getEngine());
    }

    @JvmStatic
    public static final void logBreakpointSkipped(@NotNull Project project, @NotNull DebugProcessEvents.SkippedBreakpointReason reason) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        breakpointSkipped.log(project, (Object)reason);
    }

    @JvmStatic
    public static final void logSmartStepIntoTargetsDetection(@Nullable Project project, @NotNull Engine language, @NotNull JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        smartStepTargetsDetection.log(project, (Object)language, (Object)status);
    }

    @JvmStatic
    public static final void logEvaluatablePauseSuccess(@Nullable Project project, boolean isDebuggerAgentAvailable) {
        INSTANCE.logEvaluatablePauseStatus(project, isDebuggerAgentAvailable, true);
    }

    @JvmStatic
    public static final void logEvaluatablePauseFailure(@Nullable Project project, boolean isDebuggerAgentAvailable) {
        INSTANCE.logEvaluatablePauseStatus(project, isDebuggerAgentAvailable, false);
    }

    @JvmStatic
    public static final void logEvaluatablePauseDisabled(@Nullable Project project) {
        evaluationOnPause.log(project, (Object)EvaluationOnPauseStatus.EVALUATION_ON_PAUSE_DISABLED);
    }

    @JvmStatic
    public static final void logThreadDumpTriggerException(@Nullable Project project, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        threadDumpTriggeringException.log(project, (Object)name, (Object)1);
    }

    private final void logEvaluatablePauseStatus(Project project, boolean isDebuggerAgentAvailable, boolean isSuccess) {
        EvaluationOnPauseStatus status = isDebuggerAgentAvailable ? (AsyncStacksUtils.isSuspendHelperEnabled() ? (isSuccess ? EvaluationOnPauseStatus.DEBUGGER_AGENT_HELPER_THREAD_ENABLED_SUCCESS : EvaluationOnPauseStatus.DEBUGGER_AGENT_HELPER_THREAD_ENABLED_FAILURE) : (isSuccess ? EvaluationOnPauseStatus.DEBUGGER_AGENT_HELPER_THREAD_DISABLED_SUCCESS : EvaluationOnPauseStatus.DEBUGGER_AGENT_HELPER_THREAD_DISABLED_FAILURE)) : (isSuccess ? EvaluationOnPauseStatus.NO_DEBUGGER_AGENT_SUCCESS : EvaluationOnPauseStatus.NO_DEBUGGER_AGENT_FAILURE);
        evaluationOnPause.log(project, (Object)status);
    }

    @JvmStatic
    public static final void logCoroutineDump(@NotNull Project project, int coroutinesCount) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        threadDump.log(project, (Object)ThreadDumpStatus.EXTENDED_DUMP, (Object)coroutinesCount, (Object)-1);
    }

    @JvmStatic
    public static final void logVirtualThreadsDump(@NotNull Project project, int virtualThreadsCount) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        threadDump.log(project, (Object)ThreadDumpStatus.EXTENDED_DUMP, (Object)-1, (Object)virtualThreadsCount);
    }

    @JvmStatic
    public static final void logPlatformThreadDumpFallback(@NotNull Project project, @NotNull ThreadDumpStatus status) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        threadDump.log(project, (Object)status, (Object)-1, (Object)-1);
    }

    public final void logAgentOverheadDetected(@NotNull Project project, long passedSinceSessionStartMs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        agentOverheadDetected.log(project, (Object)passedSinceSessionStartMs);
    }

    private final String getType(Breakpoint<?> $this$type) {
        XBreakpointType xBreakpointType = $this$type.getXBreakpoint();
        return xBreakpointType != null && (xBreakpointType = xBreakpointType.getType()) != null ? xBreakpointType.getId() : null;
    }

    private static final Long bucketUpperLimits$lambda$0(long it) {
        return it * (long)2;
    }

    private static final boolean bucketUpperLimits$lambda$1(long it) {
        return it <= 2048L;
    }

    static {
        EventFields $this$iv;
        INSTANCE = new DebuggerStatistics();
        GROUP = new EventLogGroup("java.debugger", 16, null, 4, null);
        String[] stringArray = new String[]{"java-exception", "java-collection", "java-wildcard-method", "java-line", "java-field", "java-method", "kotlin-line", "kotlin-field", "kotlin-function"};
        breakpointTypeField = EventFields.String((String)"type", (List)CollectionsKt.listOf((Object[])stringArray));
        stringArray = EventFields.INSTANCE;
        String name$iv = "step_action";
        Function1 transform$iv = $this$iv.getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        steppingActionField = new EnumEventField(name$iv, SteppingAction.class, null, transform$iv);
        $this$iv = EventFields.INSTANCE;
        name$iv = "language";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        languageField = new EnumEventField(name$iv, Engine.class, null, transform$iv);
        dumpedCoroutinesCounter = EventFields.Int((String)"coroutines");
        dumpedVirtualThreadsCounter = EventFields.Int((String)"virtual_threads");
        threadDumpTriggeringExceptionField = EventFields.String((String)"exception", StatisticsStorageKt.getTHREAD_DUMP_TRIGGERING_EXCEPTIONS_TO_LOG());
        breakpointInstallationOverhead = GROUP.registerEvent("breakpoint.install.overhead", (EventField)breakpointTypeField, (EventField)EventFields.DurationMs);
        breakpointInstallSearchOverhead = GROUP.registerEvent("breakpoint.install.search.overhead", (EventField)breakpointTypeField, (EventField)EventFields.DurationMs);
        breakpointVisitOverhead = GROUP.registerEvent("breakpoint.visit.overhead", (EventField)breakpointTypeField, (EventField)EventFields.DurationMs);
        steppingOverhead = GROUP.registerEvent("stepping.overhead", (EventField)steppingActionField, (EventField)languageField, (EventField)EventFields.DurationMs);
        steppingFailedMethodNotCalled = GROUP.registerEvent("stepping.method.not.called", (EventField)steppingActionField, (EventField)languageField);
        $this$iv = EventFields.INSTANCE;
        name$iv = "status";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        smartStepTargetsDetection = GROUP.registerEvent("smart.step.into.targets.detected", (EventField)languageField, (EventField)new EnumEventField(name$iv, JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.class, null, transform$iv));
        $this$iv = EventFields.INSTANCE;
        name$iv = "reason";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        breakpointSkipped = GROUP.registerEvent("breakpoint.skipped", (EventField)new EnumEventField(name$iv, DebugProcessEvents.SkippedBreakpointReason.class, null, transform$iv));
        $this$iv = EventFields.INSTANCE;
        name$iv = "status";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        threadDump = GROUP.registerEvent("thread.dump", (EventField)new EnumEventField(name$iv, ThreadDumpStatus.class, null, transform$iv), (EventField)dumpedCoroutinesCounter, (EventField)dumpedVirtualThreadsCounter);
        $this$iv = EventFields.INSTANCE;
        name$iv = "status";
        transform$iv = $this$iv.getDefaultEnumTransform();
        $i$f$Enum = false;
        evaluationOnPause = GROUP.registerEvent("evaluation.on.pause", (EventField)new EnumEventField(name$iv, EvaluationOnPauseStatus.class, null, transform$iv));
        threadDumpTriggeringException = GROUP.registerEvent("thread.dump.triggering.exception", (EventField)threadDumpTriggeringExceptionField, (EventField)EventFields.Count);
        timeBucketCount = GROUP.registerEvent("debugger.command.time.bucket.updated", (EventField)EventFields.Int((String)"bucket_upper_limit_ms"), (EventField)EventFields.Count, (EventField)EventFields.Boolean((String)"is_remote"));
        bucketUpperLimits = CollectionsKt.toLongArray((Collection)SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)1L, DebuggerStatistics::bucketUpperLimits$lambda$0), DebuggerStatistics::bucketUpperLimits$lambda$1), (Object)Long.MAX_VALUE)));
        agentOverheadDetected = GROUP.registerEvent("debugger.agent.overhead.detected", (EventField)EventFields.Long$default((String)"passed_since_session_start_ms", null, (int)2, null), "Detected noticeable overhead of the debugger agent due to async stack traces collection");
    }
}

