/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.statistics;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.SteppingAction;
import com.intellij.debugger.statistics.BreakpointInstallStatistic;
import com.intellij.debugger.statistics.DebuggerStatistics;
import com.intellij.debugger.statistics.Engine;
import com.intellij.debugger.statistics.StatisticElement;
import com.intellij.debugger.statistics.StatisticsStorage;
import com.intellij.debugger.statistics.StatisticsStorageKt;
import com.intellij.debugger.statistics.SteppingStatistic;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0002\b\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/debugger/statistics/StatisticsStorage;", "", "<init>", "()V", "data", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/debugger/statistics/StatisticElement;", "", "timeBucketCounts", "", "append", "key", "timeMs", "(Lcom/intellij/debugger/statistics/StatisticElement;J)Ljava/lang/Long;", "remove", "(Lcom/intellij/debugger/statistics/StatisticElement;)Ljava/lang/Long;", "Companion", "intellij.java.debugger.impl"})
public final class StatisticsStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<StatisticElement, Long> data = new ConcurrentHashMap();
    @NotNull
    private final int[] timeBucketCounts = new int[DebuggerStatistics.INSTANCE.getBucketUpperLimits$intellij_java_debugger_impl().length];

    private final Long append(StatisticElement key, long timeMs) {
        return this.data.merge(key, timeMs, (arg_0, arg_1) -> StatisticsStorage.append$lambda$0(append.1.INSTANCE, arg_0, arg_1));
    }

    private final Long remove(StatisticElement key) {
        return this.data.remove(key);
    }

    private static final Long append$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        return (Long)$tmp0.invoke(p0, p1);
    }

    @JvmStatic
    public static final void addBreakpointInstall(@NotNull DebugProcess debugProcess, @NotNull Breakpoint<?> breakpoint, long timeMs) {
        Companion.addBreakpointInstall(debugProcess, breakpoint, timeMs);
    }

    @JvmStatic
    public static final void addStepping(@NotNull DebugProcess debugProcess, @Nullable Object token, long timeMs) {
        Companion.addStepping(debugProcess, token, timeMs);
    }

    @JvmStatic
    public static final void stepRequestCompleted(@NotNull DebugProcess debugProcess, @Nullable Object token) {
        Companion.stepRequestCompleted(debugProcess, token);
    }

    @JvmStatic
    @NotNull
    public static final Object createSteppingToken(@NotNull SteppingAction action, @NotNull Engine engine) {
        return Companion.createSteppingToken(action, engine);
    }

    @JvmStatic
    @NotNull
    public static final synchronized Map<StatisticElement, Long> collectAndClearData(@NotNull DebugProcess debugProcess) {
        return Companion.collectAndClearData(debugProcess);
    }

    @JvmStatic
    @Nullable
    public static final SteppingStatistic getSteppingStatisticOrNull(@Nullable Object token) {
        return Companion.getSteppingStatisticOrNull(token);
    }

    @JvmStatic
    public static final void addCommandTime(@NotNull DebugProcess debugProcess, long timeMs) {
        Companion.addCommandTime(debugProcess, timeMs);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\"\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\rH\u0007J\u001a\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0007J\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0007J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/debugger/statistics/StatisticsStorage$Companion;", "", "<init>", "()V", "getStorage", "Lcom/intellij/debugger/statistics/StatisticsStorage;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "addBreakpointInstall", "", "breakpoint", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "timeMs", "", "addStepping", "token", "stepRequestCompleted", "createSteppingToken", "action", "Lcom/intellij/debugger/engine/SteppingAction;", "engine", "Lcom/intellij/debugger/statistics/Engine;", "collectAndClearData", "", "Lcom/intellij/debugger/statistics/StatisticElement;", "getSteppingStatisticOrNull", "Lcom/intellij/debugger/statistics/SteppingStatistic;", "addCommandTime", "collectCommandsPerformance", "", "collectCommandsPerformance$intellij_java_debugger_impl", "intellij.java.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nStatisticsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsStorage.kt\ncom/intellij/debugger/statistics/StatisticsStorage$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,153:1\n1839#2,6:154\n57#3:160\n35#3,2:161\n*S KotlinDebug\n*F\n+ 1 StatisticsStorage.kt\ncom/intellij/debugger/statistics/StatisticsStorage$Companion\n*L\n72#1:154,6\n74#1:160\n74#1:161,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final StatisticsStorage getStorage(DebugProcess debugProcess) {
            Object storage = null;
            storage = debugProcess.getUserData(StatisticsStorageKt.access$getKEY$p());
            if (storage == null) {
                DebugProcess debugProcess2 = debugProcess;
                synchronized (debugProcess2) {
                    boolean bl = false;
                    storage = debugProcess.getUserData(StatisticsStorageKt.access$getKEY$p());
                    if (storage == null) {
                        storage = new StatisticsStorage();
                        debugProcess.putUserData(StatisticsStorageKt.access$getKEY$p(), storage);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return (StatisticsStorage)storage;
        }

        @JvmStatic
        public final void addBreakpointInstall(@NotNull DebugProcess debugProcess, @NotNull Breakpoint<?> breakpoint, long timeMs) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            this.getStorage(debugProcess).append(new BreakpointInstallStatistic(breakpoint), timeMs);
        }

        @JvmStatic
        public final void addStepping(@NotNull DebugProcess debugProcess, @Nullable Object token, long timeMs) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            if (!(token instanceof SteppingStatistic)) {
                return;
            }
            this.getStorage(debugProcess).append((StatisticElement)token, timeMs);
        }

        @JvmStatic
        public final void stepRequestCompleted(@NotNull DebugProcess debugProcess, @Nullable Object token) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            if (!(token instanceof SteppingStatistic)) {
                return;
            }
            Long l = this.getStorage(debugProcess).remove((StatisticElement)token);
            if (l == null) {
                return;
            }
            long timeMs = l;
            Project project = debugProcess.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DebuggerStatistics.logSteppingOverhead(project, (SteppingStatistic)token, timeMs);
        }

        @JvmStatic
        @NotNull
        public final Object createSteppingToken(@NotNull SteppingAction action, @NotNull Engine engine) {
            Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
            Intrinsics.checkNotNullParameter((Object)((Object)engine), (String)"engine");
            return new SteppingStatistic(action, engine);
        }

        @JvmStatic
        @NotNull
        public final synchronized Map<StatisticElement, Long> collectAndClearData(@NotNull DebugProcess debugProcess) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            StatisticsStorage storage = this.getStorage(debugProcess);
            HashMap result = new HashMap(storage.data);
            storage.data.clear();
            return result;
        }

        @JvmStatic
        @Nullable
        public final SteppingStatistic getSteppingStatisticOrNull(@Nullable Object token) {
            return token instanceof SteppingStatistic ? (SteppingStatistic)token : null;
        }

        @JvmStatic
        public final void addCommandTime(@NotNull DebugProcess debugProcess, long timeMs) {
            int bucketIndex;
            StatisticsStorage storage;
            block2: {
                int n;
                Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                storage = this.getStorage(debugProcess);
                long[] $this$indexOfFirst$iv = DebuggerStatistics.INSTANCE.getBucketUpperLimits$intellij_java_debugger_impl();
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length;
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    long it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (!(timeMs <= it)) continue;
                    n = index$iv;
                    break block2;
                }
                n = bucketIndex = -1;
            }
            if (bucketIndex < 0) {
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Unexpected command time " + timeMs + ", found no bucket for it: " + DebuggerStatistics.INSTANCE.getBucketUpperLimits$intellij_java_debugger_impl());
                return;
            }
            int[] nArray = storage.timeBucketCounts;
            int n = nArray[bucketIndex];
            nArray[bucketIndex] = n + 1;
        }

        @NotNull
        public final synchronized int[] collectCommandsPerformance$intellij_java_debugger_impl(@NotNull DebugProcess debugProcess) {
            int[] nArray;
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            StatisticsStorage storage = this.getStorage(debugProcess);
            int[] nArray2 = storage.timeBucketCounts;
            int[] nArray3 = Arrays.copyOf(nArray2, nArray2.length);
            Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"copyOf(...)");
            int[] it = nArray = nArray3;
            boolean bl = false;
            ArraysKt.fill$default((int[])storage.timeBucketCounts, (int)0, (int)0, (int)0, (int)6, null);
            return nArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

