/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.AlternativeSourceNotificationProvider;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.TextWithIcon;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlternativeSourceNotificationPanel
extends EditorNotificationPanel {
    public AlternativeSourceNotificationPanel(@NotNull FileEditor fileEditor, final @NotNull Project project, @NotNull @Nls String text, final @NotNull VirtualFile file, AlternativeSourceElement[] alternatives, final @Nullable String locationDeclName) {
        if (fileEditor == null) {
            AlternativeSourceNotificationPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AlternativeSourceNotificationPanel.$$$reportNull$$$0(1);
        }
        if (text == null) {
            AlternativeSourceNotificationPanel.$$$reportNull$$$0(2);
        }
        if (file == null) {
            AlternativeSourceNotificationPanel.$$$reportNull$$$0(3);
        }
        super(fileEditor, EditorNotificationPanel.Status.Info);
        this.setText(text);
        final ComboBox switcher = new ComboBox((Object[])alternatives);
        switcher.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WriteIntentReadAction.run(() -> {
                    DebuggerSession session = DebuggerManagerEx.getInstanceEx(project).getContext().getDebuggerSession();
                    PsiElement item = ((AlternativeSourceElement)switcher2.getSelectedItem()).myElement;
                    VirtualFile vFile = item.getContainingFile().getVirtualFile();
                    if (session != null && vFile != null) {
                        session.getProcess().getManagerThread().schedule(PrioritizedTask.Priority.LOW, () -> {
                            if (!StringUtil.isEmpty((String)locationDeclName)) {
                                DebuggerUtilsEx.setAlternativeSourceUrl(locationDeclName, vFile.getUrl(), project);
                            }
                            DebuggerUIUtil.invokeLater(() -> {
                                FileEditorManager.getInstance((Project)project).closeFile(file);
                                session.refresh(true);
                            });
                        });
                    } else if (item instanceof Navigatable) {
                        Navigatable navigatable = (Navigatable)item;
                        FileEditorManager.getInstance((Project)project).closeFile(file);
                        navigatable.navigate(true);
                    }
                });
            }
        });
        this.myLinksPanel.add((Component)switcher);
        this.createActionLabel(JavaDebuggerBundle.message((String)"action.hide.text", (Object[])new Object[0]), () -> {
            DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE = false;
            AlternativeSourceNotificationProvider.setFileProcessed(file, false);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            FileEditor editor = fileEditorManager.getSelectedEditor(file);
            if (editor != null) {
                fileEditorManager.removeTopComponent(editor, (JComponent)((Object)this));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fileEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/ui/AlternativeSourceNotificationPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AlternativeSourceElement {
        private final PsiElement myElement;
        private final String myText;

        /*
         * WARNING - void declaration
         */
        @RequiresBackgroundThread
        public AlternativeSourceElement(PsiElement psiElement) {
            void element;
            ThreadingAssertions.assertBackgroundThread();
            this.myElement = element;
            TextWithIcon moduleTextWithIcon = ModuleRendererFactory.findInstance((Object)element).getModuleTextWithIcon((Object)element);
            this.myText = moduleTextWithIcon == null ? "" : moduleTextWithIcon.getText();
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        public String toString() {
            return this.myText;
        }
    }
}

