/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

public final class FieldBreakpoint
extends BreakpointWithHighlighter<JavaFieldBreakpointProperties> {
    private static final Logger LOG = Logger.getInstance(FieldBreakpoint.class);
    @NonNls
    public static final Key<FieldBreakpoint> CATEGORY = BreakpointCategory.lookup("field_breakpoints");

    FieldBreakpoint(Project project, XBreakpoint breakpoint) {
        super(project, breakpoint);
    }

    private FieldBreakpoint(Project project, @NotNull String fieldName, XBreakpoint breakpoint) {
        if (fieldName == null) {
            FieldBreakpoint.$$$reportNull$$$0(0);
        }
        super(project, breakpoint);
        this.setFieldName(fieldName);
    }

    @NlsSafe
    public String getFieldName() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myFieldName;
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) != null && isMuted) {
            return AllIcons.Debugger.Db_muted_dep_field_breakpoint;
        }
        return null;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return this.isSuspend() ? AllIcons.Debugger.Db_verified_field_breakpoint : AllIcons.Debugger.Db_verified_no_suspend_field_breakpoint;
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return LayeredIcon.layeredIcon((Icon[])new Icon[]{isMuted ? AllIcons.Debugger.Db_muted_field_breakpoint : AllIcons.Debugger.Db_field_breakpoint, AllIcons.General.WarningDecorator});
    }

    @Override
    public Key<FieldBreakpoint> getCategory() {
        return CATEGORY;
    }

    public PsiField getPsiField() {
        SourcePosition sourcePosition = this.getSourcePosition();
        try {
            PsiField field = (PsiField)ReadAction.compute(() -> {
                PsiClass psiClass = FieldBreakpoint.getPsiClassAt(sourcePosition);
                return psiClass != null ? psiClass.findFieldByName(this.getFieldName(), false) : null;
            });
            if (field != null) {
                return field;
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return PositionUtil.getPsiElementAt(this.myProject, PsiField.class, sourcePosition);
    }

    @Override
    @RequiresBackgroundThread
    public void reload() {
        ThreadingAssertions.assertBackgroundThread();
        super.reload();
        PsiField field = PositionUtil.getPsiElementAt(this.myProject, PsiField.class, this.getSourcePosition());
        if (field != null) {
            this.setFieldName(field.getName());
            PsiClass psiClass = field.getContainingClass();
            if (psiClass != null) {
                ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myClassName = psiClass.getQualifiedName();
            }
            if (field.hasModifierProperty("static")) {
                this.setInstanceFiltersEnabled(false);
            }
        }
    }

    @Override
    protected ObjectReference getThisObject(SuspendContextImpl context, LocatableEvent event) throws EvaluateException {
        ObjectReference reference;
        if (event instanceof ModificationWatchpointEvent) {
            ObjectReference reference2 = ((ModificationWatchpointEvent)event).object();
            if (reference2 != null) {
                return reference2;
            }
        } else if (event instanceof AccessWatchpointEvent && (reference = ((AccessWatchpointEvent)event).object()) != null) {
            return reference;
        }
        return super.getThisObject(context, event);
    }

    @Override
    public void createRequestForPreparedClass(DebugProcessImpl debugProcess, @NotNull ReferenceType refType) {
        if (refType == null) {
            FieldBreakpoint.$$$reportNull$$$0(1);
        }
        try {
            RequestManagerImpl manager = debugProcess.getRequestsManager();
            Field field = DebuggerUtils.findField((ReferenceType)refType, (String)this.getFieldName());
            if (field == null) {
                manager.setInvalid(this, JavaDebuggerBundle.message((String)"error.invalid.breakpoint.missing.field.in.class", (Object[])new Object[]{this.getFieldName(), refType.name()}));
                return;
            }
            if (this.isWatchModification() && refType.virtualMachine().canWatchFieldModification()) {
                manager.enableRequest(manager.createModificationWatchpointRequest(this, field));
                LOG.debug("Modification request added");
            }
            if (this.isWatchAccess() && refType.virtualMachine().canWatchFieldAccess()) {
                manager.enableRequest(manager.createAccessWatchpointRequest(this, field));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Access request added field = " + field.name() + "; refType = " + refType.name());
                }
            }
        }
        catch (Exception ex) {
            LOG.debug((Throwable)ex);
        }
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        Location location = event.location();
        String locationQName = DebuggerUtilsEx.getLocationMethodQName(location);
        String locationFileName = DebuggerUtilsEx.getSourceName(location, e -> this.getFileName());
        int locationLine = location.lineNumber();
        if (event instanceof ModificationWatchpointEvent) {
            ModificationWatchpointEvent modificationEvent = (ModificationWatchpointEvent)event;
            ObjectReference object = modificationEvent.object();
            Field field = modificationEvent.field();
            if (object != null) {
                return JavaDebuggerBundle.message((String)"status.field.watchpoint.reached.modification", (Object[])new Object[]{field.declaringType().name(), field.name(), modificationEvent.valueCurrent(), modificationEvent.valueToBe(), locationQName, locationFileName, locationLine, object.uniqueID()});
            }
            return JavaDebuggerBundle.message((String)"status.static.field.watchpoint.reached.modification", (Object[])new Object[]{field.declaringType().name(), field.name(), modificationEvent.valueCurrent(), modificationEvent.valueToBe(), locationQName, locationFileName, locationLine});
        }
        if (event instanceof AccessWatchpointEvent) {
            AccessWatchpointEvent accessEvent = (AccessWatchpointEvent)event;
            ObjectReference object = accessEvent.object();
            Field field = accessEvent.field();
            if (object != null) {
                return JavaDebuggerBundle.message((String)"status.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), locationQName, locationFileName, locationLine, object.uniqueID()});
            }
            return JavaDebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), locationQName, locationFileName, locationLine});
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        if (!this.isValid()) {
            return JavaDebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
        }
        String className = this.getClassName();
        return className != null && !className.isEmpty() ? className + "." + this.getFieldName() : this.getFieldName();
    }

    public static FieldBreakpoint create(@NotNull Project project, String fieldName, XBreakpoint xBreakpoint) {
        if (project == null) {
            FieldBreakpoint.$$$reportNull$$$0(2);
        }
        FieldBreakpoint breakpoint = new FieldBreakpoint(project, fieldName, xBreakpoint);
        return (FieldBreakpoint)breakpoint.init();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getPsiField() != null;
    }

    @Override
    public boolean isAt(@NotNull Document document, int offset) {
        PsiField field;
        if (document == null) {
            FieldBreakpoint.$$$reportNull$$$0(3);
        }
        return (field = FieldBreakpoint.findField(this.myProject, document, offset)) == this.getPsiField();
    }

    public static PsiField findField(Project project, Document document, int offset) {
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            return null;
        }
        offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)offset, (String)" \t");
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false);
        int line = document.getLineNumber(offset);
        if (field == null) {
            PsiField[] fld = new PsiField[]{null};
            XDebuggerUtil.getInstance().iterateLine(project, document, line, element1 -> {
                PsiField field1 = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element1, PsiField.class, (boolean)false);
                if (field1 != null) {
                    fld[0] = field1;
                    return false;
                }
                return true;
            });
            field = fld[0];
        }
        return field;
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        if (breakpointNode == null) {
            FieldBreakpoint.$$$reportNull$$$0(4);
        }
        super.readExternal(breakpointNode);
        this.setFieldName(breakpointNode.getAttributeValue("field_name"));
        if (this.getFieldName() == null) {
            throw new InvalidDataException("No field name for field breakpoint");
        }
        try {
            ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_MODIFICATION = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_MODIFICATION"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_ACCESS = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_ACCESS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    private boolean isWatchModification() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_MODIFICATION;
    }

    private boolean isWatchAccess() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_ACCESS;
    }

    void setFieldName(String fieldName) {
        ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myFieldName = fieldName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/ui/breakpoints/FieldBreakpoint";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createRequestForPreparedClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

