/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointPropertiesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class JavaMethodBreakpointType
extends JavaLineBreakpointTypeBase<JavaMethodBreakpointProperties> {
    public JavaMethodBreakpointType(@NotNull String id, @Nls @NotNull String message) {
        if (id == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(0);
        }
        if (message == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(1);
        }
        super(id, message);
    }

    public JavaMethodBreakpointType() {
        this("java-method", JavaDebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]));
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        Icon icon = AllIcons.Debugger.Db_no_suspend_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(6);
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_method_breakpoint;
        if (icon == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(7);
        }
        return icon;
    }

    protected String getHelpID() {
        return "debugging.methodBreakpoint";
    }

    public String getDisplayName() {
        return JavaDebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]);
    }

    @Nls
    @NotNull
    protected String getGeneralDescription(XLineBreakpointType.XLineBreakpointVariant variant) {
        String string = JavaDebuggerBundle.message((String)"method.breakpoint.description", (Object[])new Object[0]);
        if (string == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nls
    public String getGeneralDescription(XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        return JavaDebuggerBundle.message((String)"method.breakpoint.description", (Object[])new Object[0]);
    }

    @Override
    public List<@Nls String> getPropertyXMLDescriptions(XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        SmartList res = new SmartList(super.getPropertyXMLDescriptions(breakpoint));
        JavaMethodBreakpointProperties props = (JavaMethodBreakpointProperties)breakpoint.getProperties();
        if (props != null) {
            JavaMethodBreakpointProperties defaults = this.createProperties();
            if (props.EMULATED != defaults.EMULATED) {
                res.add((Object)(JavaDebuggerBundle.message((String)"method.breakpoint.property.name.emulated", (Object[])new Object[0]) + "&nbsp;" + props.EMULATED));
            }
            if (props.WATCH_ENTRY != defaults.WATCH_ENTRY || props.WATCH_EXIT != defaults.WATCH_EXIT) {
                res.add((Object)(JavaDebuggerBundle.message((String)"method.breakpoint.property.name.watch.entry", (Object[])new Object[0]) + "&nbsp;" + props.WATCH_ENTRY));
                res.add((Object)(JavaDebuggerBundle.message((String)"method.breakpoint.property.name.watch.exit", (Object[])new Object[0]) + "&nbsp;" + props.WATCH_EXIT));
            }
        }
        return res;
    }

    public String getShortText(XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        return JavaMethodBreakpointType.getText(breakpoint);
    }

    @Nls
    static String getText(XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        boolean classNameExists;
        StringBuilder buffer = new StringBuilder();
        String className = ((JavaMethodBreakpointProperties)breakpoint.getProperties()).myClassPattern;
        boolean bl = classNameExists = className != null && !className.isEmpty();
        if (classNameExists) {
            buffer.append(className);
        }
        if (((JavaMethodBreakpointProperties)breakpoint.getProperties()).myMethodName != null) {
            if (classNameExists) {
                buffer.append(".");
            }
            buffer.append(((JavaMethodBreakpointProperties)breakpoint.getProperties()).myMethodName);
        }
        return buffer.toString();
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel createCustomPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(9);
        }
        return new MethodBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaMethodBreakpointProperties createProperties() {
        JavaMethodBreakpointProperties properties = new JavaMethodBreakpointProperties();
        if (Registry.is((String)"debugger.emulate.method.breakpoints")) {
            properties.EMULATED = true;
        }
        if (Registry.is((String)"debugger.method.breakpoints.entry.default")) {
            properties.WATCH_EXIT = false;
        }
        return properties;
    }

    @Nullable
    public JavaMethodBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(10);
        }
        return this.createProperties();
    }

    @Override
    @NotNull
    public Breakpoint<JavaMethodBreakpointProperties> createJavaBreakpoint(Project project, XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        return new MethodBreakpoint(project, (XBreakpoint)breakpoint);
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(11);
        }
        if (project == null) {
            JavaMethodBreakpointType.$$$reportNull$$$0(12);
        }
        return JavaMethodBreakpointType.canPutAtElement(file, line, project, (element, document) -> element instanceof PsiMethod);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/JavaMethodBreakpointType";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/JavaMethodBreakpointType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendNoneIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedEnabledIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedDisabledIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneralDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCustomPropertiesPanel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

