/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class MethodBreakpoint
extends BreakpointWithHighlighter<JavaMethodBreakpointProperties>
implements MethodBreakpointBase {
    private static final Logger LOG = Logger.getInstance(MethodBreakpoint.class);
    @Nullable
    protected JVMName mySignature;
    @NonNls
    public static final Key<MethodBreakpoint> CATEGORY = BreakpointCategory.lookup("method_breakpoints");

    protected MethodBreakpoint(@NotNull Project project, XBreakpoint breakpoint) {
        if (project == null) {
            MethodBreakpoint.$$$reportNull$$$0(0);
        }
        super(project, breakpoint);
    }

    @Override
    @NotNull
    public Key<MethodBreakpoint> getCategory() {
        Key<MethodBreakpoint> key = CATEGORY;
        if (key == null) {
            MethodBreakpoint.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getMethodName() != null;
    }

    @Override
    @RequiresBackgroundThread
    public void reload() {
        String classPattern;
        MethodDescriptor descriptor;
        ThreadingAssertions.assertBackgroundThread();
        super.reload();
        this.setMethodName(null);
        this.mySignature = null;
        SourcePosition sourcePosition = this.getSourcePosition();
        if (sourcePosition != null && (descriptor = this.computeMethodDescriptor(sourcePosition)) != null) {
            this.setMethodName(descriptor.methodName);
            this.mySignature = descriptor.methodSignature;
            if (descriptor.isStatic) {
                this.setInstanceFiltersEnabled(false);
            }
        }
        if ((classPattern = this.computeClassPattern()) != null) {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern = classPattern;
        }
    }

    @Nullable
    protected String computeClassPattern() {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            return null;
        }
        return psiClass.getQualifiedName();
    }

    @Nullable
    protected MethodDescriptor computeMethodDescriptor(@NotNull SourcePosition sourcePosition) {
        if (sourcePosition == null) {
            MethodBreakpoint.$$$reportNull$$$0(2);
        }
        return MethodBreakpoint.getMethodDescriptor(this.myProject, sourcePosition);
    }

    private static void createRequestForSubClasses(final @NotNull MethodBreakpointBase breakpoint, @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType baseType) {
        if (breakpoint == null) {
            MethodBreakpoint.$$$reportNull$$$0(3);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(4);
        }
        if (baseType == null) {
            MethodBreakpoint.$$$reportNull$$$0(5);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
        ClassPrepareRequest request = requestsManager.createClassPrepareRequest((debuggerProcess, referenceType) -> {
            if (DebuggerUtilsImpl.instanceOf(referenceType, baseType)) {
                MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, referenceType, false);
            }
        }, null);
        if (request != null) {
            requestsManager.registerRequest(breakpoint, request);
            request.enable();
        }
        final ProgressWindow indicator = new ProgressWindow(true, false, debugProcess.getProject(), JavaDebuggerBundle.message((String)"cancel.emulation", (Object[])new Object[0]));
        indicator.setDelayInMillis(2000);
        final AtomicBoolean changed = new AtomicBoolean();
        XBreakpointListener listener2 = new XBreakpointListener<XBreakpoint<?>>(){

            void changed(@NotNull XBreakpoint b) {
                if (b == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (b == breakpoint.getXBreakpoint()) {
                    changed.set(true);
                    indicator.cancel();
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint b) {
                if (b == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.changed(b);
            }

            public void breakpointChanged(@NotNull XBreakpoint b) {
                if (b == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.changed(b);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "b";
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "changed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        debugProcess.getProject().getMessageBus().connect((Disposable)indicator).subscribe(XBreakpointListener.TOPIC, (Object)listener2);
        try {
            ProgressManager.getInstance().executeProcessUnderProgress(() -> MethodBreakpoint.processPreparedSubTypes(baseType, (subType, classesByName) -> MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, subType, classesByName, false), (ProgressIndicator)indicator), (ProgressIndicator)indicator);
            if (indicator.isCanceled() && !changed.get()) {
                breakpoint.disableEmulation();
            }
        }
        catch (ProcessCanceledException e) {
            breakpoint.disableEmulation();
        }
    }

    @Override
    public void disableEmulation() {
        MethodBreakpointBase.disableEmulation(this);
    }

    static void createRequestForPreparedClassEmulated(@NotNull MethodBreakpointBase breakpoint, @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType, boolean base) {
        if (breakpoint == null) {
            MethodBreakpoint.$$$reportNull$$$0(6);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(7);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(8);
        }
        MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, classType, classType.virtualMachine()::classesByName, base);
    }

    static void createRequestForPreparedClassEmulated(final @NotNull MethodBreakpointBase breakpoint, final @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType, @NotNull ClassesByNameProvider classesByName, boolean base) {
        if (breakpoint == null) {
            MethodBreakpoint.$$$reportNull$$$0(9);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(10);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(11);
        }
        if (classesByName == null) {
            MethodBreakpoint.$$$reportNull$$$0(12);
        }
        if (breakpoint.isWatchExit() && !MethodBreakpointBase.canBeWatchExitEmulated(classType.virtualMachine())) {
            breakpoint.disableEmulation();
            return;
        }
        if (!base && !MethodBreakpoint.shouldCreateRequest(breakpoint, breakpoint.getXBreakpoint(), debugProcess, true)) {
            return;
        }
        Method lambdaMethod = MethodBytecodeUtil.getLambdaMethod(classType, classesByName);
        if (lambdaMethod != null && breakpoint.matchingMethods((StreamEx<Method>)StreamEx.of(((ClassType)classType).interfaces()).flatCollection(ReferenceType::allMethods), debugProcess).findFirst().isEmpty()) {
            return;
        }
        StreamEx<Method> methods = lambdaMethod != null ? StreamEx.of((Object)lambdaMethod) : breakpoint.matchingMethods((StreamEx<Method>)((StreamEx)StreamEx.of(classType.methods()).filter(m -> base || !m.isAbstract())), debugProcess);
        boolean scanSubClasses = false;
        for (Method original : methods) {
            Method method;
            Method bridgeTarget = MethodBytecodeUtil.getBridgeTargetMethod(original, classesByName);
            Method method2 = method = bridgeTarget != null ? bridgeTarget : original;
            if (method.isNative()) {
                LOG.info("Breakpoint emulation was disabled because " + String.valueOf(method) + " is native");
                breakpoint.disableEmulation();
                return;
            }
            if (!(method.isStatic() || method.isPrivate() || method.isFinal())) {
                scanSubClasses = true;
            }
            if (method.isAbstract()) {
                scanSubClasses = true;
                continue;
            }
            if (breakpoint.isWatchEntry()) {
                LocationCodeIndexOnly location = new LocationCodeIndexOnly(method, 0L);
                MethodBreakpoint.createLocationBreakpointRequest(breakpoint, location, debugProcess, true);
            }
            if (!breakpoint.isWatchExit()) continue;
            class BytecodeVisitor
            extends MethodVisitor
            implements MethodBytecodeUtil.InstructionOffsetReader {
                private int bytecodeOffset;

                BytecodeVisitor() {
                    super(589824);
                    this.bytecodeOffset = -1;
                }

                @Override
                public void readBytecodeInstructionOffset(int offset) {
                    this.bytecodeOffset = offset;
                }

                public void visitInsn(int opcode) {
                    if (172 <= opcode && opcode <= 177) {
                        assert (this.bytecodeOffset >= 0);
                        LocationCodeIndexOnly location = new LocationCodeIndexOnly(method, this.bytecodeOffset);
                        MethodBreakpoint.createLocationBreakpointRequest(breakpoint, location, debugProcess, false);
                    }
                }
            }
            MethodBytecodeUtil.visit(method, new BytecodeVisitor(), false);
        }
        if (base && scanSubClasses) {
            MethodBreakpoint.createRequestForSubClasses(breakpoint, debugProcess, classType);
        }
    }

    private static void createLocationBreakpointRequest(@NotNull FilteredRequestor requestor2, @Nullable Location location, @NotNull DebugProcessImpl debugProcess, boolean methodEntry) {
        BreakpointRequest request;
        if (requestor2 == null) {
            MethodBreakpoint.$$$reportNull$$$0(13);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(14);
        }
        if ((request = MethodBreakpoint.createLocationBreakpointRequest(requestor2, location, debugProcess)) != null) {
            request.putProperty("METHOD_ENTRY_KEY", methodEntry);
        }
    }

    @Override
    protected void createRequestForPreparedClass(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(15);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(16);
        }
        if (this.isEmulated()) {
            MethodBreakpoint.createRequestForPreparedClassEmulated(this, debugProcess, classType, true);
        } else {
            this.createRequestForPreparedClassOriginal(debugProcess, classType);
        }
    }

    protected boolean isMethodMatch(@NotNull Method method, @NotNull DebugProcessImpl debugProcess) {
        if (method == null) {
            MethodBreakpoint.$$$reportNull$$$0(17);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(18);
        }
        try {
            String name = this.getMethodName();
            return name != null && name.equals(method.name()) && this.mySignature != null && this.mySignature.getName(debugProcess).equals(method.signature());
        }
        catch (EvaluateException e) {
            LOG.debug("Should not happen. mySignature is a JVMRawText and it doesn't throw", (Throwable)e);
            return false;
        }
    }

    private void createRequestForPreparedClassOriginal(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(19);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(20);
        }
        boolean hasMethod = false;
        for (Method method : classType.allMethods()) {
            if (!this.isMethodMatch(method, debugProcess)) continue;
            hasMethod = true;
            break;
        }
        if (!hasMethod) {
            debugProcess.getRequestsManager().setInvalid(this, JavaDebuggerBundle.message((String)"error.invalid.breakpoint.method.not.found", (Object[])new Object[]{classType.name()}));
            return;
        }
        RequestManagerImpl requestManager = debugProcess.getRequestsManager();
        if (this.isWatchEntry()) {
            MethodEntryRequest entryRequest = MethodBreakpoint.findRequest(debugProcess, MethodEntryRequest.class, this);
            if (entryRequest == null) {
                entryRequest = requestManager.createMethodEntryRequest(this);
            } else {
                entryRequest.disable();
            }
            entryRequest.addClassFilter(classType);
            debugProcess.getRequestsManager().enableRequest(entryRequest);
        }
        if (this.isWatchExit()) {
            MethodExitRequest exitRequest = MethodBreakpoint.findRequest(debugProcess, MethodExitRequest.class, this);
            if (exitRequest == null) {
                exitRequest = requestManager.createMethodExitRequest(this);
            } else {
                exitRequest.disable();
            }
            exitRequest.addClassFilter(classType);
            debugProcess.getRequestsManager().enableRequest(exitRequest);
        }
    }

    @Override
    public String getEventMessage(@NotNull LocatableEvent event) {
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(21);
        }
        return MethodBreakpoint.getEventMessage(event, this.getFileName());
    }

    @Nls
    static String getEventMessage(@NotNull LocatableEvent event, @NotNull String defaultFileName) {
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(22);
        }
        if (defaultFileName == null) {
            MethodBreakpoint.$$$reportNull$$$0(23);
        }
        Location location = event.location();
        if (event instanceof MethodEntryEvent) {
            return MethodBreakpoint.getEventMessage(true, ((MethodEntryEvent)event).method(), location, defaultFileName);
        }
        if (event instanceof MethodExitEvent) {
            return MethodBreakpoint.getEventMessage(false, ((MethodExitEvent)event).method(), location, defaultFileName);
        }
        Object entryProperty = event.request().getProperty("METHOD_ENTRY_KEY");
        if (entryProperty instanceof Boolean) {
            return MethodBreakpoint.getEventMessage((Boolean)entryProperty, location.method(), location, defaultFileName);
        }
        return "";
    }

    @Nls
    private static String getEventMessage(boolean entry, Method method, Location location, @NotNull String defaultFileName) {
        if (defaultFileName == null) {
            MethodBreakpoint.$$$reportNull$$$0(24);
        }
        String locationQName = DebuggerUtilsEx.getLocationMethodQName(location);
        String locationFileName = DebuggerUtilsEx.getSourceName(location, defaultFileName);
        int locationLine = location.lineNumber();
        return JavaDebuggerBundle.message((String)(entry ? "status.method.entry.breakpoint.reached" : "status.method.exit.breakpoint.reached"), (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) != null && isMuted) {
            return AllIcons.Debugger.Db_muted_dep_method_breakpoint;
        }
        return null;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return this.isSuspend() ? AllIcons.Debugger.Db_verified_method_breakpoint : AllIcons.Debugger.Db_verified_no_suspend_method_breakpoint;
    }

    @Override
    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        LayeredIcon layeredIcon = LayeredIcon.layeredIcon((Icon[])new Icon[]{isMuted ? AllIcons.Debugger.Db_muted_method_breakpoint : AllIcons.Debugger.Db_method_breakpoint, AllIcons.General.WarningDecorator});
        if (layeredIcon == null) {
            MethodBreakpoint.$$$reportNull$$$0(25);
        }
        return layeredIcon;
    }

    @Override
    public String getDisplayName() {
        @Nls StringBuilder buffer = new StringBuilder();
        if (this.isValid()) {
            boolean classNameExists;
            String className = this.getClassName();
            boolean bl = classNameExists = className != null && !className.isEmpty();
            if (classNameExists) {
                buffer.append(className);
            }
            if (this.getMethodName() != null) {
                if (classNameExists) {
                    buffer.append(".");
                }
                buffer.append(this.getMethodName());
            }
        } else {
            buffer.append(JavaDebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]));
        }
        return buffer.toString();
    }

    @Override
    public boolean evaluateCondition(@NotNull EvaluationContextImpl context, @NotNull LocatableEvent event) throws EvaluateException {
        if (context == null) {
            MethodBreakpoint.$$$reportNull$$$0(26);
        }
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(27);
        }
        if (!this.matchesEvent(event, context.getDebugProcess())) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    public boolean matchesEvent(@NotNull LocatableEvent event, DebugProcessImpl process) {
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(28);
        }
        if (this.isEmulated()) {
            return true;
        }
        if (this.getMethodName() == null || this.mySignature == null) {
            return false;
        }
        Method method = event.location().method();
        return this.isMethodMatch(method, process);
    }

    @Nullable
    public static MethodBreakpoint create(@NotNull Project project, XBreakpoint xBreakpoint) {
        if (project == null) {
            MethodBreakpoint.$$$reportNull$$$0(29);
        }
        MethodBreakpoint breakpoint = new MethodBreakpoint(project, xBreakpoint);
        return (MethodBreakpoint)breakpoint.init();
    }

    @Nullable
    private static MethodDescriptor getMethodDescriptor(@NotNull Project project, @NotNull SourcePosition sourcePosition) {
        Document document;
        if (project == null) {
            MethodBreakpoint.$$$reportNull$$$0(30);
        }
        if (sourcePosition == null) {
            MethodBreakpoint.$$$reportNull$$$0(31);
        }
        if ((document = sourcePosition.getFile().getViewProvider().getDocument()) == null) {
            return null;
        }
        MethodDescriptor descriptor = (MethodDescriptor)ReadAction.compute(() -> {
            PsiMethod method = PositionUtil.getPsiElementAt(project, PsiMethod.class, sourcePosition);
            if (method == null) {
                return null;
            }
            return MethodBreakpoint.getMethodDescriptor(sourcePosition, method, document);
        });
        if (descriptor == null || descriptor.methodName == null || descriptor.methodSignature == null) {
            return null;
        }
        return descriptor;
    }

    @ApiStatus.Internal
    @Nullable
    public static MethodDescriptor getMethodDescriptor(@NotNull SourcePosition sourcePosition, @NotNull PsiMethod method, @NotNull Document document) {
        int methodOffset;
        if (sourcePosition == null) {
            MethodBreakpoint.$$$reportNull$$$0(32);
        }
        if (method == null) {
            MethodBreakpoint.$$$reportNull$$$0(33);
        }
        if (document == null) {
            MethodBreakpoint.$$$reportNull$$$0(34);
        }
        if (!DocumentUtil.isValidOffset((int)(methodOffset = method.getTextOffset()), (Document)document) || document.getLineNumber(methodOffset) < sourcePosition.getLine()) {
            return null;
        }
        PsiIdentifier identifier = method.getNameIdentifier();
        int methodNameOffset = identifier != null ? identifier.getTextOffset() : methodOffset;
        MethodDescriptor res = new MethodDescriptor();
        res.methodName = JVMNameUtil.getJVMMethodName(method);
        try {
            res.methodSignature = JVMNameUtil.getJVMSignature(method);
            res.isStatic = method.hasModifierProperty("static");
        }
        catch (IndexNotReadyException ignored) {
            return null;
        }
        res.methodLine = document.getLineNumber(methodNameOffset);
        return res;
    }

    @Nullable
    static <T extends EventRequest> T findRequest(@NotNull DebugProcessImpl debugProcess, Class<T> requestClass, Requestor requestor2) {
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(35);
        }
        return (T)((EventRequest)StreamEx.of(debugProcess.getRequestsManager().findRequests(requestor2)).select(requestClass).findFirst().orElse(null));
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        if (breakpointNode == null) {
            MethodBreakpoint.$$$reportNull$$$0(36);
        }
        super.readExternal(breakpointNode);
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEmulated() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).EMULATED;
    }

    @Override
    public boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY;
    }

    @Override
    public boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT;
    }

    @Override
    public StreamEx<Method> matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        try {
            String methodName = this.getMethodName();
            String signature = this.mySignature != null ? this.mySignature.getName(debugProcess) : null;
            return (StreamEx)((StreamEx)methods.filter(m -> Objects.equals(methodName, m.name()) && Objects.equals(signature, m.signature()))).limit(1L);
        }
        catch (EvaluateException e) {
            LOG.warn((Throwable)e);
            return StreamEx.empty();
        }
    }

    @Nullable
    protected String getMethodName() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName;
    }

    protected void setMethodName(@Nullable String methodName) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName = methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPreparedSubTypes(ReferenceType classType, BiConsumer<? super ReferenceType, ? super ClassesByNameProvider> consumer, ProgressIndicator progressIndicator) {
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        progressIndicator.setIndeterminate(false);
        progressIndicator.start();
        progressIndicator.setText(JavaDebuggerBundle.message((String)"label.method.breakpoints.processing.classes", (Object[])new Object[0]));
        try {
            MultiMap inheritance = MultiMap.createConcurrentSet();
            List<ReferenceType> allTypes = classType.virtualMachine().allClasses();
            int allSize = allTypes.size();
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            AtomicInteger processed = new AtomicInteger();
            for (ReferenceType type : allTypes) {
                progressIndicator.checkCanceled();
                if (!type.isPrepared()) continue;
                futures.add(((CompletableFuture)((CompletableFuture)DebuggerUtilsAsync.supertypes(type).thenAccept(supertypes -> supertypes.forEach(st -> inheritance.putValue(st, (Object)type)))).exceptionally(throwable -> {
                    if ((throwable = DebuggerUtilsAsync.unwrap(throwable)) instanceof ObjectCollectedException) {
                        return null;
                    }
                    throw new CompletionException((Throwable)throwable);
                })).thenRun(() -> MethodBreakpoint.updateProgress(progressIndicator, processed.incrementAndGet(), allSize)));
            }
            ProgressIndicatorUtils.awaitWithCheckCanceled(CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])), (ProgressIndicator)progressIndicator);
            List types = ((StreamEx)StreamEx.ofTree((Object)classType, t -> StreamEx.of((Collection)inheritance.get(t))).skip(1L)).toList();
            if (LOG.isDebugEnabled()) {
                long current = System.currentTimeMillis();
                LOG.debug("Processed  " + allSize + " classes in " + (current - start) + "ms");
                start = current;
            }
            progressIndicator.setText(JavaDebuggerBundle.message((String)"label.method.breakpoints.setting.breakpoints", (Object[])new Object[0]));
            ClassesByNameProvider classesByName = ClassesByNameProvider.createCache(allTypes);
            int typesSize = types.size();
            for (int i = 0; i < typesSize; ++i) {
                progressIndicator.checkCanceled();
                consumer.accept((ReferenceType)types.get(i), classesByName);
                MethodBreakpoint.updateProgress(progressIndicator, i, typesSize);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created " + typesSize + " requests in " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        finally {
            progressIndicator.stop();
        }
    }

    private static void updateProgress(ProgressIndicator progressIndicator, int current, int total) {
        progressIndicator.setText2(current + "/" + total);
        progressIndicator.setFraction((double)current / (double)total);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint";
                break;
            }
            case 2: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesByName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 21: 
            case 22: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFileName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerifiedWarningsIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeMethodDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForSubClasses";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassEmulated";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createLocationBreakpointRequest";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isMethodMatch";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassOriginal";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getEventMessage";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCondition";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "matchesEvent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDescriptor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findRequest";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 25 -> new IllegalStateException(string);
        };
    }

    public static final class MethodDescriptor {
        public String methodName;
        public JVMName methodSignature;
        public boolean isStatic;
        public int methodLine;

        public MethodDescriptor() {
        }

        public MethodDescriptor(String methodName, final String signature, boolean isStatic, int methodLine) {
            this.methodName = methodName;
            this.methodSignature = new JVMName(){

                @Override
                public String getName(DebugProcessImpl process) throws EvaluateException {
                    return signature;
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcess) {
                    return signature;
                }
            };
            this.isStatic = isStatic;
            this.methodLine = methodLine;
        }
    }

    private static class LocationCodeIndexOnly
    implements Location {
        private final Method method;
        private final long codeIndex;

        public LocationCodeIndexOnly(Method method, long codeIndex) {
            assert (!method.isNative() && !method.isAbstract());
            assert (codeIndex >= 0L);
            this.method = method;
            this.codeIndex = codeIndex;
        }

        @Override
        public VirtualMachine virtualMachine() {
            return this.method.virtualMachine();
        }

        @Override
        public ReferenceType declaringType() {
            return this.method.declaringType();
        }

        @Override
        public Method method() {
            return this.method;
        }

        @Override
        public long codeIndex() {
            return this.codeIndex;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            LocationCodeIndexOnly that = (LocationCodeIndexOnly)other;
            return this.codeIndex == that.codeIndex && this.method.equals(that.method);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.method, this.codeIndex);
        }

        @Override
        public int compareTo(@NotNull Location that) {
            int res;
            if (that == null) {
                LocationCodeIndexOnly.$$$reportNull$$$0(0);
            }
            if ((res = this.method().compareTo(that.method())) != 0) {
                return res;
            }
            return Long.compare(this.codeIndex(), that.codeIndex());
        }

        @Override
        public int lineNumber() {
            return -1;
        }

        @Override
        public int lineNumber(String stratum) {
            return -1;
        }

        @Override
        public String sourceName() throws AbsentInformationException {
            throw new AbsentInformationException();
        }

        @Override
        public String sourceName(String stratum) throws AbsentInformationException {
            throw new AbsentInformationException();
        }

        @Override
        public String sourcePath() throws AbsentInformationException {
            throw new AbsentInformationException();
        }

        @Override
        public String sourcePath(String stratum) throws AbsentInformationException {
            throw new AbsentInformationException();
        }

        @Override
        public String toString() {
            return "LocationCodeIndexOnly{method=" + String.valueOf(this.method) + ", codeIndex=" + this.codeIndex + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$LocationCodeIndexOnly", "compareTo"));
        }
    }
}

