/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.sun.jdi.event.LocatableEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunToCursorBreakpoint
extends SyntheticLineBreakpoint
implements SteppingBreakpoint {
    private final boolean myRestoreBreakpoints;
    private final boolean myIsEngineBreakpoint;
    @NotNull
    protected final SourcePosition myCustomPosition;

    protected RunToCursorBreakpoint(@NotNull Project project, @NotNull SourcePosition pos, boolean restoreBreakpoints, boolean isEngineBreakpoint) {
        if (project == null) {
            RunToCursorBreakpoint.$$$reportNull$$$0(0);
        }
        if (pos == null) {
            RunToCursorBreakpoint.$$$reportNull$$$0(1);
        }
        super(project);
        this.myCustomPosition = pos;
        this.myRestoreBreakpoints = restoreBreakpoints;
        this.myIsEngineBreakpoint = isEngineBreakpoint;
    }

    @Override
    @NotNull
    public SourcePosition getSourcePosition() {
        SourcePosition sourcePosition = this.myCustomPosition;
        if (sourcePosition == null) {
            RunToCursorBreakpoint.$$$reportNull$$$0(2);
        }
        return sourcePosition;
    }

    @Override
    public int getLineIndex() {
        return this.myCustomPosition.getLine();
    }

    @Override
    public String getFileName() {
        return this.myCustomPosition.getFile().getName();
    }

    @Override
    @Nullable
    protected VirtualFile getVirtualFile() {
        return this.myCustomPosition.getFile().getVirtualFile();
    }

    @Override
    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        return JavaDebuggerBundle.message((String)"status.stopped.at.cursor", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    protected JavaLineBreakpointType getXBreakpointType() {
        SourcePosition position = this.getSourcePosition();
        VirtualFile file = position.getFile().getVirtualFile();
        int line = position.getLine();
        for (XLineBreakpointType type : XDebuggerUtil.getInstance().getLineBreakpointTypes()) {
            if (!(type instanceof JavaLineBreakpointType) || !type.canPutAt(file, line, this.myProject)) continue;
            return (JavaLineBreakpointType)type;
        }
        return null;
    }

    @ApiStatus.Internal
    public final boolean isEngineBreakpoint() {
        return this.myIsEngineBreakpoint;
    }

    @Nullable
    protected static RunToCursorBreakpoint create(@NotNull Project project, @NotNull XSourcePosition position, boolean restoreBreakpoints) {
        PsiFile psiFile;
        if (project == null) {
            RunToCursorBreakpoint.$$$reportNull$$$0(3);
        }
        if (position == null) {
            RunToCursorBreakpoint.$$$reportNull$$$0(4);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(position.getFile())) == null) {
            return null;
        }
        return new RunToCursorBreakpoint(project, SourcePosition.createFromOffset((PsiFile)psiFile, (int)position.getOffset()), restoreBreakpoints, false);
    }

    @Override
    public void setRequestHint(RequestHint hint) {
    }

    @Override
    public boolean track() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcePosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

