/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.MethodReturnValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThrownExceptionValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.UserExpressionDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.IconManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerTreeRenderer
extends ColoredTreeCellRenderer {
    private static final SimpleTextAttributes DEFAULT_ATTRIBUTES = new SimpleTextAttributes(0, null);
    private static final SimpleTextAttributes SPECIAL_NODE_ATTRIBUTES = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));
    private static final SimpleTextAttributes OBJECT_ID_HIGHLIGHT_ATTRIBUTES = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DebuggerTreeNodeImpl node;
        if (tree == null) {
            DebuggerTreeRenderer.$$$reportNull$$$0(0);
        }
        if ((node = (DebuggerTreeNodeImpl)value) != null) {
            SimpleColoredText text = node.getText();
            if (text != null) {
                text.appendToComponent((ColoredTextContainer)this);
            }
            this.setIcon(node.getIcon());
        }
    }

    @Nullable
    public static Icon getDescriptorIcon(NodeDescriptor descriptor) {
        if (descriptor instanceof ThreadGroupDescriptorImpl) {
            ThreadGroupDescriptorImpl threadGroupDescriptor = (ThreadGroupDescriptorImpl)descriptor;
            return threadGroupDescriptor.isCurrent() ? AllIcons.Debugger.ThreadGroupCurrent : AllIcons.Debugger.ThreadGroup;
        }
        if (descriptor instanceof ThreadDescriptorImpl) {
            ThreadDescriptorImpl threadDescriptor = (ThreadDescriptorImpl)descriptor;
            return threadDescriptor.getIcon();
        }
        if (descriptor instanceof StackFrameDescriptorImpl) {
            StackFrameDescriptorImpl stackDescriptor = (StackFrameDescriptorImpl)descriptor;
            return stackDescriptor.getIcon();
        }
        if (descriptor instanceof ValueDescriptorImpl) {
            ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
            return DebuggerTreeRenderer.getValueIcon(valueDescriptor, null);
        }
        if (descriptor instanceof MessageDescriptor) {
            MessageDescriptor messageDescriptor = (MessageDescriptor)descriptor;
            return switch (messageDescriptor.getKind()) {
                case 0 -> XDebuggerUIConstants.ERROR_MESSAGE_ICON;
                case 2 -> XDebuggerUIConstants.INFORMATION_MESSAGE_ICON;
                default -> null;
            };
        }
        if (descriptor instanceof StaticDescriptorImpl) {
            return AllIcons.Nodes.Static;
        }
        return null;
    }

    public static Icon getValueIcon(ValueDescriptorImpl valueDescriptor, @Nullable ValueDescriptorImpl parentDescriptor) {
        Icon valueIcon;
        EnumerationChildrenRenderer enumerationChildrenRenderer;
        Icon nodeIcon;
        if (valueDescriptor instanceof WatchItemDescriptor) {
            nodeIcon = AllIcons.Debugger.Db_watch;
        } else if (valueDescriptor instanceof FieldDescriptorImpl) {
            Value value;
            FieldDescriptorImpl fieldDescriptor = (FieldDescriptorImpl)valueDescriptor;
            nodeIcon = IconManager.getInstance().getPlatformIcon(PlatformIcons.Field);
            if (parentDescriptor != null && (value = valueDescriptor.getValue()) instanceof ObjectReference && value.equals(parentDescriptor.getValue())) {
                nodeIcon = AllIcons.Debugger.Selfreference;
            }
            if (fieldDescriptor.getField().isFinal()) {
                nodeIcon = LayeredIcon.layeredIcon((Icon[])new Icon[]{nodeIcon, IconManager.getInstance().getPlatformIcon(PlatformIcons.FinalMark)});
            }
            if (fieldDescriptor.isStatic()) {
                nodeIcon = LayeredIcon.layeredIcon((Icon[])new Icon[]{nodeIcon, IconManager.getInstance().getPlatformIcon(PlatformIcons.StaticMark)});
            }
        } else {
            nodeIcon = valueDescriptor instanceof ThrownExceptionValueDescriptorImpl ? AllIcons.Nodes.ExceptionClass : (valueDescriptor instanceof MethodReturnValueDescriptorImpl ? AllIcons.Debugger.WatchLastReturnValue : (DebuggerTreeRenderer.isParameter(valueDescriptor) ? IconManager.getInstance().getPlatformIcon(PlatformIcons.Parameter) : (valueDescriptor.isEnumConstant() ? com.intellij.util.PlatformIcons.ENUM_ICON : (valueDescriptor.isArray() ? AllIcons.Debugger.Db_array : (valueDescriptor.isPrimitive() ? AllIcons.Debugger.Db_primitive : AllIcons.Debugger.Value)))));
        }
        if (valueDescriptor instanceof UserExpressionDescriptorImpl && (enumerationChildrenRenderer = EnumerationChildrenRenderer.getCurrent(((UserExpressionDescriptorImpl)valueDescriptor).getParentDescriptor())) != null && enumerationChildrenRenderer.isAppendDefaultChildren()) {
            nodeIcon = AllIcons.Debugger.Db_watch;
        }
        if ((valueIcon = valueDescriptor.getValueIcon()) != null) {
            nodeIcon = nodeIcon == AllIcons.Debugger.Db_watch ? IconManager.getInstance().createRowIcon(new Icon[]{nodeIcon, valueIcon}) : valueIcon;
        }
        return nodeIcon;
    }

    private static boolean isParameter(ValueDescriptorImpl valueDescriptor) {
        if (valueDescriptor instanceof LocalVariableDescriptorImpl) {
            return ((LocalVariableDescriptorImpl)valueDescriptor).isParameter();
        }
        if (valueDescriptor instanceof ArgumentValueDescriptorImpl) {
            return ((ArgumentValueDescriptorImpl)valueDescriptor).isParameter();
        }
        return false;
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor, EditorColorsScheme colorsScheme, boolean multiline) {
        return DebuggerTreeRenderer.getDescriptorText(descriptor, colorsScheme, multiline, true);
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor, boolean multiline) {
        return DebuggerTreeRenderer.getDescriptorText(descriptor, DebuggerUIUtil.getColorScheme(null), multiline, true);
    }

    public static SimpleColoredText getDescriptorTitle(DebuggerContextImpl debuggerContext, NodeDescriptorImpl descriptor) {
        return DebuggerTreeRenderer.getDescriptorText(descriptor, DebuggerUIUtil.getColorScheme(null), false, false);
    }

    private static SimpleColoredText getDescriptorText(NodeDescriptorImpl descriptor, EditorColorsScheme colorScheme, boolean multiline, boolean appendValue) {
        String nodeName;
        String text;
        SimpleColoredText descriptorText = new SimpleColoredText();
        if (descriptor == null) {
            text = "";
            nodeName = null;
        } else {
            text = descriptor.getLabel();
            nodeName = descriptor.getName();
        }
        if (text.equals(XDebuggerUIConstants.getCollectingDataMessage())) {
            descriptorText.append(XDebuggerUIConstants.getCollectingDataMessage(), XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
            return descriptorText;
        }
        String[] strings = DebuggerTreeRenderer.breakString(text, nodeName);
        if (strings[0] != null) {
            if (descriptor instanceof MessageDescriptor && ((MessageDescriptor)descriptor).getKind() == 3) {
                descriptorText.append(strings[0], SPECIAL_NODE_ATTRIBUTES);
            } else {
                descriptorText.append(strings[0], DEFAULT_ATTRIBUTES);
            }
        }
        if (strings[1] != null) {
            descriptorText.append(strings[1], XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        }
        if (strings[2] != null) {
            if (descriptor instanceof ValueDescriptorImpl) {
                String valueLabel;
                ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
                if (multiline && strings[2].indexOf(10) >= 0 && (strings = DebuggerTreeRenderer.breakString(strings[2], "="))[2] != null) {
                    strings[2] = strings[0] + strings[1] + "\n" + strings[2];
                }
                if ((strings = DebuggerTreeRenderer.breakString(strings[2], valueLabel = valueDescriptor.getValueLabel()))[0] != null) {
                    descriptorText.append(strings[0], DEFAULT_ATTRIBUTES);
                }
                if (appendValue && strings[1] != null) {
                    SimpleTextAttributes valueLabelAttribs;
                    if (valueLabel != null && StringUtil.startsWithChar((CharSequence)valueLabel, (char)'{') && valueLabel.indexOf(125) > 0 && !StringUtil.endsWithChar((CharSequence)valueLabel, (char)'}')) {
                        int idx = valueLabel.indexOf(125);
                        String objectId = valueLabel.substring(0, idx + 1);
                        valueLabel = valueLabel.substring(idx + 1);
                        descriptorText.append(objectId, OBJECT_ID_HIGHLIGHT_ATTRIBUTES);
                    }
                    valueLabel = DebuggerUtilsEx.truncateString(valueLabel);
                    if (valueDescriptor.isDirty()) {
                        valueLabelAttribs = XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES;
                    } else {
                        TextAttributes attributes = null;
                        if (valueDescriptor.isNull()) {
                            attributes = colorScheme.getAttributes(JavaHighlightingColors.KEYWORD);
                        } else if (valueDescriptor.isString()) {
                            attributes = colorScheme.getAttributes(JavaHighlightingColors.STRING);
                        }
                        valueLabelAttribs = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : DEFAULT_ATTRIBUTES;
                    }
                    EvaluateException exception = descriptor.getEvaluateException();
                    if (exception != null) {
                        String errorMessage = exception.getMessage();
                        String valueText = valueLabel.endsWith(errorMessage) ? valueLabel.substring(0, valueLabel.length() - errorMessage.length()) : valueLabel;
                        DebuggerTreeRenderer.appendValueTextWithEscapesRendering(descriptorText, valueText, valueLabelAttribs, colorScheme);
                        descriptorText.append(errorMessage, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                    } else if (valueLabel.equals(XDebuggerUIConstants.getCollectingDataMessage())) {
                        descriptorText.append(XDebuggerUIConstants.getCollectingDataMessage(), XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
                    } else {
                        DebuggerTreeRenderer.appendValueTextWithEscapesRendering(descriptorText, valueLabel, valueLabelAttribs, colorScheme);
                    }
                }
            } else {
                descriptorText.append(strings[2], DEFAULT_ATTRIBUTES);
            }
        }
        return descriptorText;
    }

    private static void appendValueTextWithEscapesRendering(SimpleColoredText descriptorText, String valueText, SimpleTextAttributes attribs, EditorColorsScheme colorScheme) {
        SimpleTextAttributes escapeAttribs = null;
        @NlsSafe StringBuilder buf = new StringBuilder();
        boolean slashFound = false;
        for (int idx = 0; idx < valueText.length(); ++idx) {
            char ch = valueText.charAt(idx);
            if (slashFound) {
                slashFound = false;
                if (ch == '\\' || ch == '\"' || ch == 'b' || ch == 't' || ch == 'n' || ch == 'f' || ch == 'r') {
                    if (!buf.isEmpty()) {
                        descriptorText.append(buf.toString(), attribs);
                        buf.setLength(0);
                    }
                    if (escapeAttribs == null) {
                        TextAttributes fromHighlighter = colorScheme.getAttributes(JavaHighlightingColors.VALID_STRING_ESCAPE);
                        escapeAttribs = fromHighlighter != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)fromHighlighter) : DEFAULT_ATTRIBUTES.derive(1, (Color)JBColor.GRAY, null, null);
                    }
                    if (ch != '\\' && ch != '\"') {
                        descriptorText.append("\\", escapeAttribs);
                    }
                    descriptorText.append(String.valueOf(ch), escapeAttribs);
                    continue;
                }
                buf.append('\\').append(ch);
                continue;
            }
            if (ch == '\\') {
                slashFound = true;
                continue;
            }
            buf.append(ch);
        }
        if (!buf.isEmpty()) {
            descriptorText.append(buf.toString(), attribs);
        }
    }

    private static String[] breakString(String source, String substr) {
        if (substr != null && !substr.isEmpty()) {
            int index = Math.max(source.indexOf(substr), 0);
            String prefix = index > 0 ? source.substring(0, index) : null;
            String suffix = (index += substr.length()) < source.length() - 1 ? source.substring(index) : null;
            return new String[]{prefix, substr, suffix};
        }
        return new String[]{source, null, null};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/debugger/ui/impl/DebuggerTreeRenderer", "customizeCellRenderer"));
    }
}

