/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.extractMethodObject.LightMethodObjectExtractedData;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Value;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public abstract class CompilingEvaluator
implements ExpressionEvaluator {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final PsiElement myPsiContext;
    @NotNull
    protected final LightMethodObjectExtractedData myData;
    private static final String GEN_CLASS_NAME = "GeneratedEvaluationClass";

    public CompilingEvaluator(@NotNull Project project, @NotNull PsiElement context, @NotNull LightMethodObjectExtractedData data) {
        if (project == null) {
            CompilingEvaluator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CompilingEvaluator.$$$reportNull$$$0(1);
        }
        if (data == null) {
            CompilingEvaluator.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myPsiContext = context;
        this.myData = data;
    }

    @ApiStatus.Internal
    @NotNull
    public LightMethodObjectExtractedData getLightMethodObjectExtractedData() {
        LightMethodObjectExtractedData lightMethodObjectExtractedData = this.myData;
        if (lightMethodObjectExtractedData == null) {
            CompilingEvaluator.$$$reportNull$$$0(3);
        }
        return lightMethodObjectExtractedData;
    }

    public Modifier getModifier() {
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public TextWithImports getCallCode() {
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, this.myData.getGeneratedCallText());
    }

    public Value evaluate(EvaluationContext evaluationContext) throws EvaluateException {
        DebugProcess process = evaluationContext.getDebugProcess();
        EvaluationContextImpl autoLoadContext = ((EvaluationContextImpl)evaluationContext).withAutoLoadClasses(true);
        ClassLoaderReference classLoader = ClassLoadingUtils.getClassLoader(autoLoadContext, process);
        autoLoadContext.setClassLoader(classLoader);
        JavaSdkVersion version = JavaSdkVersion.fromVersionString((String)autoLoadContext.getVirtualMachineProxy().version());
        Collection<ClassObject> classes = this.compile(version);
        this.defineClasses(classes, autoLoadContext, process, classLoader);
        try {
            ExpressionEvaluator evaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, new EvaluatingComputable<ExpressionEvaluator>(){

                @Override
                public ExpressionEvaluator compute() throws EvaluateException {
                    TextWithImports callCode = CompilingEvaluator.this.getCallCode();
                    PsiElement copyContext = CompilingEvaluator.this.myData.getAnchor();
                    CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(callCode, copyContext);
                    return factory.getEvaluatorBuilder().build((PsiElement)factory.createPsiCodeFragment(callCode, copyContext, CompilingEvaluator.this.myProject), SourcePosition.createFromElement((PsiElement)copyContext));
                }
            });
            return evaluator.evaluate((EvaluationContext)autoLoadContext);
        }
        catch (Exception e) {
            throw new EvaluateException("Error during generated code invocation " + String.valueOf(e), (Throwable)e);
        }
    }

    private void defineClasses(Collection<ClassObject> classes, EvaluationContextImpl context, DebugProcess process, ClassLoaderReference classLoader) throws EvaluateException {
        boolean useMagicAccessorImpl = this.myData.useMagicAccessor();
        CompilingEvaluator.defineClassesForEvaluation(classes, context, process, classLoader, GEN_CLASS_NAME, useMagicAccessorImpl);
        process.findClass((EvaluationContext)context, this.getGenClassQName(), classLoader);
    }

    @ApiStatus.Internal
    public static void defineClassesForEvaluation(@NotNull Collection<ClassObject> classes, EvaluationContextImpl context, DebugProcess process, ClassLoaderReference classLoader, @NotNull String generatedClassName, boolean useMagicAccessor) throws EvaluateException {
        if (classes == null) {
            CompilingEvaluator.$$$reportNull$$$0(4);
        }
        if (generatedClassName == null) {
            CompilingEvaluator.$$$reportNull$$$0(5);
        }
        for (ClassObject cls : classes) {
            byte[] bytes;
            if (!cls.getPath().contains(generatedClassName) || (bytes = cls.getContent()) == null) continue;
            if (useMagicAccessor) {
                bytes = CompilingEvaluator.changeSuperToMagicAccessor(bytes);
            }
            ClassLoadingUtils.defineClass(cls.getClassName(), bytes, context, classLoader);
        }
    }

    private static byte[] changeSuperToMagicAccessor(byte[] bytes) {
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(589824, (ClassVisitor)classWriter){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if ("java/lang/Object".equals(superName)) {
                    superName = "sun/reflect/MagicAccessorImpl";
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }
        };
        new ClassReader(bytes).accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    @NotNull
    public static String getGeneratedClassName() {
        return GEN_CLASS_NAME;
    }

    protected String getGenClassQName() {
        return (String)ReadAction.compute(() -> JVMNameUtil.getNonAnonymousClassName(this.myData.getGeneratedInnerClass()));
    }

    @NotNull
    public abstract Collection<ClassObject> compile(@Nullable JavaSdkVersion var1) throws EvaluateException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightMethodObjectExtractedData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "defineClassesForEvaluation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

