/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluator;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.evaluate.XEvaluationOrigin;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationDescriptor
extends ValueDescriptorImpl {
    private Modifier myModifier;
    protected TextWithImports myText;
    public static final Key<ExpressionEvaluator> EXPRESSION_EVALUATOR_KEY = Key.create((String)"EXPRESSION_EVALUATOR");

    protected EvaluationDescriptor(TextWithImports text, Project project, Value value) {
        super(project, value);
        this.myText = text;
    }

    protected EvaluationDescriptor(TextWithImports text, Project project) {
        super(project);
        this.setLvalue(false);
        this.myText = text;
    }

    protected abstract EvaluationContextImpl getEvaluationContext(EvaluationContextImpl var1);

    protected abstract PsiCodeFragment getEvaluationCode(StackFrameContext var1) throws EvaluateException;

    public PsiCodeFragment createCodeFragment(PsiElement context) {
        TextWithImports text = this.getEvaluationText();
        return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text, context).createPsiCodeFragment(text, context, this.myProject);
    }

    @ApiStatus.Experimental
    @NotNull
    protected ExpressionEvaluator getEvaluator(EvaluationContextImpl evaluationContext) throws EvaluateException {
        SourcePosition position = ContextUtil.getSourcePosition((StackFrameContext)evaluationContext);
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)ReadAction.compute(() -> {
            PsiCodeFragment code = this.getEvaluationCode((StackFrameContext)evaluationContext);
            PsiElement psiContext = ContextUtil.getContextElement((StackFrameContext)evaluationContext, position);
            try {
                if (Registry.is((String)"debugger.compiling.evaluator.force")) {
                    throw new UnsupportedExpressionException("force compilation");
                }
                return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(this.getEvaluationText(), psiContext).getEvaluatorBuilder().build((PsiElement)code, position);
            }
            catch (UnsupportedExpressionException ex) {
                CompilingEvaluator eval = CompilingEvaluatorImpl.create(this.myProject, code.getContext(), element -> code);
                if (eval != null) {
                    return eval;
                }
                throw ex;
            }
        });
        if (expressionEvaluator == null) {
            EvaluationDescriptor.$$$reportNull$$$0(0);
        }
        return expressionEvaluator;
    }

    @Override
    public final Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        try {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAndRunReadAction(() -> {});
            EvaluationContextImpl thisEvaluationContext = this.getEvaluationContext(evaluationContext);
            ExpressionEvaluator evaluator = this.getEvaluator(thisEvaluationContext);
            this.putUserData(EXPRESSION_EVALUATOR_KEY, evaluator);
            if (!thisEvaluationContext.getDebugProcess().isAttached()) {
                throw EvaluateExceptionUtil.PROCESS_EXITED;
            }
            StackFrameProxyImpl frameProxy = thisEvaluationContext.getFrameProxy();
            if (frameProxy == null) {
                throw EvaluateExceptionUtil.NULL_STACK_FRAME;
            }
            XEvaluationOrigin descriptorOrigin = XEvaluationOrigin.getOrigin((UserDataHolder)this);
            Value value = descriptorOrigin != XEvaluationOrigin.UNSPECIFIED ? (Value)XEvaluationOrigin.computeWithOrigin((UserDataHolder)thisEvaluationContext, (XEvaluationOrigin)descriptorOrigin, () -> evaluator.evaluate((EvaluationContext)thisEvaluationContext)) : evaluator.evaluate((EvaluationContext)thisEvaluationContext);
            thisEvaluationContext.keep(value);
            this.myModifier = evaluator.getModifier();
            this.setLvalue(this.myModifier != null);
            return value;
        }
        catch (IndexNotReadyException ex) {
            throw new EvaluateException(JavaDebuggerBundle.message((String)"evaluation.error.during.indexing", (Object[])new Object[0]), (Throwable)ex);
        }
        catch (EvaluateException ex) {
            throw new EvaluateException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (ObjectCollectedException ex) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiCodeFragment evaluationCode = this.getEvaluationCode((StackFrameContext)context);
        if (evaluationCode instanceof PsiExpressionCodeFragment) {
            return ((PsiExpressionCodeFragment)evaluationCode).getExpression();
        }
        throw new EvaluateException(JavaDebuggerBundle.message((String)"error.cannot.create.expression.from.code.fragment", (Object[])new Object[0]), null);
    }

    @Override
    protected boolean isPrintExceptionToConsole() {
        return false;
    }

    @Nullable
    public Modifier getModifier() {
        return this.myModifier;
    }

    @Override
    public boolean canSetValue() {
        return super.canSetValue() && this.myModifier != null && this.myModifier.canSetValue();
    }

    public TextWithImports getEvaluationText() {
        return this.myText;
    }

    @Override
    public XValueModifier getModifier(JavaValue value) {
        return new JavaValueModifier(value){

            @Override
            protected void setValueImpl(@NotNull XExpression expression, @NotNull XValueModifier.XModificationCallback callback) {
                EvaluationDescriptor evaluationDescriptor;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (callback == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((evaluationDescriptor = EvaluationDescriptor.this).canSetValue()) {
                    final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(EvaluationDescriptor.this.getProject()).getContext();
                    this.set(expression, callback, debuggerContext, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            evaluationDescriptor.getModifier().setValue(1.preprocessValue(evaluationContext, newValue, this.getLType()));
                            1.update(debuggerContext);
                        }

                        @Override
                        @NotNull
                        public Type getLType() throws EvaluateException, ClassNotLoadedException {
                            Type type = evaluationDescriptor.getModifier().getExpectedType();
                            if (type == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return type;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/EvaluationDescriptor$1$1", "getLType"));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/ui/impl/watch/EvaluationDescriptor$1";
                objectArray[2] = "setValueImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/EvaluationDescriptor", "getEvaluator"));
    }
}

