/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class NodeDescriptorImpl
implements NodeDescriptor {
    protected static final Logger LOG = Logger.getInstance(NodeDescriptorImpl.class);
    public static final String UNKNOWN_VALUE_MESSAGE = "";
    public boolean myIsExpanded = false;
    public boolean myIsSelected = false;
    public boolean myIsVisible = false;
    private EvaluateException myEvaluateException;
    private @NlsContexts.Label String myLabel = "";
    private Map<Key, Object> myUserData;

    public String getName() {
        return null;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            NodeDescriptorImpl.$$$reportNull$$$0(0);
        }
        if (this.myUserData == null) {
            return null;
        }
        return (T)this.myUserData.get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            NodeDescriptorImpl.$$$reportNull$$$0(1);
        }
        if (this.myUserData == null) {
            this.myUserData = new HashMap<Key, Object>();
        }
        this.myUserData.put(key, value);
    }

    public void updateRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
        this.updateRepresentationNoNotify(context, labelListener);
        labelListener.labelChanged();
    }

    public void updateRepresentationNoNotify(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
        try {
            try {
                this.myEvaluateException = null;
                this.myLabel = this.calcRepresentation(context, labelListener);
            }
            catch (InconsistentDebugInfoException e) {
                throw new EvaluateException(JavaDebuggerBundle.message((String)"error.inconsistent.debug.info", (Object[])new Object[0]));
            }
            catch (InvalidStackFrameException e) {
                throw new EvaluateException(JavaDebuggerBundle.message((String)"error.invalid.stackframe", (Object[])new Object[0]));
            }
            catch (ObjectCollectedException e) {
                throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
            }
            catch (VMDisconnectedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof InterruptedException) {
                    throw e;
                }
                if (context != null && context.getVirtualMachineProxy().canBeModified()) {
                    LOG.debug((Throwable)e);
                } else {
                    LOG.warn((Throwable)e);
                }
                throw new EvaluateException(JavaDebuggerBundle.message((String)"internal.debugger.error", (Object[])new Object[0]));
            }
        }
        catch (EvaluateException e) {
            this.setFailed(e);
        }
    }

    @NlsContexts.Label
    protected abstract String calcRepresentation(EvaluationContextImpl var1, DescriptorLabelListener var2) throws EvaluateException;

    public void displayAs(NodeDescriptor descriptor) {
        if (descriptor instanceof NodeDescriptorImpl) {
            NodeDescriptorImpl that = (NodeDescriptorImpl)descriptor;
            this.myIsExpanded = that.myIsExpanded;
            this.myIsSelected = that.myIsSelected;
            this.myIsVisible = that.myIsVisible;
            HashMap<Key, Object> hashMap = this.myUserData = that.myUserData != null ? new HashMap<Key, Object>(that.myUserData) : null;
            if (this.myUserData != null) {
                this.myUserData.remove(OnDemandRenderer.ON_DEMAND_CALCULATED);
            }
        }
    }

    public abstract boolean isExpandable();

    public abstract void setContext(EvaluationContextImpl var1);

    public EvaluateException getEvaluateException() {
        return this.myEvaluateException;
    }

    @NlsContexts.Label
    public String getLabel() {
        return this.myLabel;
    }

    public String toString() {
        return this.getLabel();
    }

    protected String setFailed(EvaluateException e) {
        this.myEvaluateException = e;
        return e.getMessage();
    }

    protected String setLabel(@NlsContexts.Label String customLabel) {
        this.myLabel = customLabel;
        return this.myLabel;
    }

    public void clear() {
        this.myEvaluateException = null;
        this.myLabel = UNKNOWN_VALUE_MESSAGE;
    }

    public void setAncestor(NodeDescriptor oldDescriptor) {
        this.displayAs(oldDescriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "key";
        objectArray2[1] = "com/intellij/debugger/ui/impl/watch/NodeDescriptorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "putUserData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

