/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.memory.utils.NamesUtils;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorNameAdjuster;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.OnDemandPresentationProvider;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.debugger.impl.shared.CoroutineUtilsKt;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.ui.JBColor;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.awt.Color;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import javax.swing.Icon;
import kotlin.Unit;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableSharedFlow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class ValueDescriptorImpl
extends NodeDescriptorImpl
implements ValueDescriptor {
    protected final Project myProject;
    private final CompletableFuture<Void> myInitFuture;
    NodeRenderer myRenderer = null;
    NodeRenderer myAutoRenderer = null;
    private final MutableSharedFlow<Unit> myRenderersChangedFlow = CoroutineUtilsKt.createMutableSharedFlow((int)1, (int)1);
    private Value myValue;
    private Value myPreviousValue;
    private EvaluateException myValueException;
    protected EvaluationContextImpl myStoredEvaluationContext = null;
    private String myIdLabel;
    private String myValueText;
    private String myCompactValueText;
    private boolean myFullValue = false;
    @Nullable
    private Icon myValueIcon;
    @Nullable
    private Icon myInlayIcon;
    protected boolean myIsNew = true;
    private boolean myIsDirty = false;
    private boolean myIsLvalue = false;
    private boolean myIsExpandable;
    private boolean myShowIdLabel = true;
    private OnDemandPresentationProvider myOnDemandPresentationProvider = node -> {
        node.setFullValueEvaluator(OnDemandRenderer.createFullValueEvaluator(node, this, JavaDebuggerBundle.message((String)"message.node.evaluate", (Object[])new Object[0])));
        node.setPresentation(AllIcons.Debugger.Db_watch, (XValuePresentation)new XRegularValuePresentation("", null, ""), false);
    };

    protected ValueDescriptorImpl(Project project, Value value) {
        this.myProject = project;
        this.myValue = value;
        this.myInitFuture = CompletableFuture.completedFuture(null);
    }

    protected ValueDescriptorImpl(Project project) {
        this.myProject = project;
        this.myInitFuture = new CompletableFuture();
    }

    private void assertValueReady() {
        if (!this.isValueReady()) {
            LOG.error("Value is not yet calculated for " + String.valueOf(this.getClass()));
        }
    }

    @Override
    public boolean isArray() {
        this.assertValueReady();
        return this.myValue instanceof ArrayReference;
    }

    public boolean isDirty() {
        this.assertValueReady();
        return this.myIsDirty;
    }

    @Override
    public boolean isLvalue() {
        this.assertValueReady();
        return this.myIsLvalue;
    }

    @Override
    public boolean isNull() {
        this.assertValueReady();
        return this.myValue == null;
    }

    @Override
    public boolean isString() {
        this.assertValueReady();
        return this.myValue instanceof StringReference;
    }

    @Override
    public boolean isPrimitive() {
        this.assertValueReady();
        return this.myValue instanceof PrimitiveValue;
    }

    public boolean isEnumConstant() {
        ObjectReference objectReference;
        this.assertValueReady();
        Value value = this.myValue;
        return value instanceof ObjectReference && ValueDescriptorImpl.isEnumConstant(objectReference = (ObjectReference)value);
    }

    public boolean isValueValid() {
        return this.myValueException == null;
    }

    public boolean isShowIdLabel() {
        return this.myShowIdLabel && DebuggerSettings.getInstance().SHOW_TYPES;
    }

    public void setShowIdLabel(boolean showIdLabel) {
        this.myShowIdLabel = showIdLabel;
    }

    public boolean isValueReady() {
        return this.myInitFuture.isDone() && !this.myInitFuture.isCancelled() && !this.myInitFuture.isCompletedExceptionally();
    }

    @Override
    public Value getValue() {
        this.assertValueReady();
        return this.myValue;
    }

    @Override
    public boolean isExpandable() {
        return this.myIsExpandable;
    }

    public abstract Value calcValue(EvaluationContextImpl var1) throws EvaluateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setContext(EvaluationContextImpl evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myStoredEvaluationContext = evaluationContext;
        try {
            Value value = this.calcValue(evaluationContext);
            if (!this.myIsNew) {
                try {
                    FloatValue floatValue;
                    DoubleValue doubleValue;
                    Value value2 = this.myPreviousValue;
                    this.myIsDirty = value2 instanceof DoubleValue && Double.isNaN((doubleValue = (DoubleValue)value2).doubleValue()) ? !(value instanceof DoubleValue) : ((value2 = this.myPreviousValue) instanceof FloatValue && Float.isNaN((floatValue = (FloatValue)value2).floatValue()) ? !(value instanceof FloatValue) : !Objects.equals(value, this.myPreviousValue));
                }
                catch (ObjectCollectedException ignored) {
                    this.myIsDirty = true;
                }
            }
            this.myValue = value;
            this.myValueException = null;
        }
        catch (EvaluateException e) {
            this.myValueException = e;
            this.setFailed(e);
            this.myValue = ValueDescriptorImpl.getTargetExceptionWithStackTraceFilled(evaluationContext, e, this.isPrintExceptionToConsole() || ApplicationManager.getApplication().isUnitTestMode());
            this.myIsExpandable = false;
        }
        finally {
            this.myInitFuture.complete(null);
        }
        this.myIsNew = false;
    }

    protected boolean isPrintExceptionToConsole() {
        return true;
    }

    public void applyOnDemandPresentation(@NotNull XValueNode node) {
        if (node == null) {
            ValueDescriptorImpl.$$$reportNull$$$0(0);
        }
        this.myOnDemandPresentationProvider.setPresentation(node);
    }

    public void setOnDemandPresentationProvider(@NotNull OnDemandPresentationProvider onDemandPresentationProvider) {
        if (onDemandPresentationProvider == null) {
            ValueDescriptorImpl.$$$reportNull$$$0(1);
        }
        this.myOnDemandPresentationProvider = onDemandPresentationProvider;
    }

    @ApiStatus.Internal
    public CompletableFuture<Void> getInitFuture() {
        return this.myInitFuture.thenApply(Function.identity());
    }

    @Nullable
    private static ObjectReference getTargetExceptionWithStackTraceFilled(@Nullable EvaluationContextImpl evaluationContext, EvaluateException ex, boolean printToConsole) {
        ObjectReference exceptionObj = ex.getExceptionFromTargetVM();
        if (exceptionObj != null && evaluationContext != null) {
            try {
                ArrayReference trace = DebuggerUtilsImpl.invokeThrowableGetStackTrace(exceptionObj, evaluationContext, false);
                if (printToConsole && trace != null) {
                    evaluationContext.getDebugProcess().printToConsole(DebuggerUtilsImpl.getExceptionText(evaluationContext, exceptionObj));
                }
            }
            catch (EvaluateException trace) {
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return exceptionObj;
    }

    @Override
    public void setAncestor(NodeDescriptor oldDescriptor) {
        super.setAncestor(oldDescriptor);
        this.myIsNew = false;
        ValueDescriptorImpl other = (ValueDescriptorImpl)oldDescriptor;
        if (other.isValueReady()) {
            this.myPreviousValue = other.getValue();
        }
    }

    protected void setLvalue(boolean value) {
        this.myIsLvalue = value;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebugProcessImpl debugProcess = context.getDebugProcess();
        ((CompletableFuture)this.getRenderer(debugProcess).thenAccept(renderer -> this.calcRepresentation(context, labelListener, debugProcess, (NodeRenderer)renderer))).exceptionally(throwable -> {
            if ((throwable = DebuggerUtilsAsync.unwrap(throwable)) instanceof EvaluateException) {
                this.setValueLabelFailed((EvaluateException)((Object)throwable));
            } else {
                String message;
                if (throwable instanceof CancellationException) {
                    message = JavaDebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]);
                } else if (throwable instanceof VMDisconnectedException || throwable instanceof RejectedExecutionException) {
                    message = JavaDebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]);
                } else {
                    message = JavaDebuggerBundle.message((String)"internal.debugger.error", (Object[])new Object[0]);
                    LOG.error(new Throwable((Throwable)throwable));
                }
                this.setValueLabelFailed(new EvaluateException(message));
            }
            labelListener.labelChanged();
            return null;
        });
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener originalListener, DebugProcessImpl debugProcess, NodeRenderer renderer) {
        DelayedDescriptorLabelListener labelListener = new DelayedDescriptorLabelListener(originalListener);
        DebuggerManagerThreadImpl.assertIsManagerThread();
        EvaluateException valueException = this.myValueException;
        CompletionStage<Boolean> expandableFuture = valueException == null || valueException.getExceptionFromTargetVM() != null ? this.getChildrenRenderer(debugProcess).thenCompose(r -> r.isExpandableAsync(this.getValue(), context, this)) : CompletableFuture.completedFuture(false);
        if (!OnDemandRenderer.isOnDemandForced(debugProcess)) {
            try {
                this.setValueIcon(renderer.calcValueIcon(this, context, labelListener));
            }
            catch (EvaluateException e) {
                LOG.info((Throwable)e);
                this.setValueIcon(null);
            }
            try {
                this.setInlayIcon(renderer.calcInlayIcon(this, context, labelListener));
            }
            catch (EvaluateException e) {
                LOG.info((Throwable)e);
                this.setInlayIcon(null);
            }
        }
        if (this.isShowIdLabel() && renderer instanceof NodeRendererImpl) {
            this.setIdLabel(((NodeRendererImpl)renderer).calcIdLabel(this, debugProcess, labelListener));
        }
        if (valueException == null) {
            long start = renderer instanceof NodeRendererImpl && ((NodeRendererImpl)renderer).hasOverhead() ? System.currentTimeMillis() : 0L;
            try {
                this.setValueLabel(renderer.calcLabel(this, context, labelListener));
            }
            catch (EvaluateException e) {
                this.setValueLabelFailed(e);
            }
            finally {
                if (start > 0L) {
                    OverheadTimings.add(debugProcess, new NodeRendererImpl.Overhead((NodeRendererImpl)renderer), 1L, System.currentTimeMillis() - start);
                }
            }
        } else {
            this.setValueLabelFailed(valueException);
        }
        expandableFuture.whenComplete((res, ex) -> {
            if (ex == null) {
                this.myIsExpandable = res;
            } else if ((ex = DebuggerUtilsAsync.unwrap(ex)) instanceof EvaluateException) {
                LOG.warn(new Throwable((Throwable)ex));
            } else if (!(ex instanceof CancellationException) && !(ex instanceof VMDisconnectedException)) {
                LOG.error(new Throwable((Throwable)ex));
            }
            labelListener.labelChanged();
        });
        labelListener.start();
        return "";
    }

    @Override
    public String getLabel() {
        @NlsSafe String label = this.calcValueName() + this.getDeclaredTypeLabel() + " = " + this.getValueLabel();
        return label;
    }

    public ValueDescriptorImpl getFullValueDescriptor() {
        final Value value = this.getValue();
        ValueDescriptorImpl descriptor = new ValueDescriptorImpl(this.myProject, value){

            @Override
            public Value calcValue(EvaluationContextImpl evaluationContext) {
                return value;
            }

            @Override
            public PsiExpression getDescriptorEvaluation(DebuggerContext context) {
                return null;
            }

            @Override
            public CompletableFuture<NodeRenderer> getRenderer(DebugProcessImpl debugProcess) {
                return ValueDescriptorImpl.this.getRenderer(debugProcess);
            }

            @Override
            public <T> T getUserData(@NotNull Key<T> key) {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                return ValueDescriptorImpl.this.getUserData(key);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/debugger/ui/impl/watch/ValueDescriptorImpl$1", "getUserData"));
            }
        };
        descriptor.myFullValue = true;
        return descriptor;
    }

    @Override
    public void setValueLabel(@NotNull String label) {
        if (label == null) {
            ValueDescriptorImpl.$$$reportNull$$$0(2);
        }
        this.myValueText = this.myFullValue ? label : DebuggerUtilsEx.truncateString(label);
    }

    public void setCompactValueLabel(String label) {
        this.myCompactValueText = label;
    }

    @Nullable
    public String getCompactValueText() {
        return this.myCompactValueText;
    }

    @Override
    public String setValueLabelFailed(EvaluateException e) {
        String label = this.setFailed(e);
        this.setValueLabel(label);
        return label;
    }

    @Override
    public Icon setValueIcon(Icon icon) {
        this.myValueIcon = icon;
        return this.myValueIcon;
    }

    @Nullable
    public Icon getValueIcon() {
        return this.myValueIcon;
    }

    @Nullable
    public Icon getInlayIcon() {
        return this.myInlayIcon;
    }

    public void setInlayIcon(@Nullable Icon icon) {
        this.myInlayIcon = icon;
    }

    public String calcValueName() {
        String name = this.getName();
        NodeDescriptorNameAdjuster nameAdjuster = NodeDescriptorNameAdjuster.findFor((NodeDescriptor)this);
        if (nameAdjuster != null) {
            return nameAdjuster.fixName(name, (NodeDescriptor)this);
        }
        return name;
    }

    @Nullable
    public String getDeclaredType() {
        return null;
    }

    @Override
    public void displayAs(NodeDescriptor descriptor) {
        if (descriptor instanceof ValueDescriptorImpl) {
            ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
            this.myRenderer = valueDescriptor.myRenderer;
            this.myRenderersChangedFlow.tryEmit((Object)Unit.INSTANCE);
        }
        super.displayAs(descriptor);
    }

    @ApiStatus.Internal
    public Flow<@Nullable Renderer> getLastRendererFlow() {
        return CoroutineUtilsKt.mapFlow(this.myRenderersChangedFlow, __ -> this.getLastRenderer());
    }

    public Renderer getLastRenderer() {
        return this.myRenderer != null ? this.myRenderer : this.myAutoRenderer;
    }

    public Renderer getLastLabelRenderer() {
        Renderer lastRenderer = this.getLastRenderer();
        if (lastRenderer instanceof CompoundReferenceRenderer) {
            lastRenderer = ((CompoundReferenceRenderer)lastRenderer).getLabelRenderer();
        }
        return lastRenderer;
    }

    public CompletableFuture<NodeRenderer> getChildrenRenderer(DebugProcessImpl debugProcess) {
        if (OnDemandRenderer.isOnDemandForced(debugProcess)) {
            return this.myInitFuture.thenApply(__ -> DebugProcessImpl.getDefaultRenderer(this.getValue()));
        }
        return this.getRenderer(debugProcess);
    }

    public CompletableFuture<NodeRenderer> getRenderer(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return ((CompletableFuture)this.myInitFuture.thenCompose(__ -> DebuggerUtilsAsync.type(this.getValue()))).thenCompose(type -> this.getRenderer((Type)type, debugProcess));
    }

    protected final CompletableFuture<NodeRenderer> getRenderer(Type type, DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        CompletableFuture<Boolean> customCheck = CompletableFuture.completedFuture(false);
        if (type != null && this.myRenderer != null) {
            customCheck = this.myRenderer.isApplicableAsync(type);
        }
        return customCheck.thenCompose(custom -> {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            if (custom.booleanValue()) {
                return CompletableFuture.completedFuture(this.myRenderer);
            }
            return DebuggerUtilsAsync.reschedule(debugProcess.getAutoRendererAsync(type)).thenApply(r -> {
                this.myAutoRenderer = r;
                this.myRenderersChangedFlow.tryEmit((Object)Unit.INSTANCE);
                return r;
            });
        });
    }

    public void setRenderer(NodeRenderer renderer) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myRenderer = renderer;
        this.myAutoRenderer = null;
        this.myRenderersChangedFlow.tryEmit((Object)Unit.INSTANCE);
    }

    @NotNull
    public CompletableFuture<PsiElement> getTreeEvaluation(JavaValue value, DebuggerContextImpl context) throws EvaluateException {
        Promise res;
        JavaValue parent = value.getParent();
        if (parent != null) {
            ValueDescriptorImpl vDescriptor = parent.getDescriptor();
            CompletionStage completionStage = vDescriptor.getTreeEvaluation(parent, context).thenCompose(parentEvaluation -> {
                if (!(parentEvaluation instanceof PsiExpression)) {
                    return CompletableFuture.completedFuture(null);
                }
                return vDescriptor.getChildrenRenderer(context.getDebugProcess()).thenApply(childrenRenderer -> {
                    try {
                        return (PsiElement)ReadAction.compute(() -> DebuggerTreeNodeExpression.substituteThis(childrenRenderer.getChildValueExpression(new DebuggerTreeNodeMock(value), context), (PsiExpression)parentEvaluation, vDescriptor.getValue()));
                    }
                    catch (EvaluateException e) {
                        throw new CompletionException(e);
                    }
                });
            });
            if (completionStage == null) {
                ValueDescriptorImpl.$$$reportNull$$$0(3);
            }
            return completionStage;
        }
        try {
            PsiElement result = (PsiElement)ReadAction.nonBlocking(() -> this.getDescriptorEvaluation(context)).executeSynchronously();
            res = Promises.resolvedPromise((Object)result);
        }
        catch (Exception wrapper) {
            if (!(wrapper.getCause() instanceof EvaluateException)) {
                throw wrapper;
            }
            Throwable throwable = wrapper.getCause();
            if (!(throwable instanceof NeedMarkException)) {
                throw (EvaluateException)wrapper.getCause();
            }
            NeedMarkException e = (NeedMarkException)((Object)throwable);
            XValueMarkers<?, ?> markers = DebuggerUtilsImpl.getValueMarkers(context.getDebugProcess());
            if (markers != null) {
                Promise promise;
                String markName;
                ValueMarkup existing = markers.getMarkup((XValue)value);
                if (existing != null) {
                    markName = existing.getText();
                    promise = Promises.resolvedPromise();
                } else {
                    markName = e.getMarkName();
                    promise = markers.markValue((XValue)value, new ValueMarkup(markName, (Color)new JBColor(0, 0), null));
                }
                res = promise.then(__ -> (PsiElement)ReadAction.nonBlocking(() -> JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText(markName + "_DebugLabel", PositionUtil.getContextElement((StackFrameContext)context))).executeSynchronously());
            }
            res = Promises.resolvedPromise(null);
        }
        CompletableFuture completableFuture = Promises.asCompletableFuture((Promise)res);
        if (completableFuture == null) {
            ValueDescriptorImpl.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    public abstract PsiExpression getDescriptorEvaluation(DebuggerContext var1) throws EvaluateException;

    public static String getIdLabel(ObjectReference objRef) {
        return ValueDescriptorImpl.calcIdLabel(objRef, null, null);
    }

    @Nullable
    public static String calcIdLabel(ValueDescriptor descriptor, @NotNull DescriptorLabelListener labelListener) {
        Value value;
        if (labelListener == null) {
            ValueDescriptorImpl.$$$reportNull$$$0(5);
        }
        if (!((value = descriptor.getValue()) instanceof ObjectReference)) {
            return null;
        }
        return ValueDescriptorImpl.calcIdLabel((ObjectReference)value, descriptor, labelListener);
    }

    @Nullable
    private static String calcIdLabel(ObjectReference objRef, @Nullable ValueDescriptor descriptor, @Nullable DescriptorLabelListener labelListener) {
        int idx;
        boolean showConcreteType;
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        if (objRef instanceof StringReference && !classRenderer.SHOW_STRINGS_TYPE) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean bl = showConcreteType = !classRenderer.SHOW_DECLARED_TYPE || !(objRef instanceof StringReference) && !(objRef instanceof ClassObjectReference) && !ValueDescriptorImpl.isEnumConstant(objRef);
        if (showConcreteType || classRenderer.SHOW_OBJECT_ID) {
            if (showConcreteType) {
                buf.append(classRenderer.renderTypeName(objRef.type().name()));
            }
            if (classRenderer.SHOW_OBJECT_ID) {
                buf.append('@');
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    buf.append("uniqueID");
                } else {
                    buf.append(objRef.uniqueID());
                }
            }
        }
        if (objRef instanceof ArrayReference && (idx = buf.indexOf("[")) >= 0) {
            if (labelListener == null || descriptor == null) {
                buf.insert(idx + 1, ((ArrayReference)objRef).length());
            } else {
                CompletionStage asyncId = DebuggerUtilsAsync.length((ArrayReference)objRef).thenApply(length -> buf.insert(idx + 1, length).toString());
                if (((CompletableFuture)asyncId).isDone()) {
                    return (String)((CompletableFuture)asyncId).join();
                }
                ((CompletableFuture)asyncId).thenAccept(res -> {
                    descriptor.setIdLabel((String)res);
                    labelListener.labelChanged();
                });
            }
        }
        return buf.toString();
    }

    private static boolean isEnumConstant(ObjectReference objRef) {
        try {
            Type type = objRef.type();
            return type instanceof ClassType && ((ClassType)type).isEnum();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return false;
        }
    }

    public boolean canSetValue() {
        return this.isValueReady() && this.isLvalue();
    }

    @ApiStatus.Internal
    public CompletableFuture<Boolean> canSetValueAsync() {
        return this.myInitFuture.thenApply(__ -> this.isLvalue());
    }

    public XValueModifier getModifier(JavaValue value) {
        return null;
    }

    public String getIdLabel() {
        return this.myIdLabel;
    }

    @Override
    public void setIdLabel(String idLabel) {
        this.myIdLabel = idLabel;
    }

    public String getValueLabel() {
        String label = this.getIdLabel();
        if (!StringUtil.isEmpty((String)label)) {
            return "{" + label + "}" + this.getValueText();
        }
        return this.getValueText();
    }

    @NotNull
    public String getValueText() {
        String string = StringUtil.notNullize((String)this.myValueText);
        if (string == null) {
            ValueDescriptorImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public void clear() {
        super.clear();
        this.setValueLabel("");
        this.myIsExpandable = false;
    }

    public boolean canMark() {
        if (!this.isValueReady()) {
            return false;
        }
        return this.getValue() instanceof ObjectReference;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getDeclaredTypeLabel() {
        String declaredType;
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        if (classRenderer.SHOW_DECLARED_TYPE && !StringUtil.isEmpty((String)(declaredType = this.getDeclaredType()))) {
            String string = ": " + classRenderer.renderTypeName(declaredType);
            if (string == null) {
                ValueDescriptorImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        return "";
    }

    public EvaluationContextImpl getStoredEvaluationContext() {
        return this.myStoredEvaluationContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDemandPresentationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/ValueDescriptorImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/ValueDescriptorImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeEvaluation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredTypeLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyOnDemandPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setOnDemandPresentationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setValueLabel";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcIdLabel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class DelayedDescriptorLabelListener
    implements DescriptorLabelListener {
        private final DescriptorLabelListener myLabelListener;
        private volatile boolean started = false;
        private volatile boolean fired = false;

        DelayedDescriptorLabelListener(DescriptorLabelListener labelListener) {
            this.myLabelListener = labelListener;
        }

        @Override
        public void labelChanged() {
            this.fired = true;
            if (this.started) {
                this.myLabelListener.labelChanged();
            }
        }

        public void start() {
            this.started = true;
            if (this.fired) {
                this.myLabelListener.labelChanged();
            }
        }
    }

    protected static class NeedMarkException
    extends EvaluateException {
        private final String myMarkName;

        public NeedMarkException(ObjectReference reference) {
            super(null);
            this.myMarkName = NamesUtils.getUniqueName(reference).replace("@", "");
        }

        public Throwable fillInStackTrace() {
            return this;
        }

        public String getMarkName() {
            return this.myMarkName;
        }
    }

    private static class DebuggerTreeNodeMock
    implements DebuggerTreeNode {
        private final JavaValue value;

        DebuggerTreeNodeMock(JavaValue value) {
            this.value = value;
        }

        @Override
        public DebuggerTreeNode getParent() {
            return new DebuggerTreeNodeMock(this.value.getParent());
        }

        @Override
        public ValueDescriptorImpl getDescriptor() {
            return this.value.getDescriptor();
        }

        @Override
        public Project getProject() {
            return this.value.getProject();
        }

        @Override
        public void setRenderer(NodeRenderer renderer) {
        }
    }
}

