/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

final class ClassObjectRenderer
extends CompoundRendererProvider {
    private static final Logger LOG = Logger.getInstance(ClassObjectRenderer.class);

    ClassObjectRenderer() {
    }

    @Override
    protected String getName() {
        return "Class";
    }

    @Override
    protected String getClassName() {
        return "java.lang.Class";
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    @Override
    protected FullValueEvaluatorProvider getFullValueEvaluatorProvider() {
        return (evaluationContext, valueDescriptor) -> new JavaValue.JavaFullValueEvaluator(this, JavaDebuggerBundle.message((String)"message.node.navigate", (Object[])new Object[0]), evaluationContext){

            @Override
            public void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                Value value;
                ClassType type;
                Method nameMethod;
                if (callback == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((nameMethod = DebuggerUtils.findMethod((ReferenceType)(type = (ClassType)(value = valueDescriptor.getValue()).type()), (String)"getName", (String)"()Ljava/lang/String;")) != null) {
                    try {
                        DebugProcessImpl process = evaluationContext.getDebugProcess();
                        Value res = process.invokeMethod((EvaluationContext)evaluationContext, (ObjectReference)value, nameMethod, Collections.emptyList());
                        if (res instanceof StringReference) {
                            callback.evaluated("");
                            String className = ((StringReference)res).value();
                            ApplicationManager.getApplication().runReadAction(() -> {
                                PsiClass psiClass = DebuggerUtils.findClass((String)className, (Project)valueDescriptor.getProject(), (GlobalSearchScope)process.getSearchScope());
                                if (psiClass != null) {
                                    PsiElement element = psiClass.getNavigationElement();
                                    DebuggerUIUtil.invokeLater(() -> PsiNavigateUtil.navigate((PsiElement)element));
                                }
                            });
                        }
                    }
                    catch (EvaluateException e) {
                        LOG.info("Exception while getting type name", (Throwable)e);
                    }
                }
            }

            public boolean isShowValuePopup() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/debugger/ui/tree/render/ClassObjectRenderer$1", "evaluate"));
            }
        };
    }
}

