/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FieldVisibilityProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.DescriptorWithParentObject;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.jdi.StringReferenceImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassRenderer
extends NodeRendererImpl {
    private static final Logger LOG = Logger.getInstance(ClassRenderer.class);
    @NonNls
    public static final String UNIQUE_ID = "ClassRenderer";
    public boolean SHOW_SYNTHETICS = true;
    public boolean SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES = true;
    public boolean SHOW_STATIC = false;
    public boolean SHOW_STATIC_FINAL = false;
    public boolean SHOW_FQ_TYPE_NAMES = false;
    public boolean SHOW_DECLARED_TYPE = false;
    public boolean SHOW_OBJECT_ID = true;
    public boolean SHOW_STRINGS_TYPE = false;

    public ClassRenderer() {
        super("unnamed", true);
    }

    @Nullable
    public final String renderTypeName(@Nullable String typeName) {
        if (this.SHOW_FQ_TYPE_NAMES || typeName == null) {
            return typeName;
        }
        String baseLambdaClassName = DebuggerUtilsEx.getLambdaBaseClassName(typeName);
        if (baseLambdaClassName != null) {
            return this.renderTypeName(baseLambdaClassName) + "$lambda";
        }
        int dotIndex = typeName.lastIndexOf(46);
        if (dotIndex > 0) {
            return typeName.substring(dotIndex + 1);
        }
        return typeName;
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public ClassRenderer clone() {
        return (ClassRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
        return ClassRenderer.calcLabelAsync(descriptor, evaluationContext, labelListener);
    }

    private static String calcLabelAsync(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
        CompletableFuture<String> future;
        Value value = descriptor.getValue();
        if (value instanceof StringReferenceImpl) {
            DebuggerUtils.ensureNotInsideObjectConstructor((ObjectReference)((ObjectReference)value), (EvaluationContext)evaluationContext);
            future = DebuggerUtilsAsync.getStringValue((StringReference)value);
        } else {
            future = CompletableFuture.completedFuture(ClassRenderer.calcLabel(descriptor, evaluationContext));
        }
        return ClassRenderer.calcLabelFromFuture(future, descriptor, labelListener);
    }

    private static String calcLabelFromFuture(CompletableFuture<String> future, ValueDescriptor descriptor, DescriptorLabelListener labelListener) {
        if (!future.isDone()) {
            future.whenComplete((s, throwable) -> {
                if (throwable != null) {
                    descriptor.setValueLabelFailed((EvaluateException)((Object)throwable));
                } else {
                    descriptor.setValueLabel((String)s);
                }
                labelListener.labelChanged();
            });
        }
        return future.getNow(XDebuggerUIConstants.getCollectingDataMessage());
    }

    protected static String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext) throws EvaluateException {
        Value value = descriptor.getValue();
        if (value instanceof ObjectReference) {
            if (value instanceof StringReference) {
                DebuggerUtils.ensureNotInsideObjectConstructor((ObjectReference)((ObjectReference)value), (EvaluationContext)evaluationContext);
                return ((StringReference)value).value();
            }
            if (value instanceof ClassObjectReference) {
                ReferenceType type = ((ClassObjectReference)value).reflectedType();
                return type != null ? type.name() : "{...}";
            }
            ObjectReference objRef = (ObjectReference)value;
            Type type = objRef.type();
            if (type instanceof ClassType && ((ClassType)type).isEnum()) {
                String name = ClassRenderer.getEnumConstantName(objRef, (ClassType)type);
                if (name != null) {
                    return name;
                }
                return type.name();
            }
            return "";
        }
        if (value == null) {
            return "null";
        }
        return JavaDebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ValueDescriptorImpl parentDescriptor = (ValueDescriptorImpl)builder.getParentDescriptor();
        NodeManager nodeManager = builder.getNodeManager();
        NodeDescriptorFactory nodeDescriptorFactory = builder.getDescriptorManager();
        if (!(value instanceof ObjectReference)) {
            builder.setChildren(Collections.emptyList());
            return;
        }
        ObjectReference objRef = (ObjectReference)value;
        ReferenceType refType = objRef.referenceType();
        DebuggerUtilsAsync.allFields(refType).thenAccept(fields -> {
            if (fields.isEmpty()) {
                builder.setChildren(Collections.singletonList(nodeManager.createMessageNode(MessageDescriptor.CLASS_HAS_NO_FIELDS.getLabel())));
                return;
            }
            this.createNodesToShow((List<Field>)fields, evaluationContext, parentDescriptor, nodeManager, nodeDescriptorFactory, objRef).thenAccept(nodesToShow -> {
                if (nodesToShow.isEmpty()) {
                    this.setClassHasNoFieldsToDisplayMessage(builder, nodeManager);
                    return;
                }
                builder.setChildren((List<? extends DebuggerTreeNode>)nodesToShow);
            });
        });
    }

    protected void setClassHasNoFieldsToDisplayMessage(ChildrenBuilder builder, NodeManager nodeManager) {
        builder.setChildren(Collections.singletonList(nodeManager.createMessageNode(JavaDebuggerBundle.message((String)"message.node.class.no.fields.to.display", (Object[])new Object[0]))));
    }

    protected CompletableFuture<List<DebuggerTreeNode>> createNodesToShow(List<Field> fields, EvaluationContext evaluationContext, ValueDescriptorImpl parentDescriptor, NodeManager nodeManager, NodeDescriptorFactory nodeDescriptorFactory, ObjectReference objRef) {
        List fieldsToShow = ContainerUtil.filter(fields, field -> this.shouldDisplay(evaluationContext, objRef, (Field)field));
        if (fieldsToShow.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture[] futures = this.createNodesChunked(fieldsToShow, evaluationContext, parentDescriptor, nodeManager, nodeDescriptorFactory, objRef);
        return CompletableFuture.allOf(futures).thenApply(__ -> StreamEx.of((Object[])futures).flatCollection(CompletableFuture::join).toList());
    }

    private CompletableFuture<List<DebuggerTreeNode>>[] createNodesChunked(List<Field> fields, EvaluationContext evaluationContext, ValueDescriptorImpl parentDescriptor, NodeManager nodeManager, NodeDescriptorFactory nodeDescriptorFactory, ObjectReference objRef) {
        List<List<Field>> chunks = DebuggerUtilsImpl.partition(fields, 100);
        Set names = Collections.synchronizedSet(new HashSet());
        return (CompletableFuture[])chunks.stream().map(l -> this.createNodes((List<Field>)l, evaluationContext, parentDescriptor, nodeManager, nodeDescriptorFactory, objRef, names)).toArray(CompletableFuture[]::new);
    }

    private CompletableFuture<List<DebuggerTreeNode>> createNodes(List<Field> fields, EvaluationContext evaluationContext, ValueDescriptorImpl parentDescriptor, NodeManager nodeManager, NodeDescriptorFactory nodeDescriptorFactory, ObjectReference objRef, Set<String> names) {
        return DebuggerUtilsAsync.getValues(objRef, fields).thenApply(cachedValues -> {
            ArrayList<DebuggerTreeNode> res = new ArrayList<DebuggerTreeNode>(fields.size());
            for (Field field : fields) {
                FieldDescriptorImpl fieldDescriptor = (FieldDescriptorImpl)this.createFieldDescriptor(parentDescriptor, nodeDescriptorFactory, objRef, field, evaluationContext);
                if (cachedValues != null) {
                    fieldDescriptor.setValue((Value)cachedValues.get(field));
                }
                if (!names.add(fieldDescriptor.getName())) {
                    fieldDescriptor.putUserData(FieldDescriptor.SHOW_DECLARING_TYPE, Boolean.TRUE);
                }
                res.add(nodeManager.createNode(fieldDescriptor, evaluationContext));
            }
            return res;
        });
    }

    @NotNull
    protected FieldDescriptor createFieldDescriptor(ValueDescriptorImpl parentDescriptor, NodeDescriptorFactory nodeDescriptorFactory, ObjectReference objRef, Field field, EvaluationContext evaluationContext) {
        FieldDescriptor fieldDescriptor = nodeDescriptorFactory.getFieldDescriptor(parentDescriptor, objRef, field);
        if (fieldDescriptor == null) {
            ClassRenderer.$$$reportNull$$$0(0);
        }
        return fieldDescriptor;
    }

    protected boolean shouldDisplay(EvaluationContext context, @NotNull ObjectReference objInstance, @NotNull Field field) {
        if (objInstance == null) {
            ClassRenderer.$$$reportNull$$$0(1);
        }
        if (field == null) {
            ClassRenderer.$$$reportNull$$$0(2);
        }
        boolean isSynthetic = DebuggerUtils.isSynthetic((TypeComponent)field);
        if (!this.SHOW_SYNTHETICS && isSynthetic) {
            return false;
        }
        if (this.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES && isSynthetic) {
            try {
                Location location;
                StackFrameProxy frameProxy = context.getFrameProxy();
                if (frameProxy != null && (location = frameProxy.location()) != null && objInstance.equals(context.computeThisObject()) && Comparing.equal((Object)objInstance.referenceType(), (Object)location.declaringType()) && StringUtil.startsWith((CharSequence)field.name(), (CharSequence)"val$")) {
                    return false;
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        if (!this.SHOW_STATIC && field.isStatic()) {
            return false;
        }
        if (!this.SHOW_STATIC_FINAL && field.isStatic() && field.isFinal()) {
            return false;
        }
        return FieldVisibilityProvider.shouldDisplayField((Field)field);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.write((Object)this, (Element)element, (Predicate)new DifferenceFilter((Object)this, (Object)new ClassRenderer()));
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        DescriptorWithParentObject descriptor = (DescriptorWithParentObject)node.getDescriptor();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)node.getProject());
        try {
            return elementFactory.createExpressionFromText("this." + descriptor.getName(), (PsiElement)DebuggerUtils.findClass((String)descriptor.getObject().referenceType().name(), (Project)context.getProject(), (GlobalSearchScope)context.getDebugProcess().getSearchScope()));
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(JavaDebuggerBundle.message((String)"error.invalid.field.name", (Object[])new Object[]{descriptor.getName()}), null);
        }
    }

    @Override
    public CompletableFuture<Boolean> isExpandableAsync(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (value instanceof ArrayReference) {
            return ((CompletableFuture)DebuggerUtilsAsync.length((ArrayReference)value).thenApply(r -> r > 0)).exceptionally(throwable -> true);
        }
        if (value instanceof ObjectReference) {
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public boolean isApplicable(Type type) {
        return type instanceof ReferenceType && !(type instanceof ArrayType);
    }

    @Override
    @NonNls
    public String getName() {
        return "Object";
    }

    @Override
    public void setName(String text) {
        LOG.assertTrue(false);
    }

    @Nullable
    public static String getEnumConstantName(@NotNull ObjectReference objRef, ClassType classType) {
        if (objRef == null) {
            ClassRenderer.$$$reportNull$$$0(3);
        }
        do {
            if (!classType.isPrepared()) {
                return null;
            }
            if ((classType = classType.superclass()) != null) continue;
            return null;
        } while (!"java.lang.Enum".equals(classType.name()));
        Field field = DebuggerUtils.findField((ReferenceType)classType, (String)"name");
        if (field == null) {
            return null;
        }
        Value value = objRef.getValue(field);
        if (!(value instanceof StringReference)) {
            return null;
        }
        return ((StringReference)value).value();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/tree/render/ClassRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objInstance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/tree/render/ClassRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldDisplay";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEnumConstantName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

