/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.FileObjectRenderer;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\u0005H\u0014J\b\u0010\t\u001a\u00020\nH\u0014J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/debugger/ui/tree/render/FileObjectRenderer;", "Lcom/intellij/debugger/ui/tree/render/CompoundRendererProvider;", "<init>", "()V", "getName", "", "getChildrenRenderer", "Lcom/intellij/debugger/ui/tree/render/ChildrenRenderer;", "getClassName", "isEnabled", "", "getFullValueEvaluatorProvider", "Lcom/intellij/debugger/engine/FullValueEvaluatorProvider;", "intellij.java.debugger.impl"})
public final class FileObjectRenderer
extends CompoundRendererProvider {
    @Override
    @NotNull
    protected String getName() {
        return "File";
    }

    @Override
    @NotNull
    protected ChildrenRenderer getChildrenRenderer() {
        ExpressionChildrenRenderer expressionChildrenRenderer = NodeRendererSettings.createExpressionChildrenRenderer("listFiles()", null);
        Intrinsics.checkNotNullExpressionValue((Object)expressionChildrenRenderer, (String)"createExpressionChildrenRenderer(...)");
        return expressionChildrenRenderer;
    }

    @Override
    @NotNull
    protected String getClassName() {
        return "java.io.File";
    }

    @Override
    protected boolean isEnabled() {
        return Registry.Companion.is("debugger.renderers.file");
    }

    @Override
    @Nullable
    protected FullValueEvaluatorProvider getFullValueEvaluatorProvider() {
        return new FullValueEvaluatorProvider(){

            public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, ValueDescriptorImpl valueDescriptor) {
                Intrinsics.checkNotNullParameter((Object)((Object)evaluationContext), (String)"evaluationContext");
                Intrinsics.checkNotNullParameter((Object)valueDescriptor, (String)"valueDescriptor");
                Object object = valueDescriptor.getValue();
                ObjectReference objectReference = object instanceof ObjectReference ? (ObjectReference)object : null;
                if (objectReference == null) {
                    return null;
                }
                ObjectReference value = objectReference;
                try {
                    Value isFile = DebuggerUtilsImpl.invokeObjectMethod(evaluationContext, value, "isFile", "()Z", CollectionsKt.emptyList());
                    BooleanValue booleanValue = isFile instanceof BooleanValue ? (BooleanValue)isFile : null;
                    boolean bl = booleanValue != null ? booleanValue.value() : false;
                    if (bl) {
                        object = JavaDebuggerBundle.message((String)"message.node.open", (Object[])new Object[0]);
                        return new JavaValue.JavaFullValueEvaluator(evaluationContext, value, (String)object){
                            final /* synthetic */ EvaluationContextImpl $evaluationContext;
                            final /* synthetic */ ObjectReference $value;
                            {
                                this.$evaluationContext = $evaluationContext;
                                this.$value = $value;
                                super($super_call_param$1, $evaluationContext);
                            }

                            public boolean isShowValuePopup() {
                                return false;
                            }

                            public void evaluate(XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                                Value path = DebuggerUtilsImpl.invokeObjectMethod(this.$evaluationContext, this.$value, "getAbsolutePath", "()Ljava/lang/String;", CollectionsKt.emptyList());
                                if (path instanceof StringReference) {
                                    callback.evaluated("");
                                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(((StringReference)path).value());
                                    if (virtualFile == null) {
                                        return;
                                    }
                                    VirtualFile vFile = virtualFile;
                                    DebuggerUIUtil.invokeLater(() -> getFullValueEvaluatorProvider.getFullValueEvaluator.1.evaluate$lambda$0(this.$evaluationContext, vFile));
                                }
                            }

                            private static final void evaluate$lambda$0(EvaluationContextImpl $evaluationContext, VirtualFile $vFile) {
                                PsiNavigationSupport.getInstance().createNavigatable($evaluationContext.getProject(), $vFile, -1).navigate(true);
                            }
                        };
                    }
                }
                catch (EvaluateException evaluateException) {
                    // empty catch block
                }
                return null;
            }
        };
    }
}

