/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.ui.tree.render.AbstractImageRenderer;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public final class GraphicsObjectRenderer
extends AbstractImageRenderer {
    @Override
    protected String getName() {
        return "Graphics";
    }

    @Override
    protected String getClassName() {
        return "sun.java2d.SunGraphics2D";
    }

    @Override
    protected FullValueEvaluatorProvider getFullValueEvaluatorProvider() {
        return (evaluationContext, valueDescriptor) -> {
            try {
                ObjectReference value = (ObjectReference)valueDescriptor.getValue();
                Field surfaceField = DebuggerUtils.findField((ReferenceType)((ClassType)value.type()), (String)"surfaceData");
                if (surfaceField == null) {
                    return null;
                }
                ObjectReference surfaceDataValue = (ObjectReference)value.getValue(surfaceField);
                if (surfaceDataValue == null) {
                    return null;
                }
                Field imgField = DebuggerUtils.findField((ReferenceType)((ReferenceType)surfaceDataValue.type()), (String)"bufImg");
                if (imgField == null) {
                    imgField = DebuggerUtils.findField((ReferenceType)((ReferenceType)surfaceDataValue.type()), (String)"offscreenImage");
                }
                if (imgField == null) {
                    return null;
                }
                Value bufImgValue = surfaceDataValue.getValue(imgField);
                Type type = bufImgValue.type();
                if (!(type instanceof ReferenceType) || !DebuggerUtils.instanceOf((Type)type, (String)"java.awt.Image")) {
                    return null;
                }
                return this.createImagePopupEvaluator(JavaDebuggerBundle.message((String)"message.node.show.image", (Object[])new Object[0]), evaluationContext, bufImgValue, "imageToBytes");
            }
            catch (Exception exception) {
                return null;
            }
        };
    }
}

