/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.StackTraceElementObjectRenderer;
import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/debugger/ui/tree/render/StackTraceElementObjectRenderer;", "Lcom/intellij/debugger/ui/tree/render/CompoundRendererProvider;", "<init>", "()V", "getName", "", "getClassName", "isEnabled", "", "getFullValueEvaluatorProvider", "Lcom/intellij/debugger/engine/FullValueEvaluatorProvider;", "intellij.java.debugger.impl"})
public final class StackTraceElementObjectRenderer
extends CompoundRendererProvider {
    @Override
    @NotNull
    protected String getName() {
        return "StackTraceElement";
    }

    @Override
    @NotNull
    protected String getClassName() {
        return "java.lang.StackTraceElement";
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    @Override
    @NotNull
    protected FullValueEvaluatorProvider getFullValueEvaluatorProvider() {
        return new FullValueEvaluatorProvider(){

            public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, ValueDescriptorImpl valueDescriptor) {
                Intrinsics.checkNotNullParameter((Object)((Object)evaluationContext), (String)"evaluationContext");
                Intrinsics.checkNotNullParameter((Object)valueDescriptor, (String)"valueDescriptor");
                Value value = valueDescriptor.getValue();
                ObjectReference objectReference = value instanceof ObjectReference ? (ObjectReference)value : null;
                if (objectReference == null) {
                    return null;
                }
                ObjectReference value2 = objectReference;
                String string = JavaDebuggerBundle.message((String)"message.node.navigate", (Object[])new Object[0]);
                return new JavaValue.JavaFullValueEvaluator(evaluationContext, value2, valueDescriptor, string){
                    final /* synthetic */ EvaluationContextImpl $evaluationContext;
                    final /* synthetic */ ObjectReference $value;
                    final /* synthetic */ ValueDescriptorImpl $valueDescriptor;
                    {
                        this.$evaluationContext = $evaluationContext;
                        this.$value = $value;
                        this.$valueDescriptor = $valueDescriptor;
                        super($super_call_param$1, $evaluationContext);
                    }

                    public boolean isShowValuePopup() {
                        return false;
                    }

                    public void evaluate(XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                        try {
                            Value res = DebuggerUtilsImpl.invokeObjectMethod(this.$evaluationContext, this.$value, "toString", "()Ljava/lang/String;", CollectionsKt.emptyList());
                            if (res instanceof StringReference) {
                                callback.evaluated("");
                                String line = ((StringReference)res).value();
                                ReadAction.run(() -> getFullValueEvaluatorProvider.getFullValueEvaluator.1.evaluate$lambda$0(this.$valueDescriptor, this.$evaluationContext, line));
                            }
                        }
                        catch (EvaluateException e) {
                            boolean $i$f$logger = false;
                            Logger logger = Logger.getInstance(StackTraceElementObjectRenderer.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.info("Exception while getting stack info", (Throwable)e);
                        }
                    }

                    private static final void evaluate$lambda$0$0(HyperlinkInfo $info, Project $project) {
                        Intrinsics.checkNotNull((Object)$project);
                        $info.navigate($project);
                    }

                    private static final void evaluate$lambda$0(ValueDescriptorImpl $valueDescriptor, EvaluationContextImpl $evaluationContext, String $line) {
                        HyperlinkInfo info;
                        Project project = $valueDescriptor.getProject();
                        ExceptionFilter filter = new ExceptionFilter(project, $evaluationContext.getDebugProcess().getSession().getSearchScope());
                        Filter.Result result = filter.applyFilter($line, $line.length());
                        if (result != null && (info = result.getFirstHyperlinkInfo()) != null) {
                            DebuggerUIUtil.invokeLater(() -> getFullValueEvaluatorProvider.getFullValueEvaluator.1.evaluate$lambda$0$0(info, project));
                        }
                    }
                };
            }
        };
    }
}

