/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ProjectSdkSetupValidator;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkPopupBuilder;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProjectSdkSetupValidator
implements ProjectSdkSetupValidator {
    public static final JavaProjectSdkSetupValidator INSTANCE = new JavaProjectSdkSetupValidator();

    public boolean isApplicableFor(@NotNull Project project2, @NotNull VirtualFile file) {
        PsiFile psiFile;
        if (project2 == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(1);
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaClassFileType.INSTANCE) && (psiFile = PsiManager.getInstance((Project)project2).findFile(file)) != null) {
            return psiFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
        }
        return false;
    }

    @Nullable
    public String getErrorMessage(@NotNull Project project2, @NotNull VirtualFile file) {
        Module module;
        if (project2 == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project2)) != null && !module.isDisposed()) {
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk == null) {
                if (ModuleRootManager.getInstance((Module)module).isSdkInherited()) {
                    return JavaUiBundle.message("project.sdk.not.defined", new Object[0]);
                }
                return JavaUiBundle.message("module.sdk.not.defined", new Object[0]);
            }
            if (SdkDownloadTracker.getInstance().isDownloading(sdk)) {
                return null;
            }
            if (sdk.getSdkType().equals((Object)JavaSdk.getInstance()) && sdk.getRootProvider().getFiles(OrderRootType.CLASSES).length == 0) {
                return JavaUiBundle.message("project.or.module.jdk.misconfigured", ModuleRootManager.getInstance((Module)module).isSdkInherited() ? 0 : 1);
            }
        } else if (ScratchUtil.isScratch((VirtualFile)file) && ProjectRootManager.getInstance((Project)project2).getProjectSdk() == null) {
            return JavaUiBundle.message("project.sdk.not.defined", new Object[0]);
        }
        return null;
    }

    @NotNull
    private static SdkPopupBuilder preparePopup(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(4);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(5);
        }
        SdkPopupBuilder sdkPopupBuilder = SdkPopupFactory.newBuilder().withProject(project2).withSdkTypeFilter(type -> type instanceof JavaSdkType).updateSdkForFile(file);
        if (sdkPopupBuilder == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(6);
        }
        return sdkPopupBuilder;
    }

    @NotNull
    public EditorNotificationPanel.ActionHandler getFixHandler(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(7);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(8);
        }
        EditorNotificationPanel.ActionHandler actionHandler = JavaProjectSdkSetupValidator.preparePopup(project2, file).buildEditorNotificationPanelHandler();
        if (actionHandler == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(9);
        }
        return actionHandler;
    }

    @Deprecated
    public void doFix(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(10);
        }
        if (file == null) {
            JavaProjectSdkSetupValidator.$$$reportNull$$$0(11);
        }
        JavaProjectSdkSetupValidator.preparePopup(project2, file).buildPopup().showInFocusCenter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaProjectSdkSetupValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaProjectSdkSetupValidator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePopup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preparePopup";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFixHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9 -> new IllegalStateException(string);
        };
    }
}

